/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.solver.search.set;

import choco.kernel.common.util.tools.VariableUtils;
import choco.kernel.solver.Solver;
import choco.kernel.solver.branch.VarSelector;
import choco.kernel.solver.search.AbstractSearchHeuristic;
import choco.kernel.solver.variables.set.SetVar;

public abstract class AbstractSetVarSelector
extends AbstractSearchHeuristic
implements VarSelector<SetVar> {
    protected final SetVar[] vars;

    public AbstractSetVarSelector(Solver solver) {
        this(solver, VariableUtils.getSetVars(solver));
    }

    public AbstractSetVarSelector(Solver solver, SetVar[] vars) {
        super(solver);
        this.vars = vars;
    }

    @Override
    public SetVar selectVar() {
        int min = Integer.MAX_VALUE;
        SetVar v0 = null;
        for (SetVar v : this.vars) {
            int domSize;
            if (v.isInstantiated() || (domSize = this.getHeuristic(v)) >= min) continue;
            min = domSize;
            v0 = v;
        }
        return v0;
    }

    public SetVar[] getVars() {
        return this.vars;
    }

    @Deprecated
    public void setVars(SetVar[] vars) {
        throw new UnsupportedOperationException("setVars is final");
    }

    public abstract int getHeuristic(SetVar var1);
}

