## ----setup, include = FALSE---------------------------------------------------
library(MinTriadic)
library(network)
library(lolog)

## ----example------------------------------------------------------------------
# Load required libraries
library(MinTriadic)
library(lolog)
library(network)

# Register the triadic change statistic
registerMinTriadicClosure()

# Load the Lazega collaboration network
data(lazega, package = "lolog")

# Fit LOLOG model with edges and minTriadicClosure
model <- lolog(lazega ~ edges + minTriadicClosure(k = 2, alpha = 1.5), verbose = FALSE)

# View model summary
summary(model)

