/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Instance_Generation.DEGL;

import keel.Algorithms.Instance_Generation.Basic.Prototype;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerationAlgorithm;
import keel.Algorithms.Instance_Generation.Basic.PrototypeGenerator;
import keel.Algorithms.Instance_Generation.Basic.PrototypeSet;
import keel.Algorithms.Instance_Generation.utilities.KNN.KNN;
import keel.Algorithms.Instance_Generation.utilities.Parameters;
import keel.Algorithms.Instance_Generation.utilities.RandomGenerator;

public class DEGLGenerator
extends PrototypeGenerator {
    private int k;
    private int PopulationSize;
    private int ParticleSize;
    private int MaxIter;
    private double ScalingFactor;
    private double CrossOverRate;
    private double WeightFactor;
    private double[] WeightFactorAdap;
    private int neighboors;
    private String WeightScheme;
    protected int numberOfPrototypes;
    protected int numberOfClass;
    private String[] paramsOfInitialReducction = null;

    public DEGLGenerator(PrototypeSet _trainingDataSet, int neigbors, int poblacion, int perc, int iteraciones, double F, double CR, int strg) {
        super(_trainingDataSet);
        this.algorithmName = "DEGL";
        this.k = neigbors;
        this.PopulationSize = poblacion;
        this.ParticleSize = perc;
        this.MaxIter = iteraciones;
        this.numberOfPrototypes = this.getSetSizeFromPercentage(perc);
        this.ScalingFactor = F;
    }

    public DEGLGenerator(PrototypeSet t, Parameters parameters) {
        super(t, parameters);
        this.algorithmName = "DEGL";
        this.k = parameters.getNextAsInt();
        this.PopulationSize = parameters.getNextAsInt();
        this.ParticleSize = parameters.getNextAsInt();
        this.MaxIter = parameters.getNextAsInt();
        this.ScalingFactor = parameters.getNextAsDouble();
        this.CrossOverRate = parameters.getNextAsDouble();
        this.WeightFactor = parameters.getNextAsDouble();
        this.neighboors = parameters.getNextAsInt();
        this.WeightScheme = parameters.getNextAsString();
        this.numberOfPrototypes = this.getSetSizeFromPercentage(this.ParticleSize);
        this.numberOfClass = this.trainingDataSet.getPosibleValuesOfOutput().size();
        System.out.print("\nIsaac dice:  " + this.k + " Swar= " + this.PopulationSize + " Particle=  " + this.ParticleSize + " Maxiter= " + this.MaxIter + " CR=  " + this.CrossOverRate + "\n");
    }

    public PrototypeSet mutant(PrototypeSet[] population, int actual, int bestFitnessIndex, int bestNeighboor) {
        int ran2;
        int ran1;
        int qrandom;
        int prandom;
        PrototypeSet mutant = new PrototypeSet(population[actual].size());
        PrototypeSet nbest = population[bestNeighboor].clone();
        int inferior = (actual - this.neighboors) % this.PopulationSize;
        int superior = (actual + this.neighboors) % this.PopulationSize;
        if (inferior < 0) {
            inferior *= -1;
        }
        if (superior < 0) {
            superior *= -1;
        }
        do {
            prandom = RandomGenerator.Randint(inferior, superior);
            qrandom = RandomGenerator.Randint(inferior, superior);
        } while (prandom != actual && qrandom != prandom && qrandom != actual);
        PrototypeSet p = population[prandom].clone();
        PrototypeSet q = population[qrandom].clone();
        PrototypeSet resta1 = nbest.restar(population[actual]);
        PrototypeSet resta2 = p.restar(q);
        PrototypeSet producto1 = resta1.mulEscalar(this.ScalingFactor);
        PrototypeSet producto2 = resta2.mulEscalar(this.ScalingFactor);
        PrototypeSet suma = producto1.sumar(producto2);
        PrototypeSet Local = population[actual].sumar(suma);
        PrototypeSet xbest = population[bestFitnessIndex].clone();
        do {
            ran1 = RandomGenerator.Randint(0, this.PopulationSize);
            ran2 = RandomGenerator.Randint(0, this.PopulationSize);
        } while (ran1 != actual && ran2 != ran1 && ran2 != actual);
        PrototypeSet r1 = population[ran1].clone();
        PrototypeSet r2 = population[ran2].clone();
        resta1 = r1.restar(r2);
        resta2 = xbest.restar(population[actual]);
        producto1 = resta1.mulEscalar(this.ScalingFactor);
        producto2 = resta2.mulEscalar(this.ScalingFactor);
        suma = producto1.sumar(producto2);
        PrototypeSet Global = population[actual].sumar(suma);
        if (this.WeightScheme.equals("Adaptive")) {
            producto1 = Global.mulEscalar(this.WeightFactorAdap[actual]);
            producto2 = Local.mulEscalar(1.0 - this.WeightFactorAdap[actual]);
        } else {
            producto1 = Global.mulEscalar(this.WeightFactor);
            producto2 = Local.mulEscalar(1.0 - this.WeightFactor);
        }
        mutant = producto1.sumar(producto2);
        mutant.applyThresholds();
        return mutant;
    }

    @Override
    public PrototypeSet reduceSet() {
        PrototypeSet nominalPopulation;
        int i;
        int i2;
        int j;
        int i3;
        System.out.print("\nThe algorithm  DEGL is starting...\n Computing...\n");
        System.out.println("Number of prototypes, result set = " + this.numberOfPrototypes + "\n");
        if (this.numberOfPrototypes < this.trainingDataSet.getPosibleValuesOfOutput().size()) {
            System.out.println("Number of prototypes less than the number of clases");
            this.numberOfPrototypes = this.trainingDataSet.getPosibleValuesOfOutput().size();
        }
        System.out.println("Reduction %, result set = " + (this.trainingDataSet.size() - this.numberOfPrototypes) * 100 / this.trainingDataSet.size() + "\n");
        PrototypeSet[] population = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] mutation = new PrototypeSet[this.PopulationSize];
        PrototypeSet[] crossover = new PrototypeSet[this.PopulationSize];
        double[] fitness = new double[this.PopulationSize];
        double[] fitness_bestPopulation = new double[this.PopulationSize];
        PrototypeSet bestParticle = new PrototypeSet();
        population[0] = this.selecRandomSet(this.numberOfPrototypes, true).clone();
        fitness[0] = DEGLGenerator.accuracy(population[0], this.trainingDataSet);
        PrototypeSet[] clases = new PrototypeSet[this.numberOfClass];
        for (i3 = 0; i3 < this.numberOfClass; ++i3) {
            clases[i3] = new PrototypeSet(this.trainingDataSet.getFromClass(i3));
        }
        for (i3 = 0; i3 < population[0].size(); ++i3) {
            for (j = 0; j < this.numberOfClass; ++j) {
                if (population[0].getFromClass(j).size() != 0 || clases[j].size() == 0) continue;
                population[0].add(clases[j].getRandom());
            }
        }
        for (i3 = 1; i3 < this.PopulationSize; ++i3) {
            population[i3] = new PrototypeSet();
            for (j = 0; j < population[0].size(); ++j) {
                population[i3].add(this.trainingDataSet.getFromClass(((Prototype)population[0].get(j)).getOutput(0)).getRandom());
            }
            fitness[i3] = DEGLGenerator.accuracy(population[i3], this.trainingDataSet);
        }
        double bestFitness = fitness[0];
        int bestFitnessIndex = 0;
        for (i2 = 1; i2 < this.PopulationSize; ++i2) {
            if (!(fitness[i2] > bestFitness)) continue;
            bestFitness = fitness[i2];
            bestFitnessIndex = i2;
        }
        System.out.println("Best initial Fitness " + bestFitness);
        for (int j2 = 0; j2 < this.PopulationSize; ++j2) {
            for (i = 0; i < population[j2].size(); ++i) {
                ((Prototype)population[j2].get(i)).setIndex(i);
            }
        }
        if (this.WeightScheme.equals("Adaptive")) {
            this.WeightFactorAdap = new double[this.PopulationSize];
            for (i2 = 0; i2 < this.PopulationSize; ++i2) {
                this.WeightFactorAdap[i2] = RandomGenerator.Randdouble(0.0, 1.0);
            }
        }
        for (int iter = 0; iter < this.MaxIter; ++iter) {
            for (i = 0; i < this.PopulationSize; ++i) {
                int j3;
                mutation[i] = new PrototypeSet(population[i].size());
                int bestNeighboor = 0;
                double bestFitnessNeighboor = Double.MIN_VALUE;
                for (j3 = i - this.neighboors; j3 < i + this.neighboors; ++j3) {
                    int pos = (i + j3) % this.PopulationSize;
                    if (pos < 0) {
                        pos *= -1;
                    }
                    if (!(fitness[pos] > bestFitnessNeighboor)) continue;
                    bestFitnessNeighboor = fitness[pos];
                    bestNeighboor = pos;
                }
                mutation[i] = this.mutant(population, i, bestFitnessIndex, bestNeighboor).clone();
                crossover[i] = new PrototypeSet();
                for (j3 = 0; j3 < population[i].size(); ++j3) {
                    double randNumber = RandomGenerator.Randdouble(0.0, 1.0);
                    if (randNumber < this.CrossOverRate) {
                        crossover[i].add(mutation[i].get(j3));
                        continue;
                    }
                    crossover[i].add(population[i].get(j3));
                }
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(population[i]);
                fitness[i] = DEGLGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                nominalPopulation = new PrototypeSet();
                nominalPopulation.formatear(crossover[i]);
                double trialVector = DEGLGenerator.accuracy(nominalPopulation, this.trainingDataSet);
                if (trialVector > fitness[i]) {
                    population[i] = crossover[i].clone();
                    fitness[i] = trialVector;
                }
                if (!(fitness[i] > bestFitness)) continue;
                bestFitness = fitness[i];
                bestFitnessIndex = i;
                System.out.println("Iter=" + iter + " Acc= " + bestFitness);
            }
            if (this.WeightScheme.equals("Linear")) {
                this.WeightFactor = (double)(iter / this.MaxIter) * 1.0;
                continue;
            }
            if (this.WeightScheme.equals("Exponential")) {
                this.WeightFactor = Math.exp((double)(iter / this.MaxIter) * 1.0 * Math.log1p(2.0)) - 1.0;
                continue;
            }
            if (this.WeightScheme.equals("Random")) {
                this.WeightFactor = RandomGenerator.Randdouble(0.0, 1.0);
                continue;
            }
            if (!this.WeightScheme.equals("Adaptive")) continue;
            for (i = 0; i < this.PopulationSize; ++i) {
                int ran2;
                int ran1;
                double prod = this.ScalingFactor * (this.WeightFactorAdap[bestFitnessIndex] - this.WeightFactorAdap[i]);
                do {
                    ran1 = RandomGenerator.Randint(0, this.PopulationSize);
                    ran2 = RandomGenerator.Randint(0, this.PopulationSize);
                } while (ran1 != i && ran2 != ran1 && ran2 != i);
                double prod2 = this.ScalingFactor * (this.WeightFactorAdap[ran1] - this.WeightFactorAdap[ran2]);
                int n = i;
                this.WeightFactorAdap[n] = this.WeightFactorAdap[n] + (prod + prod2);
                if (this.WeightFactorAdap[i] > 0.95) {
                    this.WeightFactorAdap[i] = 0.95;
                    continue;
                }
                if (!(this.WeightFactorAdap[i] < 0.05)) continue;
                this.WeightFactorAdap[i] = 0.05;
            }
        }
        nominalPopulation = new PrototypeSet();
        nominalPopulation.formatear(population[bestFitnessIndex]);
        System.err.println("\n% de acierto en training Nominal " + (double)KNN.classficationAccuracy(nominalPopulation, this.trainingDataSet, 1) * 100.0 / (double)this.trainingDataSet.size());
        return nominalPopulation;
    }

    public static void main(String[] args) {
        Parameters.setUse("DEGL", "<seed> <Number of neighbors>\n<Swarm size>\n<Particle Size>\n<MaxIter>\n<DistanceFunction>");
        Parameters.assertBasicArgs(args);
        PrototypeSet training = PrototypeGenerationAlgorithm.readPrototypeSet(args[0]);
        PrototypeSet test = PrototypeGenerationAlgorithm.readPrototypeSet(args[1]);
        long seed = Parameters.assertExtendedArgAsInt(args, 2, "seed", 0.0, 9.223372036854776E18);
        DEGLGenerator.setSeed(seed);
        int k = Parameters.assertExtendedArgAsInt(args, 3, "number of neighbors", 1.0, 2.147483647E9);
        int swarm = Parameters.assertExtendedArgAsInt(args, 4, "swarm size", 1.0, 2.147483647E9);
        int particle = Parameters.assertExtendedArgAsInt(args, 5, "particle size", 1.0, 2.147483647E9);
        int iter = Parameters.assertExtendedArgAsInt(args, 6, "max iter", 1.0, 2.147483647E9);
        double c1 = Parameters.assertExtendedArgAsInt(args, 7, "c1", 1.0, Double.MAX_VALUE);
        double c2 = Parameters.assertExtendedArgAsInt(args, 8, "c2", 1.0, Double.MAX_VALUE);
        double vmax = Parameters.assertExtendedArgAsInt(args, 9, "vmax", 1.0, Double.MAX_VALUE);
        double wstart = Parameters.assertExtendedArgAsInt(args, 10, "wstart", 1.0, Double.MAX_VALUE);
        double wend = Parameters.assertExtendedArgAsInt(args, 11, "wend", 1.0, Double.MAX_VALUE);
        DEGLGenerator generator = new DEGLGenerator(training, k, swarm, particle, iter, 0.5, 0.5, 1);
        PrototypeSet resultingSet = generator.execute();
        int accuracy1NN = KNN.classficationAccuracy(resultingSet, test);
        generator.showResultsOfAccuracy(Parameters.getFileName(), accuracy1NN, test);
    }
}

