/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Lazy_Learning.KNN;

import java.util.StringTokenizer;
import keel.Algorithms.Lazy_Learning.LazyAlgorithm;
import org.core.Files;

public class KNN
extends LazyAlgorithm {
    private int k;
    private int distanceType;
    private static final int MANHATTAN = 1;
    private static final int EUCLIDEAN = 2;
    private static final int HVDM = 3;
    private double[] stdDev;
    private double[][][] nominalDistance;

    public KNN(String script) {
        this.readDataFiles(script);
        this.name = "KNN";
        if (this.distanceType == 3) {
            this.stdDev = new double[this.inputAtt];
            this.calculateHVDM();
        }
        this.setInitialTime();
    }

    @Override
    protected void readParameters(String script) {
        String file = Files.readFile(script);
        StringTokenizer fileLines = new StringTokenizer(file, "\n\r");
        fileLines.nextToken();
        fileLines.nextToken();
        fileLines.nextToken();
        String line = fileLines.nextToken();
        StringTokenizer tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        this.k = Integer.parseInt(tokens.nextToken().substring(1));
        line = fileLines.nextToken();
        tokens = new StringTokenizer(line, "=");
        tokens.nextToken();
        String type = tokens.nextToken().substring(1);
        this.distanceType = 2;
        if (type.equalsIgnoreCase("MANHATTAN")) {
            this.distanceType = 1;
        }
        if (type.equalsIgnoreCase("HVDM")) {
            this.distanceType = 3;
        }
    }

    @Override
    protected int evaluate(double[] example) {
        int i;
        int[] nearestN = new int[this.k];
        double[] minDist = new double[this.k];
        for (i = 0; i < this.k; ++i) {
            nearestN[i] = 0;
            minDist[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < this.trainData.length; ++i) {
            double dist = this.distance(this.trainData[i], example);
            if (!(dist > 0.0)) continue;
            boolean stop = false;
            for (int j = 0; j < this.k && !stop; ++j) {
                if (!(dist < minDist[j])) continue;
                for (int l = this.k - 1; l >= j + 1; --l) {
                    minDist[l] = minDist[l - 1];
                    nearestN[l] = nearestN[l - 1];
                }
                minDist[j] = dist;
                nearestN[j] = i;
                stop = true;
            }
        }
        int[] selectedClasses = new int[this.nClasses];
        for (i = 0; i < this.nClasses; ++i) {
            selectedClasses[i] = 0;
        }
        for (i = 0; i < this.k; ++i) {
            int n = this.trainOutput[nearestN[i]];
            selectedClasses[n] = selectedClasses[n] + 1;
        }
        int prediction = 0;
        int predictionValue = selectedClasses[0];
        for (i = 1; i < this.nClasses; ++i) {
            if (predictionValue >= selectedClasses[i]) continue;
            predictionValue = selectedClasses[i];
            prediction = i;
        }
        return prediction;
    }

    private double distance(double[] instance1, double[] instance2) {
        double dist = 0.0;
        switch (this.distanceType) {
            case 3: {
                dist = this.HVDMDistance(instance1, instance2);
                break;
            }
            case 1: {
                dist = this.manhattanDistance(instance1, instance2);
                break;
            }
            default: {
                dist = this.euclideanDistance(instance1, instance2);
            }
        }
        return dist;
    }

    private void calculateHVDM() {
        this.nominalDistance = new double[this.train.getAttributeDefinitions().getInputNumAttributes()][][];
        for (int i = 0; i < this.inputAtt; ++i) {
            int j;
            if (this.train.getAttributeDefinitions().getInputAttribute(i).getType() != 0) {
                double mean = 0.0;
                double quad = 0.0;
                for (j = 0; j < this.trainData.length; ++j) {
                    mean += this.trainData[j][i];
                    quad += this.trainData[j][i] * this.trainData[j][i];
                }
                this.stdDev[i] = Math.sqrt(quad / (double)this.trainData.length - (mean /= (double)this.trainData.length) * mean);
                continue;
            }
            this.nominalDistance[i] = new double[this.train.getAttributeDefinitions().getInputAttribute(i).getNumNominalValues()][this.train.getAttributeDefinitions().getInputAttribute(i).getNumNominalValues()];
            for (j = 0; j < this.train.getAttributeDefinitions().getInputAttribute(i).getNumNominalValues(); ++j) {
                this.nominalDistance[i][j][j] = 0.0;
            }
            for (j = 0; j < this.train.getAttributeDefinitions().getInputAttribute(i).getNumNominalValues(); ++j) {
                for (int l = j + 1; l < this.train.getAttributeDefinitions().getInputAttribute(i).getNumNominalValues(); ++l) {
                    int m;
                    double VDM = 0.0;
                    int Nay = 0;
                    int Nax = 0;
                    for (m = 0; m < this.trainData.length; ++m) {
                        if (this.real2Nom(this.trainData[m][i], i) == j) {
                            ++Nax;
                        }
                        if (this.real2Nom(this.trainData[m][i], i) != l) continue;
                        ++Nay;
                    }
                    for (m = 0; m < this.nClasses; ++m) {
                        int Nayc = 0;
                        int Naxc = 0;
                        for (int n = 0; n < this.trainData.length; ++n) {
                            if (this.real2Nom(this.trainData[n][i], i) == j && this.trainOutput[n] == m) {
                                ++Naxc;
                            }
                            if (this.real2Nom(this.trainData[n][i], i) != l || this.trainOutput[n] != m) continue;
                            ++Nayc;
                        }
                        VDM += ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay) * ((double)Naxc / (double)Nax - (double)Nayc / (double)Nay);
                    }
                    this.nominalDistance[i][j][l] = Math.sqrt(VDM);
                    this.nominalDistance[i][l][j] = Math.sqrt(VDM);
                }
            }
        }
    }

    private double HVDMDistance(double[] instance1, double[] instance2) {
        double result = 0.0;
        for (int i = 0; i < instance1.length; ++i) {
            if (this.train.getAttributeDefinitions().getInputAttribute(i).getType() == 0) {
                result += this.nominalDistance[i][this.real2Nom(instance1[i], i)][this.real2Nom(instance2[i], i)];
                continue;
            }
            result += Math.abs(instance1[i] - instance2[i]) / (4.0 * this.stdDev[i]);
        }
        result = Math.sqrt(result);
        return result;
    }

    private int real2Nom(double real, int att) {
        int result = (int)(real * (double)(this.train.getAttributeDefinitions().getInputAttribute(att).getNominalValuesList().size() - 1));
        return result;
    }
}

