## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)


## ----setup--------------------------------------------------------------------
library(blockr.core)


## flowchart LR
##   subgraph blockr_ggplot2[blockr.ggplot2]
##     new_block1[New block]
##     new_block2[New block]
##   end
##   subgraph blockr_echarts4r[blockr.echarts4r]
##     new_block3[New block]
##     new_block4[New block]
##   end
##   blockr_ggplot2 --> |register| registry
##   blockr_echarts4r --> |register| registry
##   subgraph registry[Registry]
##     subgraph select_reg[Select block]
##       reg_name[Name: select block]
##       reg_descr[Description: select columns in a table]
##       reg_classes[Classes: select_block, tranform_block]
##       reg_category[Category: transform]
##       reg_ctor[Construcor: new_select_block]
##       reg_package[Package: blockr.dplyr]
##     end
##     subgraph filter_reg[Filter block]
##     end
##     filter_reg --x |unregister| trash['fa:fa-trash']
##   end

## ----eval=FALSE---------------------------------------------------------------
# available_blocks()[["dataset_block"]]


## ----eval=TRUE----------------------------------------------------------------
names(available_blocks())


## ----eval=TRUE----------------------------------------------------------------
# ./R/dummy-block.R
new_dummy_block <- function(text = "Hello World", ...) {
  new_data_block(
    function(id) {
      moduleServer(id, function(input, output, session) {
        list(
          expr = reactive(quote(text)),
          state = list(text = text)
        )
      })
    },
    function(id) {
      tagList()
    },
    class = "dummy_block",
    ...
  )
}

register_dummy_blocks <- function() {
  register_blocks(
    c(new_dummy_block),
    name = c("dummy block"),
    description = c("A block that does nothing"),
    overwrite = TRUE
  )
}

register_dummy_blocks()


## -----------------------------------------------------------------------------
available_blocks()[["dummy_block"]]


## -----------------------------------------------------------------------------
unregister_blocks(uid = "dummy_block")

# Check it out
names(available_blocks())


## ----blockr.ui-demo, eval=FALSE, echo = FALSE---------------------------------
# library(blockr.ui)
# library(blockr.dplyr)
# library(blockr.sdtm)
# library(blockr.io)
# run_demo_app()


## ----shinylive_url, echo = FALSE, results = 'asis'----------------------------
# extract the code from knitr code chunks by ID
code <- paste0(
  c(
    "webr::install(\"blockr.ui\", repos = \"https://cynkra.github.io/blockr.webR/\")",
    "webr::install(\"blockr.dplyr\", repos = \"https://cynkra.github.io/blockr.webR/\")",
    "webr::install(\"blockr.sdtm\", repos = \"https://cynkra.github.io/blockr.webR/\")",
    "webr::install(\"blockr.io\", repos = \"https://cynkra.github.io/blockr.webR/\")",
    knitr::knit_code$get("blockr.ui-demo")
  ),
  collapse = "\n"
)

url <- roxy.shinylive::create_shinylive_url(code, header = FALSE)


## ----shinylive_iframe, echo = FALSE, eval = TRUE------------------------------
tags$iframe(
  class = "border border-5 rounded shadow-lg",
  src = url,
  style = "zoom: 0.75;",
  width = "100%",
  height = "1100px"
)

