/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.commonsmath;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.BinomialDistribution;
import org.apache.commons.math3.distribution.ChiSquaredDistribution;
import org.apache.commons.math3.distribution.ExponentialDistribution;
import org.apache.commons.math3.distribution.FDistribution;
import org.apache.commons.math3.distribution.GammaDistribution;
import org.apache.commons.math3.distribution.GeometricDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.distribution.PoissonDistribution;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.distribution.UniformRealDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;
import org.apache.commons.math3.special.Beta;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ScalaRunTime$;

public final class Transcompile$ {
    public static final Transcompile$ MODULE$;
    private final Well44497b org$ddahl$commonsmath$Transcompile$$rng;
    private final UniformRealDistribution stdUniform;
    private final NormalDistribution stdNormal;
    private final GammaDistribution stdGamma;
    private final ExponentialDistribution stdExp;
    private final BetaDistribution stdBeta;
    private final TDistribution stdT;
    private final ChiSquaredDistribution stdChiSquared;
    private final FDistribution stdF;
    private final BinomialDistribution stdBinomial;
    private final PascalDistribution stdNegativeBinomial;
    private final PoissonDistribution stdPoisson;
    private final GeometricDistribution stdGeometric;

    static {
        new Transcompile$();
    }

    public Well44497b org$ddahl$commonsmath$Transcompile$$rng() {
        return this.org$ddahl$commonsmath$Transcompile$$rng;
    }

    public int org$ddahl$commonsmath$Transcompile$$r2int(double x) {
        return (int)FastMath.round((double)x);
    }

    public double _gamma(double x) {
        return Gamma.gamma((double)x);
    }

    public double[] _gamma(double[] x) {
        return (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return Gamma.gamma((double)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _gamma(int[] x) {
        return (double[])Predef$.MODULE$.intArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int z) {
                return this.apply$mcDI$sp(z);
            }

            public double apply$mcDI$sp(int z) {
                return Gamma.gamma((double)z);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lgamma(double x) {
        return Gamma.logGamma((double)x);
    }

    public double[] _lgamma(double[] x) {
        return (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return Gamma.logGamma((double)x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lgamma(int[] x) {
        return (double[])Predef$.MODULE$.intArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int z) {
                return this.apply$mcDI$sp(z);
            }

            public double apply$mcDI$sp(int z) {
                return Gamma.logGamma((double)z);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _beta(double x, double y) {
        return FastMath.exp((double)Beta.logBeta((double)x, (double)y));
    }

    public double[] _beta(double[] x, double[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcD$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(int[] x, double[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcD$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(double[] x, int[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcI$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _beta(int[] x, int[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcI$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lbeta(double x, double y) {
        return Beta.logBeta((double)x, (double)y);
    }

    public double[] _lbeta(double[] x, double[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcD$sp());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(int[] x, double[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcD$sp());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(double[] x, int[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Beta.logBeta((double)z._1$mcD$sp(), (double)z._2$mcI$sp());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lbeta(int[] x, int[] y) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapIntArray(y), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Beta.logBeta((double)z._1$mcI$sp(), (double)z._2$mcI$sp());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _factorial(double x) {
        return Gamma.gamma((double)(x + 1.0));
    }

    public double[] _factorial(double[] x) {
        return (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double z) {
                return this.apply$mcDD$sp(z);
            }

            public double apply$mcDD$sp(double z) {
                return Gamma.gamma((double)(z + 1.0));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _factorial(int[] x) {
        return (double[])Predef$.MODULE$.intArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int z) {
                return this.apply$mcDI$sp(z);
            }

            public double apply$mcDI$sp(int z) {
                return Gamma.gamma((double)(z + 1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lfactorial(double x) {
        return Gamma.logGamma((double)(x + 1.0));
    }

    public double[] _lfactorial(double[] x) {
        return (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double z) {
                return this.apply$mcDD$sp(z);
            }

            public double apply$mcDD$sp(double z) {
                return Gamma.logGamma((double)(z + 1.0));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lfactorial(int[] x) {
        return (double[])Predef$.MODULE$.intArrayOps(x).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int z) {
                return this.apply$mcDI$sp(z);
            }

            public double apply$mcDI$sp(int z) {
                return Gamma.logGamma((double)(z + 1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _choose(double n, double k) {
        int kk = this.org$ddahl$commonsmath$Transcompile$$r2int(k);
        return FastMath.exp((double)(Gamma.logGamma((double)(n + 1.0)) - Gamma.logGamma((double)(kk + 1)) - Gamma.logGamma((double)(n - (double)kk + 1.0))));
    }

    public double[] _choose(double[] n, double[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])Predef$.MODULE$.doubleArrayOps(k).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x) {
                return this.apply$mcID$sp(x);
            }

            public int apply$mcID$sp(double x) {
                return Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(int[] n, double[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])Predef$.MODULE$.doubleArrayOps(k).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x) {
                return this.apply$mcID$sp(x);
            }

            public int apply$mcID$sp(double x) {
                return Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(double[] n, int[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _choose(int[] n, int[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return FastMath.exp((double)(Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1))));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double _lchoose(double n, double k) {
        int kk = this.org$ddahl$commonsmath$Transcompile$$r2int(k);
        return Gamma.logGamma((double)(n + 1.0)) - Gamma.logGamma((double)(kk + 1)) - Gamma.logGamma((double)(n - (double)kk + 1.0));
    }

    public double[] _lchoose(double[] n, double[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])Predef$.MODULE$.doubleArrayOps(k).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x) {
                return this.apply$mcID$sp(x);
            }

            public int apply$mcID$sp(double x) {
                return Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(int[] n, double[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray((int[])Predef$.MODULE$.doubleArrayOps(k).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(double x) {
                return this.apply$mcID$sp(x);
            }

            public int apply$mcID$sp(double x) {
                return Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(x);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(double[] n, int[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Gamma.logGamma((double)(z._1$mcD$sp() + 1.0)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcD$sp() - (double)z._2$mcI$sp() + 1.0));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public double[] _lchoose(int[] n, int[] k) {
        return (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(n).zip((GenIterable)Predef$.MODULE$.wrapIntArray(k), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<Object, Object> z) {
                return Gamma.logGamma((double)(z._1$mcI$sp() + 1)) - Gamma.logGamma((double)(z._2$mcI$sp() + 1)) - Gamma.logGamma((double)(z._1$mcI$sp() - z._2$mcI$sp() + 1));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    public int[] _sample(double x) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), this._sample$default$2(), this._sample$default$3(), this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), size, this._sample$default$3(), this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, boolean replace) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), this.org$ddahl$commonsmath$Transcompile$$r2int(x), replace, this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, boolean replace) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), size, replace, this._sample$default$4(), ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, boolean replace, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), size, replace, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double size, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), size, false, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, boolean replace, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), this.org$ddahl$commonsmath$Transcompile$$r2int(x), replace, prob, ClassTag$.MODULE$.Int());
    }

    public int[] _sample(double x, double[] prob) {
        return (int[])this._sample(Array$.MODULE$.range(1, this.org$ddahl$commonsmath$Transcompile$$r2int(x) + 1), this.org$ddahl$commonsmath$Transcompile$$r2int(x), false, prob, ClassTag$.MODULE$.Int());
    }

    public <T> Object _sample(Object x, double size, boolean replace, double[] prob, ClassTag<T> evidence$1) {
        double[] p2;
        double[] dArray = p2 = prob == null ? (double[])Array$.MODULE$.fill(ScalaRunTime$.MODULE$.array_length(x), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 1.0;
            }
        }, ClassTag$.MODULE$.Double()) : (double[])Predef$.MODULE$.doubleArrayOps(prob).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$1) {
                return this.apply$mcDD$sp(x$1);
            }

            public double apply$mcDD$sp(double x$1) {
                return package$.MODULE$.max(0.0, x$1);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        if (ScalaRunTime$.MODULE$.array_length(x) != p2.length) {
            throw scala.sys.package$.MODULE$.error("Length of 'x' and 'prob' must be same.");
        }
        int s = Double.isNaN(size) ? ScalaRunTime$.MODULE$.array_length(x) : this.org$ddahl$commonsmath$Transcompile$$r2int(size);
        Tuple2[] pairs = (Tuple2[])Predef$.MODULE$.genericArrayOps(x).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(p2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        DoubleRef total = DoubleRef.create((double)BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(p2).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)));
        if (!replace && s > ScalaRunTime$.MODULE$.array_length(x)) {
            throw scala.sys.package$.MODULE$.error("Cannot take a sample larger than the population when 'replace = FALSE'.");
        }
        return Array$.MODULE$.fill(s, (Function0)new Serializable(replace, pairs, total){
            public static final long serialVersionUID = 0L;
            private final boolean replace$1;
            private final Tuple2[] pairs$1;
            private final DoubleRef total$1;

            public final T apply() {
                double u = this.total$1.elem * Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$rng().nextDouble();
                double cumsum = 0.0;
                int i = 0;
                while (cumsum <= u) {
                    cumsum += this.pairs$1[i]._2$mcD$sp();
                    ++i;
                }
                --i;
                if (!this.replace$1) {
                    this.total$1.elem -= this.pairs$1[i]._2$mcD$sp();
                    this.pairs$1[i] = new Tuple2(this.pairs$1[i]._1(), (Object)BoxesRunTime.boxToDouble((double)0.0));
                }
                return (T)this.pairs$1[i]._1();
            }
            {
                this.replace$1 = replace$1;
                this.pairs$1 = pairs$1;
                this.total$1 = total$1;
            }
        }, evidence$1);
    }

    public <T> double _sample$default$2() {
        return Double.NaN;
    }

    public <T> boolean _sample$default$3() {
        return false;
    }

    public <T> double[] _sample$default$4() {
        return null;
    }

    private double dI(AbstractIntegerDistribution dist, double x) {
        return dist.probability(this.org$ddahl$commonsmath$Transcompile$$r2int(x));
    }

    private double d(AbstractRealDistribution dist, double x) {
        return dist.density(x);
    }

    private double[] dI(AbstractIntegerDistribution dist, double[] x, boolean log) {
        return log ? (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$1;

            public final double apply(double xx) {
                return this.apply$mcDD$sp(xx);
            }

            public double apply$mcDD$sp(double xx) {
                return this.dist$1.logProbability(Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(xx));
            }
            {
                this.dist$1 = dist$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$1;

            public final double apply(double xx) {
                return this.apply$mcDD$sp(xx);
            }

            public double apply$mcDD$sp(double xx) {
                return this.dist$1.probability(Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(xx));
            }
            {
                this.dist$1 = dist$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] d(AbstractRealDistribution dist, double[] x, boolean log) {
        return log ? (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$2;

            public final double apply(double xx) {
                return this.apply$mcDD$sp(xx);
            }

            public double apply$mcDD$sp(double xx) {
                return this.dist$2.logDensity(xx);
            }
            {
                this.dist$2 = dist$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(x).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$2;

            public final double apply(double xx) {
                return this.apply$mcDD$sp(xx);
            }

            public double apply$mcDD$sp(double xx) {
                return this.dist$2.density(xx);
            }
            {
                this.dist$2 = dist$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double pI(AbstractIntegerDistribution dist, double q2) {
        return dist.cumulativeProbability(this.org$ddahl$commonsmath$Transcompile$$r2int(q2));
    }

    private double p(AbstractRealDistribution dist, double q2) {
        return dist.cumulativeProbability(q2);
    }

    private double[] pI(AbstractIntegerDistribution dist, double[] q2, boolean lower_tail) {
        return lower_tail ? (double[])Predef$.MODULE$.doubleArrayOps(q2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$3;

            public final double apply(double qq) {
                return this.apply$mcDD$sp(qq);
            }

            public double apply$mcDD$sp(double qq) {
                return this.dist$3.cumulativeProbability(Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(qq));
            }
            {
                this.dist$3 = dist$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(q2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$3;

            public final double apply(double qq) {
                return this.apply$mcDD$sp(qq);
            }

            public double apply$mcDD$sp(double qq) {
                return 1.0 - this.dist$3.cumulativeProbability(Transcompile$.MODULE$.org$ddahl$commonsmath$Transcompile$$r2int(qq));
            }
            {
                this.dist$3 = dist$3;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] p(AbstractRealDistribution dist, double[] q2, boolean lower_tail) {
        return lower_tail ? (double[])Predef$.MODULE$.doubleArrayOps(q2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$4;

            public final double apply(double qq) {
                return this.apply$mcDD$sp(qq);
            }

            public double apply$mcDD$sp(double qq) {
                return this.dist$4.cumulativeProbability(qq);
            }
            {
                this.dist$4 = dist$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(q2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$4;

            public final double apply(double qq) {
                return this.apply$mcDD$sp(qq);
            }

            public double apply$mcDD$sp(double qq) {
                return 1.0 - this.dist$4.cumulativeProbability(qq);
            }
            {
                this.dist$4 = dist$4;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double qI(AbstractIntegerDistribution dist, double p2) {
        return dist.inverseCumulativeProbability(p2);
    }

    private double q(AbstractRealDistribution dist, double p2) {
        return dist.inverseCumulativeProbability(p2);
    }

    private double[] qI(AbstractIntegerDistribution dist, double[] p2, boolean lower_tail) {
        return lower_tail ? (double[])Predef$.MODULE$.doubleArrayOps(p2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$5;

            public final double apply(double pp) {
                return this.apply$mcDD$sp(pp);
            }

            public double apply$mcDD$sp(double pp) {
                return this.dist$5.inverseCumulativeProbability(pp);
            }
            {
                this.dist$5 = dist$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(p2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractIntegerDistribution dist$5;

            public final double apply(double pp) {
                return this.apply$mcDD$sp(pp);
            }

            public double apply$mcDD$sp(double pp) {
                return this.dist$5.inverseCumulativeProbability(1.0 - pp);
            }
            {
                this.dist$5 = dist$5;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] q(AbstractRealDistribution dist, double[] p2, boolean lower_tail) {
        return lower_tail ? (double[])Predef$.MODULE$.doubleArrayOps(p2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$6;

            public final double apply(double pp) {
                return this.apply$mcDD$sp(pp);
            }

            public double apply$mcDD$sp(double pp) {
                return this.dist$6.inverseCumulativeProbability(pp);
            }
            {
                this.dist$6 = dist$6;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Predef$.MODULE$.doubleArrayOps(p2).map((Function1)new Serializable(dist){
            public static final long serialVersionUID = 0L;
            private final AbstractRealDistribution dist$6;

            public final double apply(double pp) {
                return this.apply$mcDD$sp(pp);
            }

            public double apply$mcDD$sp(double pp) {
                return this.dist$6.inverseCumulativeProbability(1.0 - pp);
            }
            {
                this.dist$6 = dist$6;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double rI(AbstractIntegerDistribution dist) {
        return dist.sample();
    }

    private double r(AbstractRealDistribution dist) {
        return dist.sample();
    }

    private double[] rI(AbstractIntegerDistribution dist, double n) {
        return (double[])Predef$.MODULE$.intArrayOps(dist.sample(this.org$ddahl$commonsmath$Transcompile$$r2int(n))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$2) {
                return this.apply$mcDI$sp(x$2);
            }

            public double apply$mcDI$sp(int x$2) {
                return x$2;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
    }

    private double[] r(AbstractRealDistribution dist, double n) {
        return dist.sample(this.org$ddahl$commonsmath$Transcompile$$r2int(n));
    }

    private UniformRealDistribution mkUniform(double min, double max) {
        return new UniformRealDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), min, max);
    }

    private UniformRealDistribution stdUniform() {
        return this.stdUniform;
    }

    public double _dunif(double x) {
        return this.d((AbstractRealDistribution)this.stdUniform(), x);
    }

    public double[] _dunif(double[] x, double min, double max, boolean log) {
        return this.d((AbstractRealDistribution)this.mkUniform(min, max), x, log);
    }

    public double _dunif$default$2() {
        return 0.0;
    }

    public double _dunif$default$3() {
        return 1.0;
    }

    public boolean _dunif$default$4() {
        return false;
    }

    public double _punif(double q2) {
        return this.p((AbstractRealDistribution)this.stdUniform(), q2);
    }

    public double[] _punif(double[] q2, double min, double max, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkUniform(min, max), q2, lower_tail);
    }

    public double _punif$default$2() {
        return 0.0;
    }

    public double _punif$default$3() {
        return 1.0;
    }

    public boolean _punif$default$4() {
        return true;
    }

    public double _qunif(double p2) {
        return this.q((AbstractRealDistribution)this.stdUniform(), p2);
    }

    public double[] _qunif(double[] p2, double min, double max, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkUniform(min, max), p2, lower_tail);
    }

    public double _qunif$default$2() {
        return 0.0;
    }

    public double _qunif$default$3() {
        return 1.0;
    }

    public boolean _qunif$default$4() {
        return true;
    }

    public double _runif() {
        return this.r((AbstractRealDistribution)this.stdUniform());
    }

    public double[] _runif(double n, double min, double max) {
        return this.r((AbstractRealDistribution)this.mkUniform(min, max), n);
    }

    public double _runif$default$2() {
        return 0.0;
    }

    public double _runif$default$3() {
        return 1.0;
    }

    private NormalDistribution mkNormal(double mean, double sd) {
        return new NormalDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), mean, sd);
    }

    private NormalDistribution stdNormal() {
        return this.stdNormal;
    }

    public double _dnorm(double x) {
        return this.d((AbstractRealDistribution)this.stdNormal(), x);
    }

    public double[] _dnorm(double[] x, double mean, double sd, boolean log) {
        return this.d((AbstractRealDistribution)this.mkNormal(mean, sd), x, log);
    }

    public double _dnorm$default$2() {
        return 0.0;
    }

    public double _dnorm$default$3() {
        return 1.0;
    }

    public boolean _dnorm$default$4() {
        return false;
    }

    public double _pnorm(double q2) {
        return this.p((AbstractRealDistribution)this.stdNormal(), q2);
    }

    public double[] _pnorm(double[] q2, double mean, double sd, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkNormal(mean, sd), q2, lower_tail);
    }

    public double _pnorm$default$2() {
        return 0.0;
    }

    public double _pnorm$default$3() {
        return 1.0;
    }

    public boolean _pnorm$default$4() {
        return true;
    }

    public double _qnorm(double p2) {
        return this.q((AbstractRealDistribution)this.stdNormal(), p2);
    }

    public double[] _qnorm(double[] p2, double mean, double sd, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkNormal(mean, sd), p2, lower_tail);
    }

    public double _qnorm$default$2() {
        return 0.0;
    }

    public double _qnorm$default$3() {
        return 1.0;
    }

    public boolean _qnorm$default$4() {
        return true;
    }

    public double _rnorm() {
        return this.r((AbstractRealDistribution)this.stdNormal());
    }

    public double[] _rnorm(double n, double mean, double sd) {
        return this.r((AbstractRealDistribution)this.mkNormal(mean, sd), n);
    }

    public double _rnorm$default$2() {
        return 0.0;
    }

    public double _rnorm$default$3() {
        return 1.0;
    }

    private GammaDistribution mkGamma(double shape, double rate, double scale) {
        if (Double.isNaN(rate) || Double.isNaN(scale)) {
            double scale2 = Double.isNaN(rate) && Double.isNaN(scale) ? 1.0 : (Double.isNaN(rate) ? scale : 1.0 / rate);
            return new GammaDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), shape, scale2);
        }
        throw scala.sys.package$.MODULE$.error("Only provide one of 'rate' or 'scale'.");
    }

    private GammaDistribution stdGamma() {
        return this.stdGamma;
    }

    public double _dgamma(double x) {
        return this.d((AbstractRealDistribution)this.stdGamma(), x);
    }

    public double[] _dgamma(double[] x, double shape, double rate, double scale, boolean log) {
        return this.d((AbstractRealDistribution)this.mkGamma(shape, rate, scale), x, log);
    }

    public double _dgamma$default$3() {
        return Double.NaN;
    }

    public double _dgamma$default$4() {
        return Double.NaN;
    }

    public boolean _dgamma$default$5() {
        return false;
    }

    public double _pgamma(double q2) {
        return this.p((AbstractRealDistribution)this.stdGamma(), q2);
    }

    public double[] _pgamma(double[] q2, double shape, double rate, double scale, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkGamma(shape, rate, scale), q2, lower_tail);
    }

    public double _pgamma$default$3() {
        return Double.NaN;
    }

    public double _pgamma$default$4() {
        return Double.NaN;
    }

    public boolean _pgamma$default$5() {
        return true;
    }

    public double _qgamma(double p2) {
        return this.q((AbstractRealDistribution)this.stdGamma(), p2);
    }

    public double[] _qgamma(double[] p2, double shape, double rate, double scale, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkGamma(shape, rate, scale), p2, lower_tail);
    }

    public double _qgamma$default$3() {
        return Double.NaN;
    }

    public double _qgamma$default$4() {
        return Double.NaN;
    }

    public boolean _qgamma$default$5() {
        return true;
    }

    public double _rgamma() {
        return this.r((AbstractRealDistribution)this.stdGamma());
    }

    public double[] _rgamma(double n, double shape, double rate, double scale) {
        return this.r((AbstractRealDistribution)this.mkGamma(shape, rate, scale), n);
    }

    public double _rgamma$default$3() {
        return Double.NaN;
    }

    public double _rgamma$default$4() {
        return Double.NaN;
    }

    private ExponentialDistribution mkExp(double rate) {
        return new ExponentialDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), 1.0 / rate);
    }

    private ExponentialDistribution stdExp() {
        return this.stdExp;
    }

    public double _dexp(double x) {
        return this.d((AbstractRealDistribution)this.stdExp(), x);
    }

    public double[] _dexp(double[] x, double rate, boolean log) {
        return this.d((AbstractRealDistribution)this.mkExp(rate), x, log);
    }

    public double _dexp$default$2() {
        return 1.0;
    }

    public boolean _dexp$default$3() {
        return false;
    }

    public double _pexp(double q2) {
        return this.p((AbstractRealDistribution)this.stdExp(), q2);
    }

    public double[] _pexp(double[] q2, double rate, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkExp(rate), q2, lower_tail);
    }

    public double _pexp$default$2() {
        return 1.0;
    }

    public boolean _pexp$default$3() {
        return true;
    }

    public double _qexp(double p2) {
        return this.q((AbstractRealDistribution)this.stdExp(), p2);
    }

    public double[] _qexp(double[] p2, double rate, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkExp(rate), p2, lower_tail);
    }

    public double _qexp$default$2() {
        return 1.0;
    }

    public boolean _qexp$default$3() {
        return true;
    }

    public double _rexp() {
        return this.r((AbstractRealDistribution)this.stdExp());
    }

    public double[] _rexp(double n, double rate) {
        return this.r((AbstractRealDistribution)this.mkExp(rate), n);
    }

    public double _rexp$default$2() {
        return 1.0;
    }

    private BetaDistribution mkBeta(double shape1, double shape2, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new BetaDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), shape1, shape2);
    }

    private BetaDistribution stdBeta() {
        return this.stdBeta;
    }

    public double _dbeta(double x) {
        return this.d((AbstractRealDistribution)this.stdBeta(), x);
    }

    public double[] _dbeta(double[] x, double shape1, double shape2, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), x, log);
    }

    public double _dbeta$default$4() {
        return 0.0;
    }

    public boolean _dbeta$default$5() {
        return false;
    }

    public double _pbeta(double q2) {
        return this.p((AbstractRealDistribution)this.stdBeta(), q2);
    }

    public double[] _pbeta(double[] q2, double shape1, double shape2, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), q2, lower_tail);
    }

    public double _pbeta$default$4() {
        return 0.0;
    }

    public boolean _pbeta$default$5() {
        return true;
    }

    public double _qbeta(double p2) {
        return this.q((AbstractRealDistribution)this.stdBeta(), p2);
    }

    public double[] _qbeta(double[] p2, double shape1, double shape2, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), p2, lower_tail);
    }

    public double _qbeta$default$4() {
        return 0.0;
    }

    public boolean _qbeta$default$5() {
        return true;
    }

    public double _rbeta() {
        return this.r((AbstractRealDistribution)this.stdBeta());
    }

    public double[] _rbeta(double n, double shape1, double shape2, double ncp) {
        return this.r((AbstractRealDistribution)this.mkBeta(shape1, shape2, ncp), n);
    }

    public double _rbeta$default$4() {
        return 0.0;
    }

    private TDistribution mkT(double df, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new TDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), df);
    }

    private TDistribution stdT() {
        return this.stdT;
    }

    public double _dt(double x) {
        return this.d((AbstractRealDistribution)this.stdT(), x);
    }

    public double[] _dt(double[] x, double df, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkT(df, ncp), x, log);
    }

    public double _dt$default$3() {
        return 0.0;
    }

    public boolean _dt$default$4() {
        return false;
    }

    public double _pt(double q2) {
        return this.p((AbstractRealDistribution)this.stdT(), q2);
    }

    public double[] _pt(double[] q2, double df, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkT(df, ncp), q2, lower_tail);
    }

    public double _pt$default$3() {
        return 0.0;
    }

    public boolean _pt$default$4() {
        return true;
    }

    public double _qt(double p2) {
        return this.q((AbstractRealDistribution)this.stdT(), p2);
    }

    public double[] _qt(double[] p2, double df, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkT(df, ncp), p2, lower_tail);
    }

    public double _qt$default$3() {
        return 0.0;
    }

    public boolean _qt$default$4() {
        return true;
    }

    public double _rt() {
        return this.r((AbstractRealDistribution)this.stdT());
    }

    public double[] _rt(double n, double df, double ncp) {
        return this.r((AbstractRealDistribution)this.mkT(df, ncp), n);
    }

    public double _rt$default$3() {
        return 0.0;
    }

    private ChiSquaredDistribution mkChiSquared(double df, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new ChiSquaredDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), df);
    }

    private ChiSquaredDistribution stdChiSquared() {
        return this.stdChiSquared;
    }

    public double _dchisq(double x) {
        return this.d((AbstractRealDistribution)this.stdChiSquared(), x);
    }

    public double[] _dchisq(double[] x, double df, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkChiSquared(df, ncp), x, log);
    }

    public double _dchisq$default$3() {
        return 0.0;
    }

    public boolean _dchisq$default$4() {
        return false;
    }

    public double _pchisq(double q2) {
        return this.p((AbstractRealDistribution)this.stdChiSquared(), q2);
    }

    public double[] _pchisq(double[] q2, double df, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkChiSquared(df, ncp), q2, lower_tail);
    }

    public double _pchisq$default$3() {
        return 0.0;
    }

    public boolean _pchisq$default$4() {
        return true;
    }

    public double _qchisq(double p2) {
        return this.q((AbstractRealDistribution)this.stdChiSquared(), p2);
    }

    public double[] _qchisq(double[] p2, double df, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkChiSquared(df, ncp), p2, lower_tail);
    }

    public double _qchisq$default$3() {
        return 0.0;
    }

    public boolean _qchisq$default$4() {
        return true;
    }

    public double _rchisq() {
        return this.r((AbstractRealDistribution)this.stdChiSquared());
    }

    public double[] _rchisq(double n, double df, double ncp) {
        return this.r((AbstractRealDistribution)this.mkChiSquared(df, ncp), n);
    }

    public double _rchisq$default$3() {
        return 0.0;
    }

    private FDistribution mkF(double df1, double df2, double ncp) {
        if (ncp != 0.0) {
            throw scala.sys.package$.MODULE$.error("The current implementation requires that the ncp is 0.");
        }
        return new FDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), df1, df2);
    }

    private FDistribution stdF() {
        return this.stdF;
    }

    public double _df(double x) {
        return this.d((AbstractRealDistribution)this.stdF(), x);
    }

    public double[] _df(double[] x, double df1, double df2, double ncp, boolean log) {
        return this.d((AbstractRealDistribution)this.mkF(df1, df2, ncp), x, log);
    }

    public double _df$default$4() {
        return 0.0;
    }

    public boolean _df$default$5() {
        return false;
    }

    public double _pf(double q2) {
        return this.p((AbstractRealDistribution)this.stdF(), q2);
    }

    public double[] _pf(double[] q2, double df1, double df2, double ncp, boolean lower_tail) {
        return this.p((AbstractRealDistribution)this.mkF(df1, df2, ncp), q2, lower_tail);
    }

    public double _pf$default$4() {
        return 0.0;
    }

    public boolean _pf$default$5() {
        return true;
    }

    public double _qf(double p2) {
        return this.q((AbstractRealDistribution)this.stdF(), p2);
    }

    public double[] _qf(double[] p2, double df1, double df2, double ncp, boolean lower_tail) {
        return this.q((AbstractRealDistribution)this.mkF(df1, df2, ncp), p2, lower_tail);
    }

    public double _qf$default$4() {
        return 0.0;
    }

    public boolean _qf$default$5() {
        return true;
    }

    public double _rf() {
        return this.r((AbstractRealDistribution)this.stdF());
    }

    public double[] _rf(double n, double df1, double df2, double ncp) {
        return this.r((AbstractRealDistribution)this.mkF(df1, df2, ncp), n);
    }

    public double _rf$default$4() {
        return 0.0;
    }

    private BinomialDistribution mkBinomial(double size, double prob) {
        return new BinomialDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), this.org$ddahl$commonsmath$Transcompile$$r2int(size), prob);
    }

    private BinomialDistribution stdBinomial() {
        return this.stdBinomial;
    }

    public double _dbinom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdBinomial(), x);
    }

    public double[] _dbinom(double[] x, double size, double prob, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkBinomial(size, prob), x, log);
    }

    public boolean _dbinom$default$4() {
        return false;
    }

    public double _pbinom(double q2) {
        return this.pI((AbstractIntegerDistribution)this.stdBinomial(), q2);
    }

    public double[] _pbinom(double[] q2, double size, double prob, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkBinomial(size, prob), q2, lower_tail);
    }

    public boolean _pbinom$default$4() {
        return true;
    }

    public double _qbinom(double p2) {
        return this.qI((AbstractIntegerDistribution)this.stdBinomial(), p2);
    }

    public double[] _qbinom(double[] p2, double size, double prob, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkBinomial(size, prob), p2, lower_tail);
    }

    public boolean _qbinom$default$4() {
        return true;
    }

    public double _rbinom() {
        return this.rI((AbstractIntegerDistribution)this.stdBinomial());
    }

    public double[] _rbinom(double n, double size, double prob) {
        return this.rI((AbstractIntegerDistribution)this.mkBinomial(size, prob), n);
    }

    private PascalDistribution mkNegativeBinomial(double size, double prob, double mu) {
        if (Double.isNaN(mu)) {
            return new PascalDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), this.org$ddahl$commonsmath$Transcompile$$r2int(size), prob);
        }
        throw scala.sys.package$.MODULE$.error("Parametrization with 'mu' is not implemented.");
    }

    private PascalDistribution stdNegativeBinomial() {
        return this.stdNegativeBinomial;
    }

    public double _dnbinom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdNegativeBinomial(), x);
    }

    public double[] _dnbinom(double[] x, double size, double prob, double mu, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), x, log);
    }

    public double _dnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _dnbinom$default$5() {
        return false;
    }

    public double _pnbinom(double q2) {
        return this.pI((AbstractIntegerDistribution)this.stdNegativeBinomial(), q2);
    }

    public double[] _pnbinom(double[] q2, double size, double prob, double mu, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), q2, lower_tail);
    }

    public double _pnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _pnbinom$default$5() {
        return true;
    }

    public double _qnbinom(double p2) {
        return this.qI((AbstractIntegerDistribution)this.stdNegativeBinomial(), p2);
    }

    public double[] _qnbinom(double[] p2, double size, double prob, double mu, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), p2, lower_tail);
    }

    public double _qnbinom$default$4() {
        return Double.NaN;
    }

    public boolean _qnbinom$default$5() {
        return true;
    }

    public double _rnbinom() {
        return this.rI((AbstractIntegerDistribution)this.stdNegativeBinomial());
    }

    public double[] _rnbinom(double n, double size, double prob, double mu) {
        return this.rI((AbstractIntegerDistribution)this.mkNegativeBinomial(size, prob, mu), n);
    }

    public double _rnbinom$default$4() {
        return Double.NaN;
    }

    private PoissonDistribution mkPoisson(double lambda) {
        return new PoissonDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), lambda, 1.0E-12, 10000000);
    }

    private PoissonDistribution stdPoisson() {
        return this.stdPoisson;
    }

    public double _dpois(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdPoisson(), x);
    }

    public double[] _dpois(double[] x, double lambda, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkPoisson(lambda), x, log);
    }

    public boolean _dpois$default$3() {
        return false;
    }

    public double _ppois(double q2) {
        return this.pI((AbstractIntegerDistribution)this.stdPoisson(), q2);
    }

    public double[] _ppois(double[] q2, double lambda, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkPoisson(lambda), q2, lower_tail);
    }

    public boolean _ppois$default$3() {
        return true;
    }

    public double _qpois(double p2) {
        return this.qI((AbstractIntegerDistribution)this.stdPoisson(), p2);
    }

    public double[] _qpois(double[] p2, double lambda, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkPoisson(lambda), p2, lower_tail);
    }

    public boolean _qpois$default$3() {
        return true;
    }

    public double _rpois() {
        return this.rI((AbstractIntegerDistribution)this.stdPoisson());
    }

    public double[] _rpois(double n, double lambda) {
        return this.rI((AbstractIntegerDistribution)this.mkPoisson(lambda), n);
    }

    private GeometricDistribution mkGeometric(double prob) {
        return new GeometricDistribution((RandomGenerator)this.org$ddahl$commonsmath$Transcompile$$rng(), prob);
    }

    private GeometricDistribution stdGeometric() {
        return this.stdGeometric;
    }

    public double _dgeom(double x) {
        return this.dI((AbstractIntegerDistribution)this.stdGeometric(), x);
    }

    public double[] _dgeom(double[] x, double prob, boolean log) {
        return this.dI((AbstractIntegerDistribution)this.mkGeometric(prob), x, log);
    }

    public boolean _dgeom$default$3() {
        return false;
    }

    public double _pgeom(double q2) {
        return this.pI((AbstractIntegerDistribution)this.stdGeometric(), q2);
    }

    public double[] _pgeom(double[] q2, double prob, boolean lower_tail) {
        return this.pI((AbstractIntegerDistribution)this.mkGeometric(prob), q2, lower_tail);
    }

    public boolean _pgeom$default$3() {
        return true;
    }

    public double _qgeom(double p2) {
        return this.qI((AbstractIntegerDistribution)this.stdGeometric(), p2);
    }

    public double[] _qgeom(double[] p2, double prob, boolean lower_tail) {
        return this.qI((AbstractIntegerDistribution)this.mkGeometric(prob), p2, lower_tail);
    }

    public boolean _qgeom$default$3() {
        return true;
    }

    public double _rgeom() {
        return this.rI((AbstractIntegerDistribution)this.stdGeometric());
    }

    public double[] _rgeom(double n, double prob) {
        return this.rI((AbstractIntegerDistribution)this.mkGeometric(prob), n);
    }

    private Transcompile$() {
        MODULE$ = this;
        this.org$ddahl$commonsmath$Transcompile$$rng = new Well44497b();
        this.stdUniform = this.mkUniform(0.0, 1.0);
        this.stdNormal = this.mkNormal(0.0, 1.0);
        this.stdGamma = this.mkGamma(1.0, 1.0, Double.NaN);
        this.stdExp = this.mkExp(1.0);
        this.stdBeta = this.mkBeta(1.0, 1.0, 0.0);
        this.stdT = this.mkT(1.0, 0.0);
        this.stdChiSquared = this.mkChiSquared(1.0, 0.0);
        this.stdF = this.mkF(1.0, 1.0, 0.0);
        this.stdBinomial = this.mkBinomial(1.0, 0.5);
        this.stdNegativeBinomial = this.mkNegativeBinomial(1.0, 0.5, Double.NaN);
        this.stdPoisson = this.mkPoisson(1.0);
        this.stdGeometric = this.mkGeometric(0.5);
    }
}

