/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector;

import choco.Choco;
import choco.cp.common.util.preprocessor.detector.AbstractGraphBasedDetector;
import choco.cp.model.CPModel;
import choco.cp.solver.preprocessor.SymetryBreakingModelDetector;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.VariableType;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Iterator;

public class CliquesModelDetector
extends AbstractGraphBasedDetector {
    private final SymetryBreakingModelDetector symbreakD;

    public CliquesModelDetector(CPModel model, boolean breakSymetries) {
        super(model);
        this.symbreakD = breakSymetries ? new SymetryBreakingModelDetector(model) : new SymetryBreakingModelDetector.EmptySymetryBreakingModelDetector(model);
    }

    @Override
    public void apply() {
        if (this.addAllNeqEdges()) {
            AbstractGraphBasedDetector.CliqueIterator it = this.cliqueIterator();
            while (it.hasNext()) {
                IntegerVariable[] cl = it.next();
                if (cl.length > 2) {
                    this.add(Choco.allDifferent("cp:bc", cl));
                    this.symbreakD.setMaxClique(cl);
                    it.remove();
                    continue;
                }
                this.add(Choco.neq((IntegerExpressionVariable)cl[0], (IntegerExpressionVariable)cl[1]));
            }
            this.symbreakD.applyThenCommit();
        }
    }

    public boolean addAllNeqEdges() {
        Iterator itneq = this.model.getConstraintByType(ConstraintType.NEQ);
        while (itneq.hasNext()) {
            Constraint neq = (Constraint)itneq.next();
            Variable[] vars = neq.getVariables();
            if (!CliquesModelDetector.isRealBinaryNeq(vars)) continue;
            this.addEdge(neq.getVariables()[0], neq.getVariables()[1], neq);
        }
        return this.diffs.nbEdges > 0;
    }

    public static boolean isRealBinaryNeq(Variable[] vars) {
        if (vars.length != 2) {
            return false;
        }
        for (Variable var : vars) {
            if (var.getVariableType() == VariableType.INTEGER) continue;
            return false;
        }
        return true;
    }
}

