/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.common.util.preprocessor.detector.scheduling;

import choco.kernel.model.ModelException;
import choco.kernel.model.constraints.ComponentConstraint;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.variables.integer.IntegerVariable;
import choco.kernel.model.variables.scheduling.TaskVariable;
import choco.kernel.solver.constraints.global.scheduling.ResourceParameters;

final class PPResource {
    private ComponentConstraint resource;
    private ResourceParameters params;

    public final void setResource(Constraint rsc) {
        if (!(rsc instanceof ComponentConstraint)) {
            throw new ModelException("unknown type resource constraint");
        }
        this.resource = (ComponentConstraint)rsc;
        if (!(this.resource.getParameters() instanceof ResourceParameters)) {
            throw new ModelException("unknown resource parameters");
        }
        this.params = (ResourceParameters)this.resource.getParameters();
    }

    public final ComponentConstraint getConstraint() {
        return this.resource;
    }

    public final ResourceParameters getParameters() {
        return this.params;
    }

    public final TaskVariable getTask(int idx) {
        return (TaskVariable)this.resource.getVariable(idx);
    }

    public final IntegerVariable getUsage(int idx) {
        return (IntegerVariable)this.resource.getVariable(this.params.getUsagesOffset() + idx - this.params.getNbRegularTasks());
    }

    public final int getMinHeight(int idx) {
        return this.getHeight(idx).getLowB();
    }

    public final IntegerVariable getHeight(int idx) {
        return (IntegerVariable)this.resource.getVariable(this.params.getHeightsOffset() + idx);
    }

    public final IntegerVariable getCons() {
        return (IntegerVariable)this.resource.getVariable(this.params.getConsOffset());
    }

    public final IntegerVariable getCapa() {
        return (IntegerVariable)this.resource.getVariable(this.params.getCapaOffset());
    }

    public final int getMaxCapa() {
        return this.getCapa().getUppB();
    }

    public final boolean isNotProducerConsumer() {
        for (int i = this.params.getHeightsOffset(); i < this.params.getConsOffset(); ++i) {
            if (((IntegerVariable)this.resource.getVariable(i)).getLowB() >= 0) continue;
            return false;
        }
        return true;
    }
}

