/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer.bool;

import choco.cp.solver.constraints.integer.bool.BinAnd;
import choco.cp.solver.constraints.integer.bool.BinNand;
import choco.cp.solver.constraints.integer.bool.BinNor;
import choco.cp.solver.constraints.integer.bool.BinOr;
import choco.cp.solver.constraints.integer.bool.BinXnor;
import choco.cp.solver.constraints.integer.bool.BinXor;
import choco.cp.solver.constraints.integer.bool.Identity;
import choco.cp.solver.constraints.integer.bool.LargeAnd;
import choco.cp.solver.constraints.integer.bool.LargeNand;
import choco.cp.solver.constraints.integer.bool.LargeNor;
import choco.cp.solver.constraints.integer.bool.LargeOr;
import choco.cp.solver.constraints.integer.bool.LargeXnor;
import choco.cp.solver.constraints.integer.bool.LargeXor;
import choco.cp.solver.constraints.integer.bool.Not;
import choco.kernel.memory.IEnvironment;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public class BooleanFactory {
    public static AbstractSConstraint<IntDomainVar> and(IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinAnd(booleans[0], booleans[1]);
        }
        return new LargeAnd(booleans);
    }

    public static AbstractSConstraint<IntDomainVar> nand(IEnvironment environment, IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinNand(booleans[0], booleans[1]);
        }
        return new LargeNand(booleans, environment);
    }

    public static AbstractSConstraint<IntDomainVar> or(IEnvironment environment, IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinOr(booleans[0], booleans[1]);
        }
        return new LargeOr(booleans, environment);
    }

    public static AbstractSConstraint<IntDomainVar> nor(IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinNor(booleans[0], booleans[1]);
        }
        return new LargeNor(booleans);
    }

    public static AbstractSConstraint<IntDomainVar> xor(IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinXor(booleans[0], booleans[1]);
        }
        return new LargeXor(booleans);
    }

    public static AbstractSConstraint<IntDomainVar> xnor(IntDomainVar ... booleans) {
        if (booleans.length == 2) {
            return new BinXnor(booleans[0], booleans[1]);
        }
        return new LargeXnor(booleans);
    }

    public static AbstractSConstraint<IntDomainVar> not(IntDomainVar bool) {
        return new Not(bool);
    }

    public static AbstractSConstraint<IntDomainVar> identity(IntDomainVar bool) {
        return new Identity(bool);
    }
}

