/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.hash;

import java.util.Arrays;
import org.openscience.cdk.hash.Pseudorandom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

class AbstractHashGenerator {
    private final Pseudorandom pseudorandom;

    public AbstractHashGenerator(Pseudorandom pseudorandom) {
        if (pseudorandom == null) {
            throw new NullPointerException("null pseduorandom number generator provided");
        }
        this.pseudorandom = pseudorandom;
    }

    static long[] copy(long[] src) {
        return Arrays.copyOf(src, src.length);
    }

    static void copy(long[] src, long[] dest) {
        System.arraycopy(src, 0, dest, 0, dest.length);
    }

    long rotate(long seed) {
        return this.pseudorandom.next(seed);
    }

    long rotate(long value, int n) {
        while (n-- > 0) {
            value = this.pseudorandom.next(value);
        }
        return value;
    }

    static int lowestThreeBits(long value) {
        return (int)(value & 7L);
    }

    long distribute(long value) {
        return this.rotate(value, 1 + AbstractHashGenerator.lowestThreeBits(value));
    }

    static int[][] toAdjList(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("atom container was null");
        }
        int n = container.getAtomCount();
        int[][] graph = new int[n][16];
        int[] degree = new int[n];
        for (IBond bond : container.bonds()) {
            int v = container.indexOf(bond.getBegin());
            int w = container.indexOf(bond.getEnd());
            if (v < 0 || w < 0) {
                throw new IllegalArgumentException("bond at index " + container.indexOf(bond) + " contained an atom not pressent in molecule");
            }
            int n2 = v;
            int n3 = degree[n2];
            degree[n2] = n3 + 1;
            graph[v][n3] = w;
            int n4 = w;
            int n5 = degree[n4];
            degree[n4] = n5 + 1;
            graph[w][n5] = v;
            if (degree[v] == graph[v].length) {
                graph[v] = Arrays.copyOf(graph[v], degree[v] * 2);
            }
            if (degree[w] != graph[w].length) continue;
            graph[w] = Arrays.copyOf(graph[w], degree[w] * 2);
        }
        for (int v = 0; v < n; ++v) {
            graph[v] = Arrays.copyOf(graph[v], degree[v]);
        }
        return graph;
    }
}

