/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.graph.basic;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.GraphEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISet;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;

public class PropNbNodes
extends Propagator<Variable> {
    private final GraphVar g;
    private final IntVar k;

    public PropNbNodes(GraphVar graph, IntVar k) {
        super(new Variable[]{graph, k}, (Priority)PropagatorPriority.LINEAR, false);
        this.g = graph;
        this.k = k;
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int env = this.g.getPotentialNodes().size();
        int ker = this.g.getMandatoryNodes().size();
        this.k.updateLowerBound(ker, (ICause)this);
        this.k.updateUpperBound(env, (ICause)this);
        if (ker == env) {
            this.setPassive();
        } else if (this.k.isInstantiated()) {
            int v = this.k.getValue();
            ISet envNodes = this.g.getPotentialNodes();
            if (v == env) {
                ISetIterator iSetIterator = envNodes.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    this.g.enforceNode(i, this);
                }
                this.setPassive();
            } else if (v == ker) {
                ISet kerNodes = this.g.getMandatoryNodes();
                ISetIterator iSetIterator = envNodes.iterator();
                while (iSetIterator.hasNext()) {
                    int i = (Integer)iSetIterator.next();
                    if (kerNodes.contains(i)) continue;
                    this.g.removeNode(i, this);
                }
                this.setPassive();
            }
        }
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (vIdx == 0) {
            return GraphEventType.REMOVE_NODE.getMask() + GraphEventType.ADD_NODE.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public ESat isEntailed() {
        int env = this.g.getPotentialNodes().size();
        int ker = this.g.getMandatoryNodes().size();
        if (env < this.k.getLB() || ker > this.k.getUB()) {
            return ESat.FALSE;
        }
        if (env == ker) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

