/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.trees;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableClassifier;
import weka.core.AdditionalMeasureProducer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.EigenvalueDecomposition;
import weka.core.matrix.Matrix;

public class SimpleCart
extends RandomizableClassifier
implements AdditionalMeasureProducer,
TechnicalInformationHandler {
    private static final long serialVersionUID = 4154189200352566053L;
    protected Instances m_train;
    protected SimpleCart[] m_Successors;
    protected Attribute m_Attribute;
    protected double m_SplitValue;
    protected String m_SplitString;
    protected double m_ClassValue;
    protected Attribute m_ClassAttribute;
    protected double m_minNumObj = 2.0;
    protected int m_numFoldsPruning = 5;
    protected double m_Alpha;
    protected double m_numIncorrectModel;
    protected double m_numIncorrectTree;
    protected boolean m_isLeaf;
    protected boolean m_Prune = true;
    protected int m_totalTrainInstances;
    protected double[] m_Props;
    protected double[] m_ClassProbs = null;
    protected double[] m_Distribution;
    protected boolean m_Heuristic = true;
    protected boolean m_UseOneSE = false;
    protected double m_SizePer = 1.0;

    public String globalInfo() {
        return "Class implementing minimal cost-complexity pruning.\nNote when dealing with missing values, use \"fractional instances\" method instead of surrogate split method.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.BOOK);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Leo Breiman and Jerome H. Friedman and Richard A. Olshen and Charles J. Stone");
        result.setValue(TechnicalInformation.Field.YEAR, "1984");
        result.setValue(TechnicalInformation.Field.TITLE, "Classification and Regression Trees");
        result.setValue(TechnicalInformation.Field.PUBLISHER, "Wadsworth International Group");
        result.setValue(TechnicalInformation.Field.ADDRESS, "Belmont, California");
        return result;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NOMINAL_CLASS);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.getCapabilities().testWithFail(data);
        data = new Instances(data);
        data.deleteWithMissingClass();
        if (!this.m_Prune) {
            int[][] sortedIndices = new int[data.numAttributes()][0];
            double[][] weights = new double[data.numAttributes()][0];
            double[] classProbs = new double[data.numClasses()];
            double totalWeight = this.computeSortedInfo(data, sortedIndices, weights, classProbs);
            this.makeTree(data, data.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
            return;
        }
        Random random = new Random(this.m_Seed);
        Instances cvData = new Instances(data);
        cvData.randomize(random);
        cvData = new Instances(cvData, 0, (int)((double)cvData.numInstances() * this.m_SizePer) - 1);
        cvData.stratify(this.m_numFoldsPruning);
        double[][] alphas = new double[this.m_numFoldsPruning][];
        double[][] errors = new double[this.m_numFoldsPruning][];
        int i = 0;
        while (i < this.m_numFoldsPruning) {
            Instances train = cvData.trainCV(this.m_numFoldsPruning, i);
            Instances test = cvData.testCV(this.m_numFoldsPruning, i);
            int[][] sortedIndices = new int[train.numAttributes()][0];
            double[][] weights = new double[train.numAttributes()][0];
            double[] classProbs = new double[train.numClasses()];
            double totalWeight = this.computeSortedInfo(train, sortedIndices, weights, classProbs);
            this.makeTree(train, train.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
            int numNodes = this.numInnerNodes();
            alphas[i] = new double[numNodes + 2];
            errors[i] = new double[numNodes + 2];
            this.prune(alphas[i], errors[i], test);
            ++i;
        }
        int[][] sortedIndices = new int[data.numAttributes()][0];
        double[][] weights = new double[data.numAttributes()][0];
        double[] classProbs = new double[data.numClasses()];
        double totalWeight = this.computeSortedInfo(data, sortedIndices, weights, classProbs);
        this.makeTree(data, data.numInstances(), sortedIndices, weights, classProbs, totalWeight, this.m_minNumObj, this.m_Heuristic);
        int numNodes = this.numInnerNodes();
        double[] treeAlphas = new double[numNodes + 2];
        int iterations = this.prune(treeAlphas, null, null);
        double[] treeErrors = new double[numNodes + 2];
        int i2 = 0;
        while (i2 <= iterations) {
            double alpha = Math.sqrt(treeAlphas[i2] * treeAlphas[i2 + 1]);
            double error = 0.0;
            int k = 0;
            while (k < this.m_numFoldsPruning) {
                int l = 0;
                while (alphas[k][l] <= alpha) {
                    ++l;
                }
                error += errors[k][l - 1];
                ++k;
            }
            treeErrors[i2] = error / (double)this.m_numFoldsPruning;
            ++i2;
        }
        int best = -1;
        double bestError = Double.MAX_VALUE;
        int i3 = iterations;
        while (i3 >= 0) {
            if (treeErrors[i3] < bestError) {
                bestError = treeErrors[i3];
                best = i3;
            }
            --i3;
        }
        if (this.m_UseOneSE) {
            double oneSE = Math.sqrt(bestError * (1.0 - bestError) / (double)data.numInstances());
            int i4 = iterations;
            while (i4 >= 0) {
                if (treeErrors[i4] <= bestError + oneSE) {
                    best = i4;
                    break;
                }
                --i4;
            }
        }
        double bestAlpha = Math.sqrt(treeAlphas[best] * treeAlphas[best + 1]);
        this.unprune();
        this.prune(bestAlpha);
    }

    protected void makeTree(Instances data, int totalInstances, int[][] sortedIndices, double[][] weights, double[] classProbs, double totalWeight, double minNumObj, boolean useHeuristic) throws Exception {
        if (totalWeight == 0.0) {
            this.m_Attribute = null;
            this.m_ClassValue = Instance.missingValue();
            this.m_Distribution = new double[data.numClasses()];
            return;
        }
        this.m_totalTrainInstances = totalInstances;
        this.m_isLeaf = true;
        this.m_ClassProbs = new double[classProbs.length];
        this.m_Distribution = new double[classProbs.length];
        System.arraycopy(classProbs, 0, this.m_ClassProbs, 0, classProbs.length);
        System.arraycopy(classProbs, 0, this.m_Distribution, 0, classProbs.length);
        if (Utils.sum(this.m_ClassProbs) != 0.0) {
            Utils.normalize(this.m_ClassProbs);
        }
        double[][][] dists = new double[data.numAttributes()][0][0];
        double[][] props = new double[data.numAttributes()][0];
        double[][] totalSubsetWeights = new double[data.numAttributes()][2];
        double[] splits = new double[data.numAttributes()];
        String[] splitString = new String[data.numAttributes()];
        double[] giniGains = new double[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            Attribute att = data.attribute(i);
            if (i != data.classIndex()) {
                if (att.isNumeric()) {
                    splits[i] = this.numericDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, giniGains, data);
                } else {
                    splitString[i] = this.nominalDistribution(props, dists, att, sortedIndices[i], weights[i], totalSubsetWeights, giniGains, data, useHeuristic);
                }
            }
            ++i;
        }
        int attIndex = Utils.maxIndex(giniGains);
        this.m_Attribute = data.attribute(attIndex);
        this.m_train = new Instances(data, sortedIndices[attIndex].length);
        int i2 = 0;
        while (i2 < sortedIndices[attIndex].length) {
            Instance inst = data.instance(sortedIndices[attIndex][i2]);
            Instance instCopy = (Instance)inst.copy();
            instCopy.setWeight(weights[attIndex][i2]);
            this.m_train.add(instCopy);
            ++i2;
        }
        if (totalWeight < 2.0 * minNumObj || giniGains[attIndex] == 0.0 || props[attIndex][0] == 0.0 || props[attIndex][1] == 0.0) {
            this.makeLeaf(data);
        } else {
            this.m_Props = props[attIndex];
            int[][][] subsetIndices = new int[2][data.numAttributes()][0];
            double[][][] subsetWeights = new double[2][data.numAttributes()][0];
            if (this.m_Attribute.isNumeric()) {
                this.m_SplitValue = splits[attIndex];
            } else {
                this.m_SplitString = splitString[attIndex];
            }
            this.splitData(subsetIndices, subsetWeights, this.m_Attribute, this.m_SplitValue, this.m_SplitString, sortedIndices, weights, data);
            if ((double)subsetIndices[0][attIndex].length < minNumObj || (double)subsetIndices[1][attIndex].length < minNumObj) {
                this.makeLeaf(data);
                return;
            }
            this.m_isLeaf = false;
            this.m_Successors = new SimpleCart[2];
            int i3 = 0;
            while (i3 < 2) {
                this.m_Successors[i3] = new SimpleCart();
                this.m_Successors[i3].makeTree(data, this.m_totalTrainInstances, subsetIndices[i3], subsetWeights[i3], dists[attIndex][i3], totalSubsetWeights[attIndex][i3], minNumObj, useHeuristic);
                ++i3;
            }
        }
    }

    public void prune(double alpha) throws Exception {
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getInnerNodes();
        boolean prune = nodeList.size() > 0;
        double preAlpha = Double.MAX_VALUE;
        while (prune) {
            SimpleCart nodeToPrune = this.nodeToPrune(nodeList);
            if (nodeToPrune.m_Alpha > alpha) break;
            nodeToPrune.makeLeaf(nodeToPrune.m_train);
            if (nodeToPrune.m_Alpha == preAlpha) {
                nodeToPrune.makeLeaf(nodeToPrune.m_train);
                this.treeErrors();
                this.calculateAlphas();
                nodeList = this.getInnerNodes();
                prune = nodeList.size() > 0;
                continue;
            }
            preAlpha = nodeToPrune.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getInnerNodes();
            boolean bl = prune = nodeList.size() > 0;
        }
    }

    public int prune(double[] alphas, double[] errors, Instances test) throws Exception {
        Evaluation eval;
        this.modelErrors();
        this.treeErrors();
        this.calculateAlphas();
        Vector nodeList = this.getInnerNodes();
        boolean prune = nodeList.size() > 0;
        alphas[0] = 0.0;
        if (errors != null) {
            eval = new Evaluation(test);
            eval.evaluateModel(this, test, new Object[0]);
            errors[0] = eval.errorRate();
        }
        int iteration = 0;
        double preAlpha = Double.MAX_VALUE;
        while (prune) {
            ++iteration;
            SimpleCart nodeToPrune = this.nodeToPrune(nodeList);
            nodeToPrune.m_isLeaf = true;
            if (nodeToPrune.m_Alpha == preAlpha) {
                --iteration;
                this.treeErrors();
                this.calculateAlphas();
                nodeList = this.getInnerNodes();
                prune = nodeList.size() > 0;
                continue;
            }
            alphas[iteration] = nodeToPrune.m_Alpha;
            if (errors != null) {
                eval = new Evaluation(test);
                eval.evaluateModel(this, test, new Object[0]);
                errors[iteration] = eval.errorRate();
            }
            preAlpha = nodeToPrune.m_Alpha;
            this.treeErrors();
            this.calculateAlphas();
            nodeList = this.getInnerNodes();
            boolean bl = prune = nodeList.size() > 0;
        }
        alphas[iteration + 1] = 1.0;
        return iteration;
    }

    protected void unprune() {
        if (this.m_Successors != null) {
            this.m_isLeaf = false;
            int i = 0;
            while (i < this.m_Successors.length) {
                this.m_Successors[i].unprune();
                ++i;
            }
        }
    }

    protected double numericDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] giniGains, Instances data) throws Exception {
        double splitPoint = Double.NaN;
        double[][] dist = null;
        int numClasses = data.numClasses();
        double[][] currDist = new double[2][numClasses];
        dist = new double[2][numClasses];
        double[] parentDist = new double[numClasses];
        int missingStart = 0;
        int j = 0;
        while (j < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[j]);
            if (!inst.isMissing(att)) {
                ++missingStart;
                double[] dArray = currDist[1];
                int n = (int)inst.classValue();
                dArray[n] = dArray[n] + weights[j];
            }
            int n = (int)inst.classValue();
            parentDist[n] = parentDist[n] + weights[j];
            ++j;
        }
        System.arraycopy(currDist[1], 0, dist[1], 0, dist[1].length);
        double currSplit = data.instance(sortedIndices[0]).value(att);
        double bestGiniGain = -1.7976931348623157E308;
        int i = 0;
        while (i < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[i]);
            if (inst.isMissing(att)) break;
            if (inst.value(att) > currSplit) {
                double[][] tempDist = new double[2][numClasses];
                int k = 0;
                while (k < 2) {
                    System.arraycopy(currDist[k], 0, tempDist[k], 0, tempDist[k].length);
                    ++k;
                }
                double[] tempProps = new double[2];
                int k2 = 0;
                while (k2 < 2) {
                    tempProps[k2] = Utils.sum(tempDist[k2]);
                    ++k2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int index = missingStart;
                while (index < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[index]);
                    int j2 = 0;
                    while (j2 < 2) {
                        double[] dArray = tempDist[j2];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j2] * weights[index];
                        ++j2;
                    }
                    ++index;
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (currGiniGain > bestGiniGain) {
                    bestGiniGain = currGiniGain;
                    splitPoint = (inst.value(att) + currSplit) / 2.0;
                    int j3 = 0;
                    while (j3 < currDist.length) {
                        System.arraycopy(tempDist[j3], 0, dist[j3], 0, dist[j3].length);
                        ++j3;
                    }
                }
            }
            currSplit = inst.value(att);
            double[] dArray = currDist[0];
            int n = (int)inst.classValue();
            dArray[n] = dArray[n] + weights[i];
            double[] dArray2 = currDist[1];
            int n2 = (int)inst.classValue();
            dArray2[n2] = dArray2[n2] - weights[i];
            ++i;
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        int k = 0;
        while (k < 2) {
            props[attIndex][k] = Utils.sum(dist[k]);
            ++k;
        }
        if (Utils.sum(props[attIndex]) != 0.0) {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        int j4 = 0;
        while (j4 < 2) {
            double[] dArray = subsetWeights[attIndex];
            int n = j4;
            dArray[n] = dArray[n] + Utils.sum(dist[j4]);
            ++j4;
        }
        giniGains[attIndex] = bestGiniGain;
        dists[attIndex] = dist;
        return splitPoint;
    }

    protected String nominalDistribution(double[][] props, double[][][] dists, Attribute att, int[] sortedIndices, double[] weights, double[][] subsetWeights, double[] giniGains, Instances data, boolean useHeuristic) throws Exception {
        String[] values = new String[att.numValues()];
        int numCat = values.length;
        int numClasses = data.numClasses();
        String bestSplitString = "";
        double bestGiniGain = -1.7976931348623157E308;
        int[] classFreq = new int[numCat];
        int j = 0;
        while (j < numCat) {
            classFreq[j] = 0;
            ++j;
        }
        double[] parentDist = new double[numClasses];
        double[][] currDist = new double[2][numClasses];
        double[][] dist = new double[2][numClasses];
        int missingStart = 0;
        int i = 0;
        while (i < sortedIndices.length) {
            Instance inst = data.instance(sortedIndices[i]);
            if (!inst.isMissing(att)) {
                ++missingStart;
                int n = (int)inst.value(att);
                classFreq[n] = classFreq[n] + 1;
            }
            int n = (int)inst.classValue();
            parentDist[n] = parentDist[n] + weights[i];
            ++i;
        }
        int nonEmpty = 0;
        int j2 = 0;
        while (j2 < numCat) {
            if (classFreq[j2] != 0) {
                ++nonEmpty;
            }
            ++j2;
        }
        String[] nonEmptyValues = new String[nonEmpty];
        int nonEmptyIndex = 0;
        int j3 = 0;
        while (j3 < numCat) {
            if (classFreq[j3] != 0) {
                nonEmptyValues[nonEmptyIndex] = att.value(j3);
                ++nonEmptyIndex;
            }
            ++j3;
        }
        int empty = numCat - nonEmpty;
        String[] emptyValues = new String[empty];
        int emptyIndex = 0;
        int j4 = 0;
        while (j4 < numCat) {
            if (classFreq[j4] == 0) {
                emptyValues[emptyIndex] = att.value(j4);
                ++emptyIndex;
            }
            ++j4;
        }
        if (nonEmpty <= 1) {
            giniGains[att.index()] = 0.0;
            return "";
        }
        if (data.numClasses() == 2) {
            int j5;
            double[] pClass0 = new double[nonEmpty];
            double[][] valDist = new double[nonEmpty][2];
            int j6 = 0;
            while (j6 < nonEmpty) {
                int k = 0;
                while (k < 2) {
                    valDist[j6][k] = 0.0;
                    ++k;
                }
                ++j6;
            }
            int i2 = 0;
            while (i2 < sortedIndices.length) {
                Instance inst = data.instance(sortedIndices[i2]);
                if (inst.isMissing(att)) break;
                j5 = 0;
                while (j5 < nonEmpty) {
                    if (att.value((int)inst.value(att)).compareTo(nonEmptyValues[j5]) == 0) {
                        double[] dArray = valDist[j5];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + inst.weight();
                        break;
                    }
                    ++j5;
                }
                ++i2;
            }
            j6 = 0;
            while (j6 < nonEmpty) {
                double distSum = Utils.sum(valDist[j6]);
                pClass0[j6] = distSum == 0.0 ? 0.0 : valDist[j6][0] / distSum;
                ++j6;
            }
            String[] sortedValues = new String[nonEmpty];
            int j7 = 0;
            while (j7 < nonEmpty) {
                sortedValues[j7] = nonEmptyValues[Utils.minIndex(pClass0)];
                pClass0[Utils.minIndex((double[])pClass0)] = Double.MAX_VALUE;
                ++j7;
            }
            String tempStr = "";
            j5 = 0;
            while (j5 < nonEmpty - 1) {
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j5] + ")" : String.valueOf(tempStr) + "|(" + sortedValues[j5] + ")";
                int i3 = 0;
                while (i3 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[i3]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[i3];
                    } else {
                        double[] dArray = currDist[1];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[i3];
                    }
                    ++i3;
                }
                double[][] tempDist = new double[2][numClasses];
                int kk = 0;
                while (kk < 2) {
                    tempDist[kk] = currDist[kk];
                    ++kk;
                }
                double[] tempProps = new double[2];
                int kk2 = 0;
                while (kk2 < 2) {
                    tempProps[kk2] = Utils.sum(tempDist[kk2]);
                    ++kk2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int mstart = missingStart;
                while (mstart < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    int jj = 0;
                    while (jj < 2) {
                        double[] dArray = tempDist[jj];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[jj] * weights[mstart];
                        ++jj;
                    }
                    ++mstart;
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (currGiniGain > bestGiniGain) {
                    bestGiniGain = currGiniGain;
                    bestSplitString = tempStr;
                    int jj = 0;
                    while (jj < 2) {
                        System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                        ++jj;
                    }
                }
                ++j5;
            }
        } else if (!useHeuristic || nonEmpty <= 4) {
            int i4 = 0;
            while (i4 < (int)Math.pow(2.0, nonEmpty - 1)) {
                String tempStr = "";
                currDist = new double[2][numClasses];
                int bit10 = i4;
                int j8 = nonEmpty - 1;
                while (j8 >= 0) {
                    int mod = bit10 % 2;
                    if (mod == 1) {
                        tempStr = tempStr == "" ? "(" + nonEmptyValues[j8] + ")" : String.valueOf(tempStr) + "|(" + nonEmptyValues[j8] + ")";
                    }
                    bit10 /= 2;
                    --j8;
                }
                j8 = 0;
                while (j8 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[j8]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[j8];
                    } else {
                        double[] dArray = currDist[1];
                        int n = (int)inst.classValue();
                        dArray[n] = dArray[n] + weights[j8];
                    }
                    ++j8;
                }
                double[][] tempDist = new double[2][numClasses];
                int k = 0;
                while (k < 2) {
                    tempDist[k] = currDist[k];
                    ++k;
                }
                double[] tempProps = new double[2];
                int k2 = 0;
                while (k2 < 2) {
                    tempProps[k2] = Utils.sum(tempDist[k2]);
                    ++k2;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int index = missingStart;
                while (index < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[index]);
                    int j9 = 0;
                    while (j9 < 2) {
                        double[] dArray = tempDist[j9];
                        int n = (int)insta.classValue();
                        dArray[n] = dArray[n] + tempProps[j9] * weights[index];
                        ++j9;
                    }
                    ++index;
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (currGiniGain > bestGiniGain) {
                    bestGiniGain = currGiniGain;
                    bestSplitString = tempStr;
                    int j10 = 0;
                    while (j10 < 2) {
                        System.arraycopy(tempDist[j10], 0, dist[j10], 0, dist[j10].length);
                        ++j10;
                    }
                }
                ++i4;
            }
        } else {
            int n = nonEmpty;
            int k = data.numClasses();
            double[][] P = new double[n][k];
            int[] numInstancesValue = new int[n];
            double[] meanClass = new double[k];
            int numInstances = data.numInstances();
            int j11 = 0;
            while (j11 < meanClass.length) {
                meanClass[j11] = 0.0;
                ++j11;
            }
            j11 = 0;
            while (j11 < numInstances) {
                Instance inst = data.instance(j11);
                int valueIndex = 0;
                int i5 = 0;
                while (i5 < nonEmpty) {
                    if (att.value((int)inst.value(att)).compareToIgnoreCase(nonEmptyValues[i5]) == 0) {
                        valueIndex = i5;
                        break;
                    }
                    ++i5;
                }
                double[] dArray = P[valueIndex];
                int n2 = (int)inst.classValue();
                dArray[n2] = dArray[n2] + 1.0;
                int n3 = valueIndex;
                numInstancesValue[n3] = numInstancesValue[n3] + 1;
                int n4 = (int)inst.classValue();
                meanClass[n4] = meanClass[n4] + 1.0;
                ++j11;
            }
            int i6 = 0;
            while (i6 < P.length) {
                int j12 = 0;
                while (j12 < P[0].length) {
                    if (numInstancesValue[i6] == 0) {
                        P[i6][j12] = 0.0;
                    } else {
                        double[] dArray = P[i6];
                        int n5 = j12;
                        dArray[n5] = dArray[n5] / (double)numInstancesValue[i6];
                    }
                    ++j12;
                }
                ++i6;
            }
            i6 = 0;
            while (i6 < meanClass.length) {
                int n6 = i6++;
                meanClass[n6] = meanClass[n6] / (double)numInstances;
            }
            double[][] covariance = new double[k][k];
            int i1 = 0;
            while (i1 < k) {
                int i2 = 0;
                while (i2 < k) {
                    double element = 0.0;
                    int j13 = 0;
                    while (j13 < n) {
                        element += (P[j13][i2] - meanClass[i2]) * (P[j13][i1] - meanClass[i1]) * (double)numInstancesValue[j13];
                        ++j13;
                    }
                    covariance[i1][i2] = element;
                    ++i2;
                }
                ++i1;
            }
            Matrix matrix = new Matrix(covariance);
            EigenvalueDecomposition eigen = new EigenvalueDecomposition(matrix);
            double[] eigenValues = eigen.getRealEigenvalues();
            int index = 0;
            double largest = eigenValues[0];
            int i7 = 1;
            while (i7 < eigenValues.length) {
                if (eigenValues[i7] > largest) {
                    index = i7;
                    largest = eigenValues[i7];
                }
                ++i7;
            }
            double[] FPC = new double[k];
            Matrix eigenVector = eigen.getV();
            double[][] vectorArray = eigenVector.getArray();
            int i8 = 0;
            while (i8 < FPC.length) {
                FPC[i8] = vectorArray[i8][index];
                ++i8;
            }
            double[] Sa = new double[n];
            int i9 = 0;
            while (i9 < Sa.length) {
                Sa[i9] = 0.0;
                int j14 = 0;
                while (j14 < k) {
                    int n7 = i9;
                    Sa[n7] = Sa[n7] + FPC[j14] * P[i9][j14];
                    ++j14;
                }
                ++i9;
            }
            double[] pCopy = new double[n];
            System.arraycopy(Sa, 0, pCopy, 0, n);
            String[] sortedValues = new String[n];
            Arrays.sort(Sa);
            int j15 = 0;
            while (j15 < n) {
                sortedValues[j15] = nonEmptyValues[Utils.minIndex(pCopy)];
                pCopy[Utils.minIndex((double[])pCopy)] = Double.MAX_VALUE;
                ++j15;
            }
            String tempStr = "";
            int j16 = 0;
            while (j16 < nonEmpty - 1) {
                currDist = new double[2][numClasses];
                tempStr = tempStr == "" ? "(" + sortedValues[j16] + ")" : String.valueOf(tempStr) + "|(" + sortedValues[j16] + ")";
                int i10 = 0;
                while (i10 < sortedIndices.length) {
                    Instance inst = data.instance(sortedIndices[i10]);
                    if (inst.isMissing(att)) break;
                    if (tempStr.indexOf("(" + att.value((int)inst.value(att)) + ")") != -1) {
                        double[] dArray = currDist[0];
                        int n8 = (int)inst.classValue();
                        dArray[n8] = dArray[n8] + weights[i10];
                    } else {
                        double[] dArray = currDist[1];
                        int n9 = (int)inst.classValue();
                        dArray[n9] = dArray[n9] + weights[i10];
                    }
                    ++i10;
                }
                double[][] tempDist = new double[2][numClasses];
                int kk = 0;
                while (kk < 2) {
                    tempDist[kk] = currDist[kk];
                    ++kk;
                }
                double[] tempProps = new double[2];
                int kk3 = 0;
                while (kk3 < 2) {
                    tempProps[kk3] = Utils.sum(tempDist[kk3]);
                    ++kk3;
                }
                if (Utils.sum(tempProps) != 0.0) {
                    Utils.normalize(tempProps);
                }
                int mstart = missingStart;
                while (mstart < sortedIndices.length) {
                    Instance insta = data.instance(sortedIndices[mstart]);
                    int jj = 0;
                    while (jj < 2) {
                        double[] dArray = tempDist[jj];
                        int n10 = (int)insta.classValue();
                        dArray[n10] = dArray[n10] + tempProps[jj] * weights[mstart];
                        ++jj;
                    }
                    ++mstart;
                }
                double currGiniGain = this.computeGiniGain(parentDist, tempDist);
                if (currGiniGain > bestGiniGain) {
                    bestGiniGain = currGiniGain;
                    bestSplitString = tempStr;
                    int jj = 0;
                    while (jj < 2) {
                        System.arraycopy(tempDist[jj], 0, dist[jj], 0, dist[jj].length);
                        ++jj;
                    }
                }
                ++j16;
            }
        }
        int attIndex = att.index();
        props[attIndex] = new double[2];
        int k = 0;
        while (k < 2) {
            props[attIndex][k] = Utils.sum(dist[k]);
            ++k;
        }
        if (!(Utils.sum(props[attIndex]) > 0.0)) {
            k = 0;
            while (k < props[attIndex].length) {
                props[attIndex][k] = 1.0 / (double)props[attIndex].length;
                ++k;
            }
        } else {
            Utils.normalize(props[attIndex]);
        }
        subsetWeights[attIndex] = new double[2];
        int j17 = 0;
        while (j17 < 2) {
            double[] dArray = subsetWeights[attIndex];
            int n = j17;
            dArray[n] = dArray[n] + Utils.sum(dist[j17]);
            ++j17;
        }
        j17 = 0;
        while (j17 < empty) {
            if (props[attIndex][0] >= props[attIndex][1]) {
                bestSplitString = bestSplitString == "" ? "(" + emptyValues[j17] + ")" : String.valueOf(bestSplitString) + "|(" + emptyValues[j17] + ")";
            }
            ++j17;
        }
        giniGains[attIndex] = bestGiniGain;
        dists[attIndex] = dist;
        return bestSplitString;
    }

    protected void splitData(int[][][] subsetIndices, double[][][] subsetWeights, Attribute att, double splitPoint, String splitStr, int[][] sortedIndices, double[][] weights, Instances data) throws Exception {
        int i = 0;
        while (i < data.numAttributes()) {
            if (i != data.classIndex()) {
                int[] num = new int[2];
                int k = 0;
                while (k < 2) {
                    subsetIndices[k][i] = new int[sortedIndices[i].length];
                    subsetWeights[k][i] = new double[weights[i].length];
                    ++k;
                }
                int j = 0;
                while (j < sortedIndices[i].length) {
                    Instance inst = data.instance(sortedIndices[i][j]);
                    if (inst.isMissing(att)) {
                        int k2 = 0;
                        while (k2 < 2) {
                            if (this.m_Props[k2] > 0.0) {
                                subsetIndices[k2][i][num[k2]] = sortedIndices[i][j];
                                subsetWeights[k2][i][num[k2]] = this.m_Props[k2] * weights[i][j];
                                int n = k2;
                                num[n] = num[n] + 1;
                            }
                            ++k2;
                        }
                    } else {
                        int subset = att.isNumeric() ? (inst.value(att) < splitPoint ? 0 : 1) : (splitStr.indexOf("(" + att.value((int)inst.value(att.index())) + ")") != -1 ? 0 : 1);
                        subsetIndices[subset][i][num[subset]] = sortedIndices[i][j];
                        subsetWeights[subset][i][num[subset]] = weights[i][j];
                        int n = subset;
                        num[n] = num[n] + 1;
                    }
                    ++j;
                }
                k = 0;
                while (k < 2) {
                    int[] copy = new int[num[k]];
                    System.arraycopy(subsetIndices[k][i], 0, copy, 0, num[k]);
                    subsetIndices[k][i] = copy;
                    double[] copyWeights = new double[num[k]];
                    System.arraycopy(subsetWeights[k][i], 0, copyWeights, 0, num[k]);
                    subsetWeights[k][i] = copyWeights;
                    ++k;
                }
            }
            ++i;
        }
    }

    public void modelErrors() throws Exception {
        Evaluation eval = new Evaluation(this.m_train);
        if (!this.m_isLeaf) {
            this.m_isLeaf = true;
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_numIncorrectModel = eval.incorrect();
            this.m_isLeaf = false;
            int i = 0;
            while (i < this.m_Successors.length) {
                this.m_Successors[i].modelErrors();
                ++i;
            }
        } else {
            eval.evaluateModel(this, this.m_train, new Object[0]);
            this.m_numIncorrectModel = eval.incorrect();
        }
    }

    public void treeErrors() throws Exception {
        if (this.m_isLeaf) {
            this.m_numIncorrectTree = this.m_numIncorrectModel;
        } else {
            this.m_numIncorrectTree = 0.0;
            int i = 0;
            while (i < this.m_Successors.length) {
                this.m_Successors[i].treeErrors();
                this.m_numIncorrectTree += this.m_Successors[i].m_numIncorrectTree;
                ++i;
            }
        }
    }

    public void calculateAlphas() throws Exception {
        if (!this.m_isLeaf) {
            double errorDiff = this.m_numIncorrectModel - this.m_numIncorrectTree;
            if (errorDiff <= 0.0) {
                this.makeLeaf(this.m_train);
                this.m_Alpha = Double.MAX_VALUE;
            } else {
                this.m_Alpha = (errorDiff /= (double)this.m_totalTrainInstances) / (double)(this.numLeaves() - 1);
                long alphaLong = Math.round(this.m_Alpha * Math.pow(10.0, 10.0));
                this.m_Alpha = (double)alphaLong / Math.pow(10.0, 10.0);
                int i = 0;
                while (i < this.m_Successors.length) {
                    this.m_Successors[i].calculateAlphas();
                    ++i;
                }
            }
        } else {
            this.m_Alpha = Double.MAX_VALUE;
        }
    }

    protected SimpleCart nodeToPrune(Vector nodeList) {
        if (nodeList.size() == 0) {
            return null;
        }
        if (nodeList.size() == 1) {
            return (SimpleCart)nodeList.elementAt(0);
        }
        SimpleCart returnNode = (SimpleCart)nodeList.elementAt(0);
        double baseAlpha = returnNode.m_Alpha;
        int i = 1;
        while (i < nodeList.size()) {
            SimpleCart node = (SimpleCart)nodeList.elementAt(i);
            if (node.m_Alpha < baseAlpha) {
                baseAlpha = node.m_Alpha;
                returnNode = node;
            } else if (node.m_Alpha == baseAlpha && node.numLeaves() > returnNode.numLeaves()) {
                returnNode = node;
            }
            ++i;
        }
        return returnNode;
    }

    protected double computeSortedInfo(Instances data, int[][] sortedIndices, double[][] weights, double[] classProbs) throws Exception {
        Instance inst;
        double[] vals = new double[data.numInstances()];
        int j = 0;
        while (j < data.numAttributes()) {
            if (j != data.classIndex()) {
                weights[j] = new double[data.numInstances()];
                if (data.attribute(j).isNominal()) {
                    sortedIndices[j] = new int[data.numInstances()];
                    int count = 0;
                    int i = 0;
                    while (i < data.numInstances()) {
                        inst = data.instance(i);
                        if (!inst.isMissing(j)) {
                            sortedIndices[j][count] = i;
                            weights[j][count] = inst.weight();
                            ++count;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < data.numInstances()) {
                        inst = data.instance(i);
                        if (inst.isMissing(j)) {
                            sortedIndices[j][count] = i;
                            weights[j][count] = inst.weight();
                            ++count;
                        }
                        ++i;
                    }
                } else {
                    int i = 0;
                    while (i < data.numInstances()) {
                        Instance inst2 = data.instance(i);
                        vals[i] = inst2.value(j);
                        ++i;
                    }
                    sortedIndices[j] = Utils.sort(vals);
                    i = 0;
                    while (i < data.numInstances()) {
                        weights[j][i] = data.instance(sortedIndices[j][i]).weight();
                        ++i;
                    }
                }
            }
            ++j;
        }
        double totalWeight = 0.0;
        int i = 0;
        while (i < data.numInstances()) {
            inst = data.instance(i);
            int n = (int)inst.classValue();
            classProbs[n] = classProbs[n] + inst.weight();
            totalWeight += inst.weight();
            ++i;
        }
        return totalWeight;
    }

    protected double computeGiniGain(double[] parentDist, double[][] childDist) {
        double totalWeight = Utils.sum(parentDist);
        if (totalWeight == 0.0) {
            return 0.0;
        }
        double leftWeight = Utils.sum(childDist[0]);
        double rightWeight = Utils.sum(childDist[1]);
        double parentGini = this.computeGini(parentDist, totalWeight);
        double leftGini = this.computeGini(childDist[0], leftWeight);
        double rightGini = this.computeGini(childDist[1], rightWeight);
        return parentGini - leftWeight / totalWeight * leftGini - rightWeight / totalWeight * rightGini;
    }

    protected double computeGini(double[] dist, double total) {
        if (total == 0.0) {
            return 0.0;
        }
        double val = 0.0;
        int i = 0;
        while (i < dist.length) {
            val += dist[i] / total * (dist[i] / total);
            ++i;
        }
        return 1.0 - val;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        if (!this.m_isLeaf) {
            if (instance.isMissing(this.m_Attribute)) {
                double[] returnedDist = new double[this.m_ClassProbs.length];
                int i = 0;
                while (i < this.m_Successors.length) {
                    double[] help = this.m_Successors[i].distributionForInstance(instance);
                    if (help != null) {
                        int j = 0;
                        while (j < help.length) {
                            int n = j;
                            returnedDist[n] = returnedDist[n] + this.m_Props[i] * help[j];
                            ++j;
                        }
                    }
                    ++i;
                }
                return returnedDist;
            }
            if (this.m_Attribute.isNominal()) {
                if (this.m_SplitString.indexOf("(" + this.m_Attribute.value((int)instance.value(this.m_Attribute)) + ")") != -1) {
                    return this.m_Successors[0].distributionForInstance(instance);
                }
                return this.m_Successors[1].distributionForInstance(instance);
            }
            if (instance.value(this.m_Attribute) < this.m_SplitValue) {
                return this.m_Successors[0].distributionForInstance(instance);
            }
            return this.m_Successors[1].distributionForInstance(instance);
        }
        return this.m_ClassProbs;
    }

    protected void makeLeaf(Instances data) {
        this.m_Attribute = null;
        this.m_isLeaf = true;
        this.m_ClassValue = Utils.maxIndex(this.m_ClassProbs);
        this.m_ClassAttribute = data.classAttribute();
    }

    public String toString() {
        if (this.m_ClassProbs == null && this.m_Successors == null) {
            return "CART Tree: No model built yet.";
        }
        return "CART Decision Tree\n" + this.toString(0) + "\n\n" + "Number of Leaf Nodes: " + this.numLeaves() + "\n\n" + "Size of the Tree: " + this.numNodes();
    }

    protected String toString(int level) {
        StringBuffer text = new StringBuffer();
        if (this.m_Attribute == null) {
            if (Instance.isMissingValue(this.m_ClassValue)) {
                text.append(": null");
            } else {
                double correctNum = (double)((int)(this.m_Distribution[Utils.maxIndex(this.m_Distribution)] * 100.0)) / 100.0;
                double wrongNum = (double)((int)((Utils.sum(this.m_Distribution) - this.m_Distribution[Utils.maxIndex(this.m_Distribution)]) * 100.0)) / 100.0;
                String str = "(" + correctNum + "/" + wrongNum + ")";
                text.append(": " + this.m_ClassAttribute.value((int)this.m_ClassValue) + str);
            }
        } else {
            int j = 0;
            while (j < 2) {
                text.append("\n");
                int i = 0;
                while (i < level) {
                    text.append("|  ");
                    ++i;
                }
                if (j == 0) {
                    if (this.m_Attribute.isNumeric()) {
                        text.append(String.valueOf(this.m_Attribute.name()) + " < " + this.m_SplitValue);
                    } else {
                        text.append(String.valueOf(this.m_Attribute.name()) + "=" + this.m_SplitString);
                    }
                } else if (this.m_Attribute.isNumeric()) {
                    text.append(String.valueOf(this.m_Attribute.name()) + " >= " + this.m_SplitValue);
                } else {
                    text.append(String.valueOf(this.m_Attribute.name()) + "!=" + this.m_SplitString);
                }
                text.append(this.m_Successors[j].toString(level + 1));
                ++j;
            }
        }
        return text.toString();
    }

    public int numNodes() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 1;
        int i = 0;
        while (i < this.m_Successors.length) {
            size += this.m_Successors[i].numNodes();
            ++i;
        }
        return size;
    }

    public int numInnerNodes() {
        if (this.m_Attribute == null) {
            return 0;
        }
        int numNodes = 1;
        int i = 0;
        while (i < this.m_Successors.length) {
            numNodes += this.m_Successors[i].numInnerNodes();
            ++i;
        }
        return numNodes;
    }

    protected Vector getInnerNodes() {
        Vector nodeList = new Vector();
        this.fillInnerNodes(nodeList);
        return nodeList;
    }

    protected void fillInnerNodes(Vector nodeList) {
        if (!this.m_isLeaf) {
            nodeList.add(this);
            int i = 0;
            while (i < this.m_Successors.length) {
                this.m_Successors[i].fillInnerNodes(nodeList);
                ++i;
            }
        }
    }

    public int numLeaves() {
        if (this.m_isLeaf) {
            return 1;
        }
        int size = 0;
        int i = 0;
        while (i < this.m_Successors.length) {
            size += this.m_Successors[i].numLeaves();
            ++i;
        }
        return size;
    }

    @Override
    public Enumeration listOptions() {
        Vector result = new Vector();
        Enumeration en = super.listOptions();
        while (en.hasMoreElements()) {
            result.addElement(en.nextElement());
        }
        result.addElement(new Option("\tThe minimal number of instances at the terminal nodes.\n\t(default 2)", "M", 1, "-M <min no>"));
        result.addElement(new Option("\tThe number of folds used in the minimal cost-complexity pruning.\n\t(default 5)", "N", 1, "-N <num folds>"));
        result.addElement(new Option("\tDon't use the minimal cost-complexity pruning.\n\t(default yes).", "U", 0, "-U"));
        result.addElement(new Option("\tDon't use the heuristic method for binary split.\n\t(default true).", "H", 0, "-H"));
        result.addElement(new Option("\tUse 1 SE rule to make pruning decision.\n\t(default no).", "A", 0, "-A"));
        result.addElement(new Option("\tPercentage of training data size (0-1].\n\t(default 1).", "C", 1, "-C"));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        super.setOptions(options);
        String tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setMinNumObj(Double.parseDouble(tmpStr));
        } else {
            this.setMinNumObj(2.0);
        }
        tmpStr = Utils.getOption('N', options);
        if (tmpStr.length() != 0) {
            this.setNumFoldsPruning(Integer.parseInt(tmpStr));
        } else {
            this.setNumFoldsPruning(5);
        }
        this.setUsePrune(!Utils.getFlag('U', options));
        this.setHeuristic(!Utils.getFlag('H', options));
        this.setUseOneSE(Utils.getFlag('A', options));
        tmpStr = Utils.getOption('C', options);
        if (tmpStr.length() != 0) {
            this.setSizePer(Double.parseDouble(tmpStr));
        } else {
            this.setSizePer(1.0);
        }
        Utils.checkForRemainingOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        String[] options = super.getOptions();
        int i = 0;
        while (i < options.length) {
            result.add(options[i]);
            ++i;
        }
        result.add("-M");
        result.add("" + this.getMinNumObj());
        result.add("-N");
        result.add("" + this.getNumFoldsPruning());
        if (!this.getUsePrune()) {
            result.add("-U");
        }
        if (!this.getHeuristic()) {
            result.add("-H");
        }
        if (this.getUseOneSE()) {
            result.add("-A");
        }
        result.add("-C");
        result.add("" + this.getSizePer());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public Enumeration enumerateMeasures() {
        Vector<String> result = new Vector<String>();
        result.addElement("measureTreeSize");
        return result.elements();
    }

    public double measureTreeSize() {
        return this.numNodes();
    }

    @Override
    public double getMeasure(String additionalMeasureName) {
        if (additionalMeasureName.compareToIgnoreCase("measureTreeSize") == 0) {
            return this.measureTreeSize();
        }
        throw new IllegalArgumentException(String.valueOf(additionalMeasureName) + " not supported (Cart pruning)");
    }

    public String minNumObjTipText() {
        return "The minimal number of observations at the terminal nodes (default 2).";
    }

    public void setMinNumObj(double value) {
        this.m_minNumObj = value;
    }

    public double getMinNumObj() {
        return this.m_minNumObj;
    }

    public String numFoldsPruningTipText() {
        return "The number of folds in the internal cross-validation (default 5).";
    }

    public void setNumFoldsPruning(int value) {
        this.m_numFoldsPruning = value;
    }

    public int getNumFoldsPruning() {
        return this.m_numFoldsPruning;
    }

    public String usePruneTipText() {
        return "Use minimal cost-complexity pruning (default yes).";
    }

    public void setUsePrune(boolean value) {
        this.m_Prune = value;
    }

    public boolean getUsePrune() {
        return this.m_Prune;
    }

    public String heuristicTipText() {
        return "If heuristic search is used for binary split for nominal attributes in multi-class problems (default yes).";
    }

    public void setHeuristic(boolean value) {
        this.m_Heuristic = value;
    }

    public boolean getHeuristic() {
        return this.m_Heuristic;
    }

    public String useOneSETipText() {
        return "Use the 1SE rule to make pruning decisoin.";
    }

    public void setUseOneSE(boolean value) {
        this.m_UseOneSE = value;
    }

    public boolean getUseOneSE() {
        return this.m_UseOneSE;
    }

    public String sizePerTipText() {
        return "The percentage of the training set size (0-1, 0 not included).";
    }

    public void setSizePer(double value) {
        if (value <= 0.0 || value > 1.0) {
            System.err.println("The percentage of the training set size must be in range 0 to 1 (0 not included) - ignored!");
        } else {
            this.m_SizePer = value;
        }
    }

    public double getSizePer() {
        return this.m_SizePer;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5535 $");
    }

    public static void main(String[] args) {
        SimpleCart.runClassifier(new SimpleCart(), args);
    }
}

