/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter.visitors;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.False;
import org.dmg.pmml.MiningFunction;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.tree.Node;
import org.dmg.pmml.tree.TreeModel;
import org.jpmml.converter.visitors.AbstractTreeModelTransformer;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.model.UnsupportedAttributeException;

public class TreeModelPruner
extends AbstractTreeModelTransformer {
    private MiningFunction miningFunction = null;

    @Override
    public void enterNode(Node node) {
        Object defaultChild = node.getDefaultChild();
        if (node.hasNodes()) {
            List children = node.getNodes();
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Predicate predicate;
                Node child = (Node)it.next();
                if (defaultChild != null && TreeModelPruner.equalsNode(defaultChild, child) || !((predicate = child.requirePredicate()) instanceof False)) continue;
                it.remove();
            }
        }
    }

    @Override
    public void exitNode(Node node) {
        List children;
        Object defaultChild = node.getDefaultChild();
        Predicate predicate = node.requirePredicate();
        Number recordCount = node.getRecordCount();
        if (node.hasNodes() && (children = node.getNodes()).size() == 1) {
            Node child = (Node)children.get(0);
            Predicate childPredicate = child.requirePredicate();
            Number childRecordCount = child.getRecordCount();
            if (ReflectionUtil.equals((PMMLObject)predicate, (PMMLObject)childPredicate) && Objects.equals(recordCount, childRecordCount)) {
                if (defaultChild != null) {
                    node.setDefaultChild(null);
                }
                if (this.miningFunction == MiningFunction.REGRESSION) {
                    TreeModelPruner.initScore(node, child);
                } else if (this.miningFunction == MiningFunction.CLASSIFICATION) {
                    TreeModelPruner.initScoreDistribution(node, child);
                }
                TreeModelPruner.initDefaultChild(node, child);
                TreeModelPruner.replaceChildWithGrandchildren(node, child);
            }
        }
    }

    @Override
    public void enterTreeModel(TreeModel treeModel) {
        super.enterTreeModel(treeModel);
        MiningFunction miningFunction = treeModel.requireMiningFunction();
        switch (miningFunction) {
            case REGRESSION: 
            case CLASSIFICATION: {
                break;
            }
            default: {
                throw new UnsupportedAttributeException((PMMLObject)treeModel, (Enum)miningFunction);
            }
        }
        this.miningFunction = miningFunction;
    }

    @Override
    public void exitTreeModel(TreeModel treeModel) {
        super.exitTreeModel(treeModel);
        this.miningFunction = null;
    }
}

