/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.tree.structure.internalStructure.degreeStructure;

import choco.cp.solver.constraints.global.tree.structure.inputStructure.TreeParameters;
import choco.cp.solver.constraints.global.tree.structure.internalStructure.graphStructures.graphViews.VarGraphView;
import choco.kernel.common.logging.ChocoLogging;
import choco.kernel.memory.IStateBitSet;
import choco.kernel.solver.Solver;
import choco.kernel.solver.variables.integer.IntDomainVar;
import java.util.BitSet;
import java.util.logging.Logger;

public class DegreeStructure {
    protected static final Logger LOGGER = ChocoLogging.getEngineLogger();
    protected boolean affiche = false;
    protected Solver solver;
    protected TreeParameters tree;
    protected VarGraphView graph;
    protected int nbVertices;
    protected int nbLeftVertices;
    protected BitSet[] gccVars;
    protected int[] indexVars;
    protected int[] OriginalMinFlow;
    protected int[] OriginalMaxFlow;
    protected int[] low;
    protected int[] up;
    protected boolean degree;

    public DegreeStructure(Solver solver, TreeParameters tree, VarGraphView graph) {
        this.solver = solver;
        this.tree = tree;
        this.graph = graph;
        this.nbVertices = tree.getNbNodes();
        this.initFlow();
    }

    private void initFlow() {
        IntDomainVar deg_i;
        int i;
        this.indexVars = new int[this.nbVertices];
        this.degree = true;
        for (i = 0; i < this.nbVertices; ++i) {
            this.indexVars[i] = i;
        }
        this.gccVars = new BitSet[this.nbVertices];
        this.nbLeftVertices = this.nbVertices;
        for (i = 0; i < this.nbVertices; ++i) {
            BitSet succ = new BitSet(this.nbVertices + 1);
            IStateBitSet next_i = this.graph.getGlobal().getSuccessors(i);
            int j = next_i.nextSetBit(0);
            while (j >= 0) {
                if (j != i) {
                    succ.set(j, true);
                }
                if (j == i) {
                    succ.set(this.nbVertices, true);
                }
                j = next_i.nextSetBit(j + 1);
            }
            this.gccVars[i] = succ;
        }
        this.OriginalMinFlow = new int[this.nbVertices + 1];
        for (i = 0; i < this.OriginalMinFlow.length; ++i) {
            this.OriginalMinFlow[i] = 0;
        }
        this.low = new int[this.nbVertices + 1];
        for (i = 0; i < this.low.length; ++i) {
            if (i < this.nbVertices) {
                deg_i = this.tree.getNodes()[i].getInDegree();
                this.low[i] = deg_i.getInf();
                this.OriginalMinFlow[i] = deg_i.getInf();
            }
            if (i != this.nbVertices) continue;
            this.low[i] = this.tree.getNtree().getInf();
            this.OriginalMinFlow[i] = this.tree.getNtree().getInf();
        }
        this.OriginalMaxFlow = new int[this.nbVertices + 1];
        for (i = 0; i < this.OriginalMaxFlow.length; ++i) {
            this.OriginalMaxFlow[i] = 0;
        }
        this.up = new int[this.nbVertices + 1];
        for (i = 0; i < this.up.length; ++i) {
            if (i < this.nbVertices) {
                deg_i = this.tree.getNodes()[i].getInDegree();
                this.up[i] = deg_i.getSup();
                this.OriginalMaxFlow[i] = deg_i.getSup();
            }
            if (i != this.nbVertices) continue;
            this.up[i] = this.tree.getNtree().getSup();
            this.OriginalMaxFlow[i] = this.tree.getNtree().getSup();
        }
    }

    public boolean needUpdate() {
        this.initFlow();
        for (int i = 0; i <= this.nbVertices; ++i) {
            int deg_i = 0;
            boolean instNull_i = this.OriginalMaxFlow[i] == this.OriginalMaxFlow[i] && this.OriginalMaxFlow[i] == 0;
            for (BitSet gccVar : this.gccVars) {
                if (!gccVar.get(i)) continue;
                ++deg_i;
            }
            if (!instNull_i && deg_i <= this.OriginalMaxFlow[i]) {
                return true;
            }
            if (!instNull_i || deg_i <= 0) continue;
            return true;
        }
        return false;
    }

    public void updateDegree() {
        int i;
        int[] mindeg = new int[this.low.length];
        int[] maxdeg = new int[this.up.length];
        this.updateCurrentDeg(mindeg, maxdeg);
        this.updateGccVars(mindeg, maxdeg);
        for (i = 0; i <= this.nbVertices; ++i) {
            this.up[i] = maxdeg[i];
            this.low[i] = mindeg[i];
        }
        for (i = 0; i < this.nbVertices; ++i) {
            IStateBitSet maybePred_i = this.graph.getMaybe().getPredecessors(i);
            IStateBitSet surePred_i = this.graph.getSure().getPredecessors(i);
            int nbused_i = surePred_i.get(i) ? surePred_i.cardinality() - 1 : surePred_i.cardinality();
            int nbpotused_i = maybePred_i.get(i) ? maybePred_i.cardinality() - 1 : maybePred_i.cardinality();
            if (nbpotused_i < nbused_i) {
                nbpotused_i = nbused_i;
            }
            if (nbused_i > this.OriginalMaxFlow[i]) {
                this.degree = false;
            }
            if (nbpotused_i >= this.OriginalMinFlow[i]) continue;
            this.degree = false;
        }
        if (this.affiche) {
            LOGGER.info("*********************************");
            for (i = 0; i < this.nbVertices + 1; ++i) {
                LOGGER.info("deg[" + i + "] = [" + this.low[i] + "," + this.up[i] + "]");
            }
            LOGGER.info("------------------------------------------");
            for (i = 0; i < this.nbVertices; ++i) {
                LOGGER.info("gcc[" + i + "] = " + this.gccVars[i].toString());
            }
            LOGGER.info("*********************************");
        }
    }

    private void updateCurrentDeg(int[] mindeg, int[] maxdeg) {
        int i;
        int[] canBeUsed = new int[this.nbVertices + 1];
        int[] usedByInst = new int[this.nbVertices + 1];
        for (i = 0; i < canBeUsed.length; ++i) {
            canBeUsed[i] = 0;
            usedByInst[i] = 0;
        }
        for (i = 0; i < this.nbVertices; ++i) {
            IStateBitSet pred_i = this.graph.getGlobal().getPredecessors(i);
            IStateBitSet surePred_i = this.graph.getSure().getPredecessors(i);
            if (pred_i.get(i)) {
                int n = i;
                canBeUsed[n] = canBeUsed[n] + (pred_i.cardinality() - 1);
                int n2 = this.nbVertices;
                canBeUsed[n2] = canBeUsed[n2] + 1;
                if (!surePred_i.get(i)) continue;
                int n3 = i;
                usedByInst[n3] = usedByInst[n3] + (surePred_i.cardinality() - 1);
                int n4 = this.nbVertices;
                usedByInst[n4] = usedByInst[n4] + 1;
                continue;
            }
            int n = i;
            canBeUsed[n] = canBeUsed[n] + pred_i.cardinality();
            int n5 = i;
            usedByInst[n5] = usedByInst[n5] + surePred_i.cardinality();
        }
        for (i = 0; i < mindeg.length; ++i) {
            if (i < this.nbVertices) {
                mindeg[i] = this.OriginalMinFlow[i] <= usedByInst[i] && usedByInst[i] <= this.OriginalMaxFlow[i] ? usedByInst[i] : this.OriginalMinFlow[i];
            }
            if (i != this.nbVertices) continue;
            mindeg[i] = Math.max(this.tree.getNtree().getInf(), Math.max(usedByInst[i], this.OriginalMinFlow[i]));
        }
        for (i = 0; i < maxdeg.length; ++i) {
            if (i < this.nbVertices) {
                maxdeg[i] = this.OriginalMaxFlow[i] >= canBeUsed[i] && canBeUsed[i] >= this.OriginalMinFlow[i] ? canBeUsed[i] : this.OriginalMaxFlow[i];
            }
            if (i != this.nbVertices) continue;
            maxdeg[i] = Math.min(this.tree.getNtree().getSup(), Math.min(canBeUsed[i], this.OriginalMaxFlow[i]));
        }
    }

    private void updateGccVars(int[] mindeg, int[] maxdeg) {
        int i;
        int nbInstVars = 0;
        for (i = 0; i < this.nbVertices; ++i) {
            if (this.graph.getSure().getSuccessors(i).cardinality() <= 0) continue;
            ++nbInstVars;
        }
        this.nbLeftVertices = this.nbVertices - nbInstVars;
        this.gccVars = new BitSet[this.nbVertices - nbInstVars];
        this.indexVars = new int[this.nbVertices - nbInstVars];
        for (i = 0; i < this.gccVars.length; ++i) {
            this.gccVars[i] = new BitSet(this.nbVertices + 1);
        }
        for (i = 0; i < this.indexVars.length; ++i) {
            this.indexVars[i] = i;
        }
        int decal = 0;
        for (int i2 = 0; i2 < this.nbVertices; ++i2) {
            IStateBitSet maybeSucc_i = this.graph.getMaybe().getSuccessors(i2);
            IStateBitSet sureSucc_i = this.graph.getSure().getSuccessors(i2);
            int j = maybeSucc_i.nextSetBit(0);
            while (j >= 0) {
                if (i2 != j) {
                    this.gccVars[i2 - decal].set(j, true);
                }
                if (i2 == j) {
                    this.gccVars[i2 - decal].set(this.nbVertices, true);
                }
                this.indexVars[i2 - decal] = i2;
                j = maybeSucc_i.nextSetBit(j + 1);
            }
            j = sureSucc_i.nextSetBit(0);
            while (j >= 0) {
                if (j == i2) {
                    j = this.nbVertices;
                }
                ++decal;
                maxdeg[j] = maxdeg[j] - 1;
                mindeg[j] = mindeg[j] - 1;
                if (maxdeg[j] < 0) {
                    maxdeg[j] = 0;
                    mindeg[j] = 0;
                }
                if (mindeg[j] < 0) {
                    mindeg[j] = 0;
                }
                j = sureSucc_i.nextSetBit(j + 1);
            }
        }
    }

    public boolean isCompatibleDegree() {
        return this.degree;
    }

    public int[] getLow() {
        return this.low;
    }

    public int[] getUp() {
        return this.up;
    }

    public BitSet[] getGccVars() {
        return this.gccVars;
    }

    public int getNbLeftVertices() {
        return this.nbLeftVertices;
    }

    public int[] getIndexVars() {
        return this.indexVars;
    }
}

