/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.kernel.common.util.tools.MathUtils;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.constraints.integer.AbstractTernIntSConstraint;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class TimesXYZ
extends AbstractTernIntSConstraint {
    private static final int MAX = 0x7FFFFFFE;
    private static final int MIN = -2147483647;

    public TimesXYZ(IntDomainVar x, IntDomainVar y, IntDomainVar z) {
        super(x, y, z);
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return tuple[0] * tuple[1] == tuple[2];
    }

    @Override
    public String pretty() {
        return this.v0.pretty() + " * " + this.v1.pretty() + " = " + this.v2.pretty();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
            if (!this.v2.canBeInstantiatedTo(0)) {
                int r = (int)Math.min(this.getZmax(), 0x7FFFFFFEL);
                this.v2.updateSup(r, this, false);
            }
        }
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
            if (!this.v2.canBeInstantiatedTo(0)) {
                int r = (int)Math.max(this.getZmin(), -2147483647L);
                this.v2.updateInf(r, this, false);
            }
        }
    }

    public void filter(int idx) throws ContradictionException {
        if (idx == 0) {
            this.awakeOnX();
        } else if (idx == 1) {
            this.awakeOnY();
        } else if (idx == 2) {
            this.awakeOnZ();
        }
    }

    @Override
    public void awakeOnInst(int vIdx) throws ContradictionException {
        this.filter(vIdx);
    }

    protected void awakeOnX() throws ContradictionException {
        if (this.v0.isInstantiatedTo(0)) {
            this.v2.instantiate(0, this, false);
        }
        if (this.v2.isInstantiatedTo(0) && !this.v0.canBeInstantiatedTo(0)) {
            this.v1.instantiate(0, this, false);
        } else if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateYandX();
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnYandX();
        }
        if (!this.v2.isInstantiatedTo(0)) {
            int r = (int)Math.max(this.getZmin(), -2147483647L);
            this.v2.updateInf(r, this, false);
            r = (int)Math.min(this.getZmax(), 0x7FFFFFFEL);
            this.v2.updateSup(r, this, false);
        }
    }

    protected void awakeOnY() throws ContradictionException {
        if (this.v1.isInstantiatedTo(0)) {
            this.v2.instantiate(0, this, false);
        }
        if (this.v2.isInstantiatedTo(0) && !this.v1.canBeInstantiatedTo(0)) {
            this.v0.instantiate(0, this, false);
        } else if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateXandY();
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnXandY();
        }
        if (!this.v2.isInstantiatedTo(0)) {
            int r = (int)Math.max(this.getZmin(), -2147483647L);
            this.v2.updateInf(r, this, false);
            r = (int)Math.min(this.getZmax(), 0x7FFFFFFEL);
            this.v2.updateSup(r, this, false);
        }
    }

    protected void awakeOnZ() throws ContradictionException {
        if (!this.v2.canBeInstantiatedTo(0)) {
            this.updateX();
            if (this.updateY()) {
                this.updateXandY();
            }
        } else if (!this.v2.isInstantiatedTo(0)) {
            this.shaveOnX();
            if (this.shaveOnY()) {
                this.shaveOnXandY();
            }
        }
        if (this.v2.isInstantiatedTo(0)) {
            this.propagateZero();
        }
    }

    @Override
    public Boolean isEntailed() {
        if (this.isCompletelyInstantiated() && this.isSatisfied()) {
            return Boolean.TRUE;
        }
        if (this.v2.isInstantiatedTo(0)) {
            if (this.v0.isInstantiatedTo(0) || this.v1.isInstantiatedTo(0)) {
                return Boolean.TRUE;
            }
            if (!this.v0.canBeInstantiatedTo(0) && !this.v1.canBeInstantiatedTo(0)) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (!this.v2.canBeInstantiatedTo(0)) {
            if ((long)this.v0.getSup() < this.getXminIfNonZero()) {
                return Boolean.FALSE;
            }
            if ((long)this.v0.getInf() > this.getXmaxIfNonZero()) {
                return Boolean.FALSE;
            }
            if ((long)this.v1.getSup() < this.getYminIfNonZero()) {
                return Boolean.FALSE;
            }
            if ((long)this.v1.getInf() > this.getYmaxIfNonZero()) {
                return Boolean.FALSE;
            }
            return null;
        }
        return null;
    }

    protected long getXminIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.infCeilmM(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.infCeilMm(this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.infCeilMM(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.infCeilmm(this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.infCeilMM(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infCeilmP(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.infCeilmm(this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infCeilMN(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infCeilxx(this.v2);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected long getXmaxIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.supCeilMm(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.supCeilmM(this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.supCeilmm(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.supCeilMM(this.v2, this.v1);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.supCeilmM(this.v2, this.v1);
        }
        if (this.v2.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supCeilmN(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.supCeilMm(this.v2, this.v1);
        }
        if (this.v2.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supCeilMP(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supCeilEq(this.v2);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected long getYminIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v0.getInf() >= 0) {
            return this.infCeilmM(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getSup() <= 0) {
            return this.infCeilMm(this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getSup() <= 0) {
            return this.infCeilMM(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() >= 0) {
            return this.infCeilmm(this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getSup() <= 0) {
            return this.infCeilMM(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.infCeilmP(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() >= 0) {
            return this.infCeilmm(this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.infCeilMN(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.infCeilxx(this.v2);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected long getYmaxIfNonZero() {
        if (this.v2.getInf() >= 0 && this.v0.getInf() >= 0) {
            return this.supCeilMm(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getSup() <= 0) {
            return this.supCeilmM(this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getSup() <= 0) {
            return this.supCeilmm(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() >= 0) {
            return this.supCeilMM(this.v2, this.v0);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getSup() <= 0) {
            return this.supCeilmM(this.v2, this.v0);
        }
        if (this.v2.getSup() <= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.supCeilmN(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() >= 0) {
            return this.supCeilMm(this.v2, this.v0);
        }
        if (this.v2.getInf() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.supCeilMP(this.v2);
        }
        if (this.v2.getInf() <= 0 && this.v2.getSup() >= 0 && this.v0.getInf() <= 0 && this.v0.getSup() >= 0) {
            return this.supCeilEq(this.v2);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected long getZmin() {
        if (this.v0.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.infFloormm(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.infFloorMM(this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.infFloorMm(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.infFloormM(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.infFloorMm(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infFloormM(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.infFloormM(this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infFloorMm(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.infFloorxx(this.v0, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    protected long getZmax() {
        if (this.v0.getInf() >= 0 && this.v1.getInf() >= 0) {
            return this.supFloorMM(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getSup() <= 0) {
            return this.supFloormm(this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getSup() <= 0) {
            return this.supFloormM(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() >= 0) {
            return this.supFloorMm(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getSup() <= 0) {
            return this.supFloormm(this.v0, this.v1);
        }
        if (this.v0.getSup() <= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supFloormm(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() >= 0) {
            return this.supFloorMM(this.v0, this.v1);
        }
        if (this.v0.getInf() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supFloorMM(this.v0, this.v1);
        }
        if (this.v0.getInf() <= 0 && this.v0.getSup() >= 0 && this.v1.getInf() <= 0 && this.v1.getSup() >= 0) {
            return this.supFloorEq(this.v0, this.v1);
        }
        throw new SolverException("None of the cases is active!");
    }

    private long infFloormm(IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getInf();
    }

    private long infFloormM(IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getSup();
    }

    private long infFloorMm(IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getInf();
    }

    private long infFloorMM(IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getSup();
    }

    private long supFloormm(IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getInf();
    }

    private long supFloormM(IntDomainVar b, IntDomainVar c) {
        return b.getInf() * c.getSup();
    }

    private long supFloorMm(IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getInf();
    }

    private long supFloorMM(IntDomainVar b, IntDomainVar c) {
        return b.getSup() * c.getSup();
    }

    private int getNonZeroSup(IntDomainVar v) {
        return Math.min(v.getSup(), -1);
    }

    private int getNonZeroInf(IntDomainVar v) {
        return Math.max(v.getInf(), 1);
    }

    private long infCeilmm(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divCeil(b.getInf(), this.getNonZeroInf(c));
    }

    private long infCeilmM(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divCeil(this.getNonZeroInf(b), c.getSup());
    }

    private long infCeilMm(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divCeil(this.getNonZeroSup(b), c.getInf());
    }

    private long infCeilMM(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divCeil(b.getSup(), this.getNonZeroSup(c));
    }

    private long infCeilmP(IntDomainVar b) {
        return MathUtils.divCeil(b.getInf(), 1);
    }

    private long infCeilMN(IntDomainVar b) {
        return MathUtils.divCeil(b.getSup(), -1);
    }

    private long supCeilmm(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divFloor(this.getNonZeroInf(b), c.getInf());
    }

    private long supCeilmM(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divFloor(b.getInf(), this.getNonZeroSup(c));
    }

    private long supCeilMm(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divFloor(b.getSup(), this.getNonZeroInf(c));
    }

    private long supCeilMM(IntDomainVar b, IntDomainVar c) {
        return MathUtils.divFloor(this.getNonZeroSup(b), c.getSup());
    }

    private long supCeilmN(IntDomainVar b) {
        return MathUtils.divFloor(b.getInf(), -1);
    }

    private long supCeilMP(IntDomainVar b) {
        return MathUtils.divFloor(b.getSup(), 1);
    }

    private long infFloorxx(IntDomainVar b, IntDomainVar c) {
        long s2;
        long s1 = b.getInf() * c.getSup();
        if (s1 < (s2 = (long)(b.getSup() * c.getInf()))) {
            return b.getInf() * c.getSup();
        }
        return b.getSup() * c.getInf();
    }

    private long supFloorEq(IntDomainVar b, IntDomainVar c) {
        if (b.getInf() * c.getInf() > b.getSup() * c.getSup()) {
            return b.getInf() * c.getInf();
        }
        return b.getSup() * c.getSup();
    }

    private long infCeilxx(IntDomainVar b) {
        return Math.min(MathUtils.divCeil(b.getInf(), 1), MathUtils.divCeil(b.getSup(), -1));
    }

    private long supCeilEq(IntDomainVar b) {
        return Math.max(MathUtils.divFloor(b.getInf(), -1), MathUtils.divFloor(b.getSup(), 1));
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public void propagate() throws ContradictionException {
        this.filter(0);
        this.filter(1);
        this.filter(2);
    }

    public void propagateZero() throws ContradictionException {
        if (!this.v1.canBeInstantiatedTo(0)) {
            this.v0.instantiate(0, this, false);
        }
        if (!this.v0.canBeInstantiatedTo(0)) {
            this.v1.instantiate(0, this, false);
        }
    }

    protected boolean updateX() throws ContradictionException {
        int r = (int)Math.max(this.getXminIfNonZero(), -2147483647L);
        boolean infChange = this.v0.updateInf(r, this, false);
        r = (int)Math.min(this.getXmaxIfNonZero(), 0x7FFFFFFEL);
        boolean supChange = this.v0.updateSup(r, this, false);
        return infChange || supChange;
    }

    protected boolean updateY() throws ContradictionException {
        int r = (int)Math.max(this.getYminIfNonZero(), -2147483647L);
        boolean infChange = this.v1.updateInf(r, this, false);
        r = (int)Math.min(this.getYmaxIfNonZero(), 0x7FFFFFFEL);
        boolean supChange = this.v1.updateSup(r, this, false);
        return infChange || supChange;
    }

    protected void updateXandY() throws ContradictionException {
        while (this.updateX() && this.updateY()) {
        }
    }

    protected void updateYandX() throws ContradictionException {
        while (this.updateY() && this.updateX()) {
        }
    }

    protected boolean shaveOnX() throws ContradictionException {
        int xmin = (int)Math.max(this.getXminIfNonZero(), -2147483647L);
        int xmax = (int)Math.min(this.getXmaxIfNonZero(), 0x7FFFFFFEL);
        if (xmin > this.v0.getSup() || xmax < this.v0.getInf()) {
            this.v2.instantiate(0, this, false);
            this.propagateZero();
            return false;
        }
        boolean infChange = !this.v1.canBeInstantiatedTo(0) && this.v0.updateInf(Math.min(0, xmin), this, false);
        boolean supChange = !this.v1.canBeInstantiatedTo(0) && this.v0.updateSup(Math.max(0, xmax), this, false);
        return infChange || supChange;
    }

    protected boolean shaveOnY() throws ContradictionException {
        int ymin = (int)Math.max(this.getYminIfNonZero(), -2147483647L);
        int ymax = (int)Math.min(this.getYmaxIfNonZero(), 0x7FFFFFFEL);
        if (ymin > this.v1.getSup() || ymax < this.v1.getInf()) {
            this.v2.instantiate(0, this, false);
            this.propagateZero();
            return false;
        }
        boolean infChange = !this.v0.canBeInstantiatedTo(0) && this.v1.updateInf(Math.min(0, ymin), this, false);
        boolean supChange = !this.v0.canBeInstantiatedTo(0) && this.v1.updateSup(Math.max(0, ymax), this, false);
        return infChange || supChange;
    }

    protected void shaveOnXandY() throws ContradictionException {
        while (this.shaveOnX() && this.shaveOnY()) {
        }
    }

    protected void shaveOnYandX() throws ContradictionException {
        while (this.shaveOnY() && this.shaveOnX()) {
        }
    }
}

