/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.AbstractPathElement;
import org.jgrapht.alg.AbstractPathElementList;
import org.jgrapht.alg.ConnectivityInspector;
import org.jgrapht.alg.RankingPathElement;
import org.jgrapht.graph.DirectedMaskSubgraph;
import org.jgrapht.graph.MaskFunctor;
import org.jgrapht.graph.UndirectedMaskSubgraph;

final class RankingPathElementList<V, E>
extends AbstractPathElementList<V, E, RankingPathElement<V, E>> {
    private V guardVertexToNotDisconnect = null;
    private Map<RankingPathElement<V, E>, Boolean> path2disconnect = new HashMap<RankingPathElement<V, E>, Boolean>();

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElement<V, E> pathElement) {
        super(graph, maxSize, pathElement);
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge) {
        this(graph, maxSize, elementList, edge, null);
        assert (!this.pathElements.isEmpty());
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, RankingPathElementList<V, E> elementList, E edge, V guardVertexToNotDisconnect) {
        super(graph, maxSize, elementList, edge);
        this.guardVertexToNotDisconnect = guardVertexToNotDisconnect;
        for (int i = 0; i < elementList.size() && this.size() < maxSize; ++i) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(i);
            if (this.isNotValidPath(prevPathElement, edge)) continue;
            double weight2 = this.calculatePathWeight(prevPathElement, edge);
            RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, weight2);
            this.pathElements.add(newPathElement);
        }
    }

    RankingPathElementList(Graph<V, E> graph, int maxSize, V vertex) {
        super(graph, maxSize, vertex);
    }

    public boolean addPathElements(RankingPathElementList<V, E> elementList, E edge) {
        assert (this.vertex.equals(Graphs.getOppositeVertex(this.graph, edge, elementList.getVertex())));
        boolean pathAdded = false;
        int yIndex = 0;
        for (int vIndex = 0; vIndex < elementList.size(); ++vIndex) {
            RankingPathElement prevPathElement = (RankingPathElement)elementList.get(vIndex);
            if (this.isNotValidPath(prevPathElement, edge)) continue;
            double newPathWeight = this.calculatePathWeight(prevPathElement, edge);
            RankingPathElement newPathElement = new RankingPathElement(this.graph, prevPathElement, edge, newPathWeight);
            RankingPathElement yPathElement = null;
            while (yIndex < this.size()) {
                yPathElement = (RankingPathElement)this.get(yIndex);
                if (newPathWeight < yPathElement.getWeight()) {
                    this.pathElements.add(yIndex, newPathElement);
                    pathAdded = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                if (newPathWeight == yPathElement.getWeight()) {
                    this.pathElements.add(yIndex + 1, newPathElement);
                    pathAdded = true;
                    if (this.size() <= this.maxSize) break;
                    this.pathElements.remove(this.maxSize);
                    break;
                }
                ++yIndex;
            }
            if (!(newPathWeight > yPathElement.getWeight())) continue;
            if (this.size() >= this.maxSize) break;
            this.pathElements.add(newPathElement);
            pathAdded = true;
        }
        return pathAdded;
    }

    List<RankingPathElement<V, E>> getPathElements() {
        return this.pathElements;
    }

    private double calculatePathWeight(RankingPathElement<V, E> pathElement, E edge) {
        double pathWeight = this.graph.getEdgeWeight(edge);
        if (pathElement.getPrevEdge() != null) {
            pathWeight += pathElement.getWeight();
        }
        return pathWeight;
    }

    private boolean isGuardVertexDisconnected(RankingPathElement<V, E> prevPathElement) {
        ConnectivityInspector<Object, E> connectivityInspector;
        PathMask<V, E> connectivityMask;
        if (this.guardVertexToNotDisconnect == null) {
            return false;
        }
        if (this.path2disconnect.containsKey(prevPathElement)) {
            return this.path2disconnect.get(prevPathElement);
        }
        if (this.graph instanceof DirectedGraph) {
            connectivityMask = new PathMask<V, E>(prevPathElement);
            DirectedMaskSubgraph<V, E> connectivityGraph = new DirectedMaskSubgraph<V, E>((DirectedGraph)this.graph, connectivityMask);
            connectivityInspector = new ConnectivityInspector<Object, E>(connectivityGraph);
        } else {
            connectivityMask = new PathMask<V, E>(prevPathElement);
            UndirectedMaskSubgraph<V, E> connectivityGraph = new UndirectedMaskSubgraph<V, E>((UndirectedGraph)this.graph, connectivityMask);
            connectivityInspector = new ConnectivityInspector<V, E>(connectivityGraph);
        }
        if (connectivityMask.isVertexMasked(this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(prevPathElement, true);
            return true;
        }
        if (!connectivityInspector.pathExists(this.vertex, this.guardVertexToNotDisconnect)) {
            this.path2disconnect.put(prevPathElement, true);
            return true;
        }
        this.path2disconnect.put(prevPathElement, false);
        return false;
    }

    private boolean isNotValidPath(RankingPathElement<V, E> prevPathElement, E edge) {
        return !this.isSimplePath(prevPathElement, edge) || this.isGuardVertexDisconnected(prevPathElement);
    }

    private boolean isSimplePath(RankingPathElement<V, E> prevPathElement, E edge) {
        Object endVertex = Graphs.getOppositeVertex(this.graph, edge, prevPathElement.getVertex());
        assert (endVertex.equals(this.vertex));
        AbstractPathElement pathElementToTest = prevPathElement;
        do {
            if (!pathElementToTest.getVertex().equals(endVertex)) continue;
            return false;
        } while ((pathElementToTest = pathElementToTest.getPrevPathElement()) != null);
        return true;
    }

    private static class PathMask<V, E>
    implements MaskFunctor<V, E> {
        private Set<E> maskedEdges = new HashSet();
        private Set<V> maskedVertices = new HashSet<V>();

        PathMask(RankingPathElement<V, E> pathElement) {
            while (pathElement.getPrevEdge() != null) {
                this.maskedEdges.add(pathElement.getPrevEdge());
                this.maskedVertices.add(pathElement.getVertex());
                pathElement = pathElement.getPrevPathElement();
            }
            this.maskedVertices.add(pathElement.getVertex());
        }

        @Override
        public boolean isEdgeMasked(E edge) {
            return this.maskedEdges.contains(edge);
        }

        @Override
        public boolean isVertexMasked(V vertex) {
            return this.maskedVertices.contains(vertex);
        }
    }
}

