/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.ParametricDistributionModel;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.UnivariateFunction;
import dr.math.distributions.NormalDistribution;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SkewNormalDistributionModel
extends AbstractModel
implements ParametricDistributionModel {
    public static final String SKEW_NORMAL_DISTRIBUTION_MODEL = "skewNormalDistributionModel";
    private final UnivariateFunction pdfFunction = new UnivariateFunction(){

        @Override
        public final double evaluate(double d) {
            return SkewNormalDistributionModel.this.pdf(d);
        }

        @Override
        public final double getLowerBound() {
            return Double.NEGATIVE_INFINITY;
        }

        @Override
        public final double getUpperBound() {
            return Double.POSITIVE_INFINITY;
        }
    };
    private final Variable<Double> location;
    private final Variable<Double> scale;
    private final Variable<Double> shape;

    public SkewNormalDistributionModel(Variable<Double> variable, Variable<Double> variable2, Variable<Double> variable3) {
        super(SKEW_NORMAL_DISTRIBUTION_MODEL);
        this.location = variable;
        this.scale = variable2;
        this.shape = variable3;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
        this.addVariable(variable2);
        variable2.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.addVariable(variable3);
        variable3.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 1));
    }

    private double shift(double d) {
        return (d - this.location.getValue(0)) / this.scale.getValue(0);
    }

    @Override
    public double pdf(double d) {
        double d2 = this.shift(d);
        return 2.0 / this.scale.getValue(0) * NormalDistribution.pdf(d2, 0.0, 1.0) * NormalDistribution.cdf(this.shape.getValue(0) * d2, 0.0, 1.0);
    }

    @Override
    public double logPdf(double d) {
        return Math.log(this.pdf(d));
    }

    @Override
    public double cdf(double d) {
        throw new IllegalArgumentException("Not yet implement");
    }

    @Override
    public double quantile(double d) {
        throw new IllegalArgumentException("Not yet implement");
    }

    @Override
    public double mean() {
        throw new IllegalArgumentException("Not yet implement");
    }

    @Override
    public double variance() {
        throw new IllegalArgumentException("Not yet implement");
    }

    @Override
    public final UnivariateFunction getProbabilityDensityFunction() {
        return this.pdfFunction;
    }

    @Override
    public void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Element createElement(Document document) {
        throw new RuntimeException("Not implemented!");
    }

    @Override
    public double logPdf(double[] dArray) {
        return this.logPdf(dArray[0]);
    }

    @Override
    public Variable<Double> getLocationVariable() {
        return this.location;
    }
}

