/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.SparseLongMatrix1D;
import cern.colt.matrix.tlong.impl.WrapperLongMatrix2D;

public class SparseRCMLongMatrix2D
extends WrapperLongMatrix2D {
    private static final long serialVersionUID = 1L;
    private SparseLongMatrix1D[] elements;

    public SparseRCMLongMatrix2D(int n, int n2) {
        block3: {
            super(null);
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block3;
                throw illegalArgumentException;
            }
        }
        this.elements = new SparseLongMatrix1D[n];
        for (int i = 0; i < n; ++i) {
            this.elements[i] = new SparseLongMatrix1D(n2);
        }
    }

    public SparseLongMatrix1D[] elements() {
        return this.elements;
    }

    public long getQuick(int n, int n2) {
        return this.elements[n].getQuick(n2);
    }

    public void setQuick(int n, int n2, long l) {
        this.elements[n].setQuick(n2, l);
    }

    public void trimToSize() {
        for (int i = 0; i < this.rows; ++i) {
            this.elements[i].trimToSize();
        }
    }

    public SparseLongMatrix1D viewRow(int n) {
        return this.elements[n];
    }

    protected LongMatrix2D getContent() {
        return this;
    }

    public LongMatrix2D like(int n, int n2) {
        return new SparseRCMLongMatrix2D(n, n2);
    }
}

