/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Random_Sets.FSS98;

class MatrixCalcs {
    protected static final double MINVALPRO = 1.0E-10;

    MatrixCalcs() {
    }

    protected static double ludcmp(double[][] a, int[] indx) throws SingularError {
        int j;
        double big;
        int i;
        int n = a[0].length;
        double[] vv = new double[n + 1];
        double d = 1.0;
        for (i = 1; i <= n; ++i) {
            big = 0.0;
            for (j = 1; j <= n; ++j) {
                double d2;
                double temp = Math.abs(a[j - 1][i - 1]);
                if (!(d2 > big)) continue;
                big = temp;
            }
            if (big == 0.0) {
                throw new SingularError("Singular Matrix in ludcmp");
            }
            vv[i - 1] = 1.0 / big;
        }
        for (j = 1; j <= n; ++j) {
            double dum;
            int k;
            double sum;
            for (i = 1; i < j; ++i) {
                sum = a[j - 1][i - 1];
                for (k = 1; k < i; ++k) {
                    sum -= a[k - 1][i - 1] * a[j - 1][k - 1];
                }
                a[j - 1][i - 1] = sum;
            }
            big = 0.0;
            int imax = -1;
            for (i = j; i <= n; ++i) {
                double d3;
                sum = a[j - 1][i - 1];
                for (k = 1; k < j; ++k) {
                    sum -= a[k - 1][i - 1] * a[j - 1][k - 1];
                }
                a[j - 1][i - 1] = sum;
                dum = vv[i - 1] * Math.abs(sum);
                if (!(d3 >= big)) continue;
                big = dum;
                imax = i;
            }
            if (j != imax) {
                for (k = 1; k <= n; ++k) {
                    dum = a[k - 1][imax - 1];
                    a[k - 1][imax - 1] = a[k - 1][j - 1];
                    a[k - 1][j - 1] = dum;
                }
                d = -d;
                vv[imax - 1] = vv[j - 1];
            }
            indx[j - 1] = imax;
            if (Math.abs(a[j - 1][j - 1]) < 1.0E-10) {
                throw new SingularError("Singula Matrix in ludcmp");
            }
            if (j == n) continue;
            dum = 1.0 / a[j - 1][j - 1];
            for (i = j + 1; i <= n; ++i) {
                double[] dArray = a[j - 1];
                int n2 = i - 1;
                dArray[n2] = dArray[n2] * dum;
            }
        }
        return d;
    }

    protected static void lubksb(double[][] A, int[] indx, double[] b) {
        int j;
        double sum;
        int i;
        int ii = 0;
        int n = A.length;
        for (i = 1; i <= n; ++i) {
            int ip = indx[i - 1];
            sum = b[ip - 1];
            b[ip - 1] = b[i - 1];
            if (ii != 0) {
                for (j = ii; j <= i - 1; ++j) {
                    sum -= A[j - 1][i - 1] * b[j - 1];
                }
            } else if (sum != 0.0) {
                ii = i;
            }
            b[i - 1] = sum;
        }
        for (i = n; i >= 1; --i) {
            sum = b[i - 1];
            for (j = i + 1; j <= n; ++j) {
                sum -= A[j - 1][i - 1] * b[j - 1];
            }
            b[i - 1] = sum / A[i - 1][i - 1];
        }
    }

    private static void copy(double[][] A, double[][] vA) {
        for (int i = 0; i < vA.length; ++i) {
            for (int j = 0; j < vA[i].length; ++j) {
                A[i][j] = vA[i][j];
            }
        }
    }

    private static void rotate(double[][] a, int i, int j, int k, int l, double s, double tau) {
        double g = a[i - 1][j - 1];
        double h = a[k - 1][l - 1];
        a[i - 1][j - 1] = g - s * (h + g * tau);
        a[k - 1][l - 1] = h + s * (g - h * tau);
    }

    protected static void jacobi(double[][] a, double[] d, double[][] v) {
        int iq;
        int ip;
        int n = a[0].length;
        double[] b = new double[n];
        double[] z = new double[n];
        for (ip = 1; ip <= n; ++ip) {
            for (iq = 1; iq <= n; ++iq) {
                v[ip - 1][iq - 1] = 0.0;
            }
            v[ip - 1][ip - 1] = 1.0;
        }
        for (ip = 1; ip <= n; ++ip) {
            double d2 = a[ip - 1][ip - 1];
            d[ip - 1] = d2;
            b[ip - 1] = d2;
            z[ip - 1] = 0.0;
        }
        int nrot = 0;
        for (int i = 1; i <= 50; ++i) {
            double sm = 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    sm += Math.abs(a[ip - 1][iq - 1]);
                }
            }
            if (sm == 0.0) {
                return;
            }
            double tresh = i < 4 ? 0.2 * sm / (double)(n * n) : 0.0;
            for (ip = 1; ip <= n - 1; ++ip) {
                for (iq = ip + 1; iq <= n; ++iq) {
                    int j;
                    double t;
                    double g = 100.0 * Math.abs(a[ip - 1][iq - 1]);
                    if (i > 4 && Math.abs(d[ip - 1]) + g == Math.abs(d[ip - 1]) && Math.abs(d[iq - 1]) + g == Math.abs(d[iq - 1])) {
                        a[ip - 1][iq - 1] = 0.0;
                        continue;
                    }
                    if (!(Math.abs(a[ip - 1][iq - 1]) > tresh)) continue;
                    double h = d[iq - 1] - d[ip - 1];
                    if (Math.abs(h) + g == Math.abs(h)) {
                        t = a[ip - 1][iq - 1] / h;
                    } else {
                        double theta = 0.5 * h / a[ip - 1][iq - 1];
                        t = 1.0 / (Math.abs(theta) + Math.sqrt(1.0 + theta * theta));
                        if (theta < 0.0) {
                            t = -t;
                        }
                    }
                    double c = 1.0 / Math.sqrt(1.0 + t * t);
                    double s = t * c;
                    double tau = s / (1.0 + c);
                    h = t * a[ip - 1][iq - 1];
                    int n2 = ip - 1;
                    z[n2] = z[n2] - h;
                    int n3 = iq - 1;
                    z[n3] = z[n3] + h;
                    int n4 = ip - 1;
                    d[n4] = d[n4] - h;
                    int n5 = iq - 1;
                    d[n5] = d[n5] + h;
                    a[ip - 1][iq - 1] = 0.0;
                    for (j = 1; j <= ip - 1; ++j) {
                        MatrixCalcs.rotate(a, j, ip, j, iq, s, tau);
                    }
                    for (j = ip + 1; j <= iq - 1; ++j) {
                        MatrixCalcs.rotate(a, ip, j, j, iq, s, tau);
                    }
                    for (j = iq + 1; j <= n; ++j) {
                        MatrixCalcs.rotate(a, ip, j, iq, j, s, tau);
                    }
                    for (j = 1; j <= n; ++j) {
                        MatrixCalcs.rotate(v, j, ip, j, iq, s, tau);
                    }
                    ++nrot;
                }
            }
            for (ip = 1; ip <= n; ++ip) {
                int n6 = ip - 1;
                b[n6] = b[n6] + z[ip - 1];
                d[ip - 1] = b[ip - 1];
                z[ip - 1] = 0.0;
            }
        }
        System.out.println("Demasiadas iteraciones en rutina jacobi");
    }

    public static double[][] oneRowMatrix(double[] A) {
        double[][] R = new double[1][A.length];
        R[0] = A;
        return R;
    }

    public static double[][] oneColumnMatrix(double[] A) {
        return MatrixCalcs.tr(MatrixCalcs.oneRowMatrix(A));
    }

    public static double[][] matSum(double[][] A, double[][] B) throws DimensionError {
        if (A.length != B.length || A[0].length != B[0].length) {
            throw new DimensionError("A=" + A.length + " " + A[0].length + " B=" + B.length + " " + B[0].length);
        }
        double[][] C = new double[A.length][A[0].length];
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] + B[i][j];
            }
        }
        return C;
    }

    public static double[][] matDif(double[][] A, double[][] B) throws DimensionError {
        if (A.length != B.length || A[0].length != B[0].length) {
            throw new DimensionError("A=" + A.length + " " + A[0].length + " B=" + B.length + " " + B[0].length);
        }
        double[][] C = new double[A.length][A[0].length];
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] - B[i][j];
            }
        }
        return C;
    }

    public static double[][] matMul(double[][] A, double k) {
        double[][] C = new double[A.length][A[0].length];
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = A[i][j] * k;
            }
        }
        return C;
    }

    public static double[][] matMul(double[][] A, double[][] B) throws DimensionError {
        if (A[0].length != B.length) {
            throw new DimensionError("A=" + A.length + " " + A[0].length + " B=" + B.length + " " + B[0].length);
        }
        double[][] C = new double[A.length][B[0].length];
        for (int i = 0; i < C.length; ++i) {
            for (int j = 0; j < C[i].length; ++j) {
                C[i][j] = 0.0;
                for (int k = 0; k < A[0].length; ++k) {
                    double[] dArray = C[i];
                    int n = j;
                    dArray[n] = dArray[n] + A[i][k] * B[k][j];
                }
            }
        }
        return C;
    }

    public static double[][] tr(double[][] A) {
        double[][] R = new double[A[0].length][A.length];
        for (int i = 0; i < R.length; ++i) {
            for (int j = 0; j < R[i].length; ++j) {
                R[i][j] = A[j][i];
            }
        }
        return R;
    }

    public static double determinant(double[][] vA) throws SingularError {
        int N = vA.length;
        double[][] A = new double[N][N];
        MatrixCalcs.copy(A, vA);
        double[][] Y = new double[N][N];
        int[] indx = new int[N];
        double[] col = new double[N];
        double d = MatrixCalcs.ludcmp(A, indx);
        for (int j = 0; j < N; ++j) {
            d *= A[j][j];
        }
        return d;
    }

    public static double[][] inv(double[][] vA) throws SingularError {
        int N = vA.length;
        double[][] A = new double[N][N];
        MatrixCalcs.copy(A, vA);
        double[][] Y = new double[N][N];
        int[] indx = new int[N];
        double[] col = new double[N];
        double d = MatrixCalcs.ludcmp(A, indx);
        for (int j = 0; j < N; ++j) {
            int i;
            for (i = 0; i < N; ++i) {
                col[i] = 0.0;
            }
            col[j] = 1.0;
            MatrixCalcs.lubksb(A, indx, col);
            for (i = 0; i < N; ++i) {
                Y[j][i] = col[i];
            }
        }
        return Y;
    }

    public static boolean protectedInverse(double[][] A) {
        int N = A[0].length;
        int[] indx = new int[N];
        double[][] Y = new double[N][N];
        double[] col = new double[N];
        try {
            double d = MatrixCalcs.ludcmp(A, indx);
        }
        catch (SingularError e) {
            return true;
        }
        for (int j = 0; j < N; ++j) {
            int i;
            for (i = 0; i < N; ++i) {
                col[i] = 0.0;
            }
            col[j] = 1.0;
            MatrixCalcs.lubksb(A, indx, col);
            for (i = 0; i < N; ++i) {
                Y[j][i] = col[i];
            }
        }
        MatrixCalcs.copy(A, Y);
        return false;
    }

    public static double[][] I(int n) {
        double[][] result = new double[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i == j) {
                    result[i][i] = 1.0;
                    continue;
                }
                result[i][j] = 0.0;
            }
        }
        return result;
    }

    public static void getEigenValues(double[][] A, double[][] P, double[][] D) {
        double[] d = new double[A[0].length];
        MatrixCalcs.jacobi(A, d, P);
        for (int i = 0; i < D.length; ++i) {
            for (int j = 0; j < D[i].length; ++j) {
                if (i == j) {
                    D[i][i] = d[i];
                    continue;
                }
                D[i][j] = 0.0;
            }
        }
    }

    public static double dot(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    protected static void matprn(double[][] B) {
        for (int i = 0; i < B.length; ++i) {
            for (int j = 0; j < B[i].length; ++j) {
                System.out.print(B[i][j] + " ");
            }
            System.out.println();
        }
    }

    public static void main(String[] argv) {
        try {
            double[] A = new double[]{1.0, 2.0, 3.0};
            double[][] B = MatrixCalcs.oneRowMatrix(A);
            double[][] C = MatrixCalcs.matMul(MatrixCalcs.tr(B), B);
            C[0][0] = 7.0;
            C[1][1] = 13.0;
            C[2][2] = 19.0;
            MatrixCalcs.matprn(C);
            double[][] D = new double[C.length][C.length];
            MatrixCalcs.copy(D, C);
            boolean b = MatrixCalcs.protectedInverse(D);
            if (b) {
                System.out.println("La matriz era singular");
            }
            MatrixCalcs.matprn(D);
            double[][] E = MatrixCalcs.matMul(D, C);
            MatrixCalcs.matprn(E);
            D = MatrixCalcs.inv(C);
            E = MatrixCalcs.matMul(D, C);
            MatrixCalcs.matprn(E);
            double[][] P = new double[C.length][C.length];
            double[][] Diag = new double[C.length][C.length];
            MatrixCalcs.getEigenValues(C, P, Diag);
            MatrixCalcs.matprn(C);
            MatrixCalcs.matprn(P);
            MatrixCalcs.matprn(Diag);
            D = MatrixCalcs.matMul(MatrixCalcs.matMul(P, Diag), MatrixCalcs.tr(P));
            MatrixCalcs.matprn(D);
        }
        catch (DimensionError e) {
            System.err.println(e);
        }
        catch (SingularError e) {
            System.err.println(e);
        }
    }

    public static class DimensionError
    extends Exception {
        DimensionError(String reason) {
            super(reason);
        }

        @Override
        public String toString() {
            return "Matrixes dimensions do not match: " + this.getMessage();
        }
    }

    public static class SingularError
    extends Exception {
        SingularError(String reason) {
            super(reason);
        }

        @Override
        public String toString() {
            return "Singular Matrix: " + this.getMessage();
        }
    }
}

