/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.UpdateEdge;
import org.af.gMCP.gui.graph.UpdateNode;

public class NetListPopUpMenu
extends JPopupMenu
implements ActionListener {
    JMenuItem anItem;
    NetList nl;
    Node node;
    Edge edge;

    public NetListPopUpMenu(NetList nl, Node node, Edge edge) {
        this.nl = nl;
        this.node = node;
        this.edge = edge;
        this.add(this.makeMenuItem("Properties", "properties", !nl.isTesting()));
        this.add(this.makeMenuItem("Delete", "delete", !nl.isTesting()));
        if (node != null) {
            this.addSeparator();
            this.add(this.makeMenuItem("Reject", "reject", nl.isTesting() && node.isRejectable()));
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("properties")) {
            if (this.node != null) {
                new UpdateNode(this.node, this.nl.control);
            }
            if (this.edge != null) {
                new UpdateEdge(this.edge, this.nl, this.nl.control);
            }
        } else if (e.getActionCommand().equals("delete")) {
            if (this.node != null) {
                this.nl.removeNode(this.node);
            }
            if (this.edge != null) {
                this.nl.removeEdge(this.edge);
            }
        } else if (e.getActionCommand().equals("reject")) {
            this.node.reject();
        }
        this.nl.repaint();
    }
}

