/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.types;

import cc.mallet.types.Alphabet;
import cc.mallet.types.AugmentableFeatureVector;
import cc.mallet.types.ConstantMatrix;
import cc.mallet.types.DenseVector;
import cc.mallet.types.IndexedSparseVector;
import cc.mallet.types.MatrixOps;
import cc.mallet.types.Vector;
import cc.mallet.util.PropertyList;
import com.google.errorprone.annotations.Var;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;

public class SparseVector
implements ConstantMatrix,
Vector,
Serializable {
    protected int[] indices;
    protected double[] values;
    protected boolean hasInfinite;
    private static final long serialVersionUID = 2L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public SparseVector(int[] indices, double[] values, @Var int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        int length = size;
        if (capacity < length) {
            capacity = length;
        }
        assert (size <= length);
        if (values != null && indices != null && indices.length != values.length) {
            throw new IllegalArgumentException("Attempt to create sparse non-binary SparseVector with mismatching values & indices\n  indices.length = " + indices.length + "   values.length = " + values.length);
        }
        if (copy || capacity > length) {
            if (indices == null) {
                this.indices = null;
            } else {
                this.indices = new int[capacity];
                System.arraycopy(indices, 0, this.indices, 0, length);
            }
            if (values == null) {
                this.values = null;
            } else {
                this.values = new double[capacity];
                System.arraycopy(values, 0, this.values, 0, length);
            }
        } else {
            this.indices = indices;
            this.values = values;
        }
        if (checkIndicesSorted) {
            this.sortIndices();
        } else if (removeDuplicates) {
            this.removeDuplicates(0);
        }
    }

    public SparseVector(double[] values, boolean copy) {
        this(null, values, values.length, values.length, copy, false, false);
    }

    public SparseVector(double[] values) {
        this(values, true);
    }

    public SparseVector(int size, double fillValue) {
        this(SparseVector.newArrayOfValue(size, fillValue), false);
    }

    public SparseVector(int[] indices, double[] values, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        this(indices, values, indices != null ? indices.length : values.length, indices != null ? indices.length : values.length, copy, checkIndicesSorted, removeDuplicates);
    }

    public SparseVector(int[] indices, double[] values) {
        this(indices, values, true, true, true);
    }

    public SparseVector(int[] indices, double[] values, boolean copy) {
        this(indices, values, copy, true, true);
    }

    public SparseVector(int[] indices, double[] values, boolean copy, boolean checkIndicesSorted) {
        this(indices, values, copy, checkIndicesSorted, true);
    }

    public SparseVector(int[] indices, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates, boolean binary) {
        this(indices, binary ? null : SparseVector.newArrayOfValue(indices.length, 1.0), indices.length, indices.length, copy, checkIndicesSorted, removeDuplicates);
    }

    public SparseVector(int[] indices, int capacity, int size, boolean copy, boolean checkIndicesSorted, boolean removeDuplicates) {
        this(indices, null, capacity, size, copy, checkIndicesSorted, removeDuplicates);
    }

    public SparseVector(int[] indices, boolean copy, boolean checkIndicesSorted) {
        this(indices, null, copy, checkIndicesSorted, true);
    }

    public SparseVector(int[] indices, boolean copy) {
        this(indices, null, copy, true, true);
    }

    public SparseVector(int[] indices) {
        this(indices, null, true, true, true);
    }

    public SparseVector() {
        this(new int[0], new double[0], false, false);
    }

    public SparseVector(Alphabet dict, PropertyList pl, @Var boolean binary, boolean growAlphabet) {
        if (pl == null) {
            this.indices = new int[0];
            this.values = null;
            return;
        }
        if (!binary) {
            binary = true;
            PropertyList.Iterator iter = pl.numericIterator();
            while (iter.hasNext()) {
                iter.nextProperty();
                if (iter.getNumericValue() == 1.0) continue;
                binary = false;
                break;
            }
        }
        AugmentableFeatureVector afv = new AugmentableFeatureVector(dict, binary);
        PropertyList.Iterator iter = pl.numericIterator();
        while (iter.hasNext()) {
            iter.nextProperty();
            int index = dict.lookupIndex(iter.getKey(), growAlphabet);
            if (index < 0) continue;
            afv.add(index, iter.getNumericValue());
        }
        SparseVector sv = afv.toSparseVector();
        this.indices = sv.indices;
        this.values = sv.values;
    }

    public SparseVector(Alphabet dict, PropertyList pl, boolean binary) {
        this(dict, pl, binary, true);
    }

    private static double[] newArrayOfValue(int length, double value) {
        double[] ret = new double[length];
        Arrays.fill(ret, value);
        return ret;
    }

    public boolean isBinary() {
        return this.values == null;
    }

    public void makeBinary() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void makeNonBinary() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public int getNumDimensions() {
        return 1;
    }

    @Override
    public int getDimensions(int[] sizes) {
        sizes[0] = this.indices == null ? this.values.length : this.indices[this.indices.length - 1];
        return 1;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public double[] getValues() {
        return this.values;
    }

    @Override
    public int numLocations() {
        return this.values == null ? (this.indices == null ? 0 : this.indices.length) : this.values.length;
    }

    @Override
    public int location(int index) {
        if (this.indices == null) {
            return index;
        }
        return Arrays.binarySearch(this.indices, index);
    }

    @Override
    public double valueAtLocation(int location) {
        return this.values == null ? 1.0 : this.values[location];
    }

    @Override
    public int indexAtLocation(int location) {
        return this.indices == null ? location : this.indices[location];
    }

    @Override
    public double value(int[] indices) {
        assert (indices.length == 1);
        if (indices == null) {
            return this.values[this.indices[0]];
        }
        return this.values[this.location(indices[0])];
    }

    @Override
    public double value(int index) {
        if (this.indices == null) {
            try {
                return this.values[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return 0.0;
            }
        }
        int loc = this.location(index);
        if (loc < 0) {
            return 0.0;
        }
        if (this.values == null) {
            return 1.0;
        }
        return this.values[loc];
    }

    public void addTo(double[] accumulator, double scale) {
        if (this.indices == null) {
            for (int i = 0; i < this.values.length; ++i) {
                int n = i;
                accumulator[n] = accumulator[n] + this.values[i] * scale;
            }
        } else if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + scale;
            }
        } else {
            for (int i = 0; i < this.indices.length; ++i) {
                int n = this.indices[i];
                accumulator[n] = accumulator[n] + this.values[i] * scale;
            }
        }
    }

    public void addTo(double[] accumulator) {
        this.addTo(accumulator, 1.0);
    }

    @Override
    public int singleIndex(int[] indices) {
        assert (indices.length == 1);
        return indices[0];
    }

    @Override
    public void singleToIndices(int i, int[] indices) {
        indices[0] = i;
    }

    @Override
    public double singleValue(int i) {
        return this.value(i);
    }

    @Override
    public int singleSize() {
        if (this.indices == null) {
            return this.values.length;
        }
        if (this.indices.length == 0) {
            return 0;
        }
        return this.indices[this.indices.length - 1];
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean onOneLine) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.values.length; ++i) {
            sb.append(this.indices == null ? i : this.indices[i]);
            sb.append("=");
            sb.append(this.values[i]);
            if (!onOneLine) {
                sb.append("\n");
                continue;
            }
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public ConstantMatrix cloneMatrix() {
        if (this.indices == null) {
            return new SparseVector(this.values);
        }
        return new SparseVector(this.indices, this.values, true, false, false);
    }

    public ConstantMatrix cloneMatrixZeroed() {
        if (this.indices == null) {
            return new SparseVector(new double[this.values.length]);
        }
        int[] newIndices = new int[this.indices.length];
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        return new SparseVector(newIndices, new double[this.values.length], true, false, false);
    }

    public void plusEqualsSparse(SparseVector v) {
        this.plusEqualsSparse(v, 1.0);
    }

    public void plusEqualsSparse(SparseVector v, double factor) {
        if (this.indices == null) {
            this.densePlusEqualsSparse(v, factor);
            return;
        }
        int loc1 = 0;
        int loc2 = 0;
        int numLocations1 = this.numLocations();
        int numLocations2 = v.numLocations();
        while (loc1 < numLocations1 && loc2 < numLocations2) {
            int idx2;
            int idx1 = this.indexAtLocation(loc1);
            if (idx1 == (idx2 = v.indexAtLocation(loc2))) {
                int n = loc1++;
                this.values[n] = this.values[n] + v.valueAtLocation(loc2) * factor;
                ++loc2;
                continue;
            }
            if (idx1 < idx2) {
                ++loc1;
                continue;
            }
            ++loc2;
        }
    }

    public void timesEqualsSparse(SparseVector v) {
        this.timesEqualsSparse(v, 1.0);
    }

    public void timesEqualsSparse(SparseVector v, double factor) {
        if (this.indices == null) {
            this.denseTimesEqualsSparse(v, factor);
            return;
        }
        int loc1 = 0;
        int loc2 = 0;
        while (loc1 < this.numLocations() && loc2 < v.numLocations()) {
            int idx2;
            int idx1 = this.indexAtLocation(loc1);
            if (idx1 == (idx2 = v.indexAtLocation(loc2))) {
                int n = loc1++;
                this.values[n] = this.values[n] * (v.valueAtLocation(loc2) * factor);
                ++loc2;
                continue;
            }
            if (idx1 < idx2) {
                ++loc1;
                continue;
            }
            ++loc2;
        }
    }

    public void timesEqualsSparseZero(SparseVector v, double factor) {
        if (this.indices == null) {
            this.denseTimesEqualsSparse(v, factor);
            return;
        }
        int loc1 = 0;
        int loc2 = 0;
        while (loc1 < this.numLocations() && loc2 < v.numLocations()) {
            int idx2;
            int idx1 = this.indexAtLocation(loc1);
            if (idx1 == (idx2 = v.indexAtLocation(loc2))) {
                int n = loc1++;
                this.values[n] = this.values[n] * (v.valueAtLocation(loc2) * factor);
                ++loc2;
                continue;
            }
            if (idx1 < idx2) {
                this.values[loc1] = 0.0;
                ++loc1;
                continue;
            }
            ++loc2;
        }
    }

    public void timesEquals(double factor) {
        int i = 0;
        while (i < this.values.length) {
            int n = i++;
            this.values[n] = this.values[n] * factor;
        }
    }

    private void densePlusEqualsSparse(SparseVector v, double factor) {
        int idx;
        int maxloc = v.numLocations();
        for (int loc = 0; loc < maxloc && (idx = v.indexAtLocation(loc)) < this.values.length; ++loc) {
            int n = idx;
            this.values[n] = this.values[n] + v.valueAtLocation(loc) * factor;
        }
    }

    private void denseTimesEqualsSparse(SparseVector v, double factor) {
        int idx;
        int maxloc = v.numLocations();
        for (int loc = 0; loc < maxloc && (idx = v.indexAtLocation(loc)) < this.values.length; ++loc) {
            int n = idx;
            this.values[n] = this.values[n] * (v.valueAtLocation(loc) * factor);
        }
    }

    public void incrementValue(int index, double value) throws IllegalArgumentException {
        int loc = this.location(index);
        if (loc < 0) {
            throw new IllegalArgumentException("Trying to set value that isn't present in SparseVector");
        }
        int n = loc;
        this.values[n] = this.values[n] + value;
    }

    public void setAll(double v) {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = v;
        }
    }

    public void setValue(int index, double value) throws IllegalArgumentException {
        if (this.indices == null) {
            this.values[index] = value;
        } else {
            int loc = this.location(index);
            if (loc < 0) {
                throw new IllegalArgumentException("Can't insert values into a sparse Vector.");
            }
            this.values[loc] = value;
        }
    }

    public void setValueAtLocation(int location, double value) {
        this.values[location] = value;
    }

    public final void arrayCopyFrom(double[] a) {
        this.arrayCopyFrom(a, 0);
    }

    public final int arrayCopyFrom(double[] a, int startingArrayLocation) {
        System.arraycopy(a, startingArrayLocation, this.values, 0, this.values.length);
        return startingArrayLocation + this.values.length;
    }

    public final void map(Method f) throws IllegalAccessException, Throwable {
        if (this.values == null) {
            throw new UnsupportedOperationException("Binary values may not be altered via map");
        }
        if (f.getParameterTypes().length != 1 || f.getParameterTypes()[0] != Double.class || f.getReturnType() != Double.class) {
            throw new IllegalArgumentException("Method signature must be \"Double f (Double x)\"");
        }
        try {
            for (int i = 0; i < this.values.length; ++i) {
                Object[] args = new Object[]{this.values[i]};
                this.values[i] = (Double)f.invoke(null, args);
            }
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public final int arrayCopyInto(double[] array, int startingArrayLocation) {
        System.arraycopy(this.values, 0, array, startingArrayLocation, this.values.length);
        return startingArrayLocation + this.values.length;
    }

    public double dotProduct(double[] v) {
        double ret = 0.0;
        if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += v[this.indices[i]];
            }
        } else {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += this.values[i] * v[this.indices[i]];
            }
        }
        return ret;
    }

    @Override
    public double dotProduct(ConstantMatrix m) {
        if (m instanceof SparseVector) {
            return this.dotProduct((SparseVector)m);
        }
        if (m instanceof DenseVector) {
            return this.dotProduct((DenseVector)m);
        }
        throw new IllegalArgumentException("Unrecognized Matrix type " + m.getClass());
    }

    public double dotProduct(DenseVector v) {
        if (v.hasInfinite || this.hasInfinite) {
            return this.extendedDotProduct(v);
        }
        double ret = 0.0;
        if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += v.value(this.indices[i]);
            }
        } else {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += this.values[i] * v.value(this.indices[i]);
            }
        }
        if (Double.isNaN(ret)) {
            return this.extendedDotProduct(v);
        }
        return ret;
    }

    public double extendedDotProduct(DenseVector v) {
        double ret = 0.0;
        if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                ret += v.value(this.indices[i]);
            }
        } else {
            for (int i = 0; i < this.indices.length; ++i) {
                if (Double.isInfinite(this.values[i]) && v.value(this.indices[i]) == 0.0) {
                    this.hasInfinite = true;
                    continue;
                }
                if (Double.isInfinite(v.value(this.indices[i])) && this.values[i] == 0.0) {
                    v.hasInfinite = true;
                    continue;
                }
                ret += this.values[i] * v.value(this.indices[i]);
            }
        }
        return ret;
    }

    public double dotProduct(SparseVector v) {
        if (v.hasInfinite || this.hasInfinite) {
            return this.extendedDotProduct(v);
        }
        double ret = v instanceof IndexedSparseVector ? v.dotProduct(this) : (this.numLocations() > v.numLocations() ? this.dotProductInternal(v, this) : this.dotProductInternal(this, v));
        if (Double.isNaN(ret)) {
            return this.extendedDotProduct(v);
        }
        return ret;
    }

    private double dotProductInternal(SparseVector vShort, SparseVector vLong) {
        double ret = 0.0;
        int numShortLocs = vShort.numLocations();
        if (vShort.isBinary()) {
            for (int i = 0; i < numShortLocs; ++i) {
                ret += vLong.value(vShort.indexAtLocation(i));
            }
        } else {
            for (int i = 0; i < numShortLocs; ++i) {
                double v1 = vShort.valueAtLocation(i);
                double v2 = vLong.value(vShort.indexAtLocation(i));
                ret += v1 * v2;
            }
        }
        return ret;
    }

    public double extendedDotProduct(SparseVector v) {
        double ret = 0.0;
        SparseVector vShort = null;
        SparseVector vLong = null;
        if (this.numLocations() > v.numLocations()) {
            vShort = v;
            vLong = this;
        } else {
            vShort = this;
            vLong = v;
        }
        for (int i = 0; i < vShort.numLocations(); ++i) {
            double v1 = vShort.valueAtLocation(i);
            double v2 = vLong.value(vShort.indexAtLocation(i));
            if (Double.isInfinite(v1) && v2 == 0.0) {
                vShort.hasInfinite = true;
                continue;
            }
            if (Double.isInfinite(v2) && v1 == 0.0) {
                vLong.hasInfinite = true;
                continue;
            }
            ret += v1 * v2;
        }
        return ret;
    }

    public SparseVector vectorAdd(SparseVector v, double scale) {
        if (this.indices != null) {
            int i;
            int[] ind = v.getIndices();
            double[] val = v.getValues();
            int[] newIndices = new int[ind.length + this.indices.length];
            double[] newVals = new double[ind.length + this.indices.length];
            for (i = 0; i < this.indices.length; ++i) {
                newIndices[i] = this.indices[i];
                newVals[i] = this.values[i];
            }
            for (i = 0; i < ind.length; ++i) {
                newIndices[i + this.indices.length] = ind[i];
                newVals[i + this.indices.length] = scale * val[i];
            }
            return new SparseVector(newIndices, newVals, true, true, false);
        }
        int[] newIndices = new int[this.values.length];
        double[] newVals = new double[this.values.length];
        int curPos = 0;
        for (int i = 0; i < this.values.length; ++i) {
            double val = this.values[i] + scale * v.value(i);
            if (val == 0.0) continue;
            newIndices[curPos] = i;
            newVals[curPos++] = val;
        }
        return new SparseVector(newIndices, newVals, true, true, false);
    }

    @Override
    public double oneNorm() {
        double ret = 0.0;
        if (this.values == null) {
            return this.indices.length;
        }
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i];
        }
        return ret;
    }

    @Override
    public double absNorm() {
        double ret = 0.0;
        if (this.values == null) {
            return this.indices.length;
        }
        for (int i = 0; i < this.values.length; ++i) {
            ret += Math.abs(this.values[i]);
        }
        return ret;
    }

    @Override
    public double twoNorm() {
        double ret = 0.0;
        if (this.values == null) {
            return Math.sqrt(this.indices.length);
        }
        for (int i = 0; i < this.values.length; ++i) {
            ret += this.values[i] * this.values[i];
        }
        return Math.sqrt(ret);
    }

    @Override
    public double infinityNorm() {
        if (this.values == null) {
            return 1.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.values.length; ++i) {
            if (!(Math.abs(this.values[i]) > max)) continue;
            max = Math.abs(this.values[i]);
        }
        return max;
    }

    @Override
    public void print() {
        if (this.values == null) {
            for (int i = 0; i < this.indices.length; ++i) {
                System.out.println("SparseVector[" + this.indices[i] + "] = 1.0");
            }
        } else {
            for (int i = 0; i < this.values.length; ++i) {
                int idx = this.indices == null ? i : this.indices[i];
                System.out.println("SparseVector[" + idx + "] = " + this.values[i]);
            }
        }
    }

    @Override
    public boolean isNaN() {
        if (this.values == null) {
            return false;
        }
        return MatrixOps.isNaN(this.values);
    }

    public boolean isInfinite() {
        if (this.values == null) {
            return false;
        }
        return MatrixOps.isInfinite(this.values);
    }

    public boolean isNaNOrInfinite() {
        if (this.values == null) {
            return false;
        }
        return MatrixOps.isNaNOrInfinite(this.values);
    }

    protected void sortIndices() {
        if (this.indices == null) {
            return;
        }
        if (this.values == null) {
            Arrays.sort(this.indices);
        } else {
            for (int i = this.indices.length - 1; i >= 0; --i) {
                boolean swapped = false;
                for (int j = 0; j < i; ++j) {
                    if (this.indices[j] <= this.indices[j + 1]) continue;
                    int f = this.indices[j];
                    this.indices[j] = this.indices[j + 1];
                    this.indices[j + 1] = f;
                    if (this.values != null) {
                        double v = this.values[j];
                        this.values[j] = this.values[j + 1];
                        this.values[j + 1] = v;
                    }
                    swapped = true;
                }
                if (!swapped) break;
            }
        }
        int numDuplicates = 0;
        for (int i = 1; i < this.indices.length; ++i) {
            if (this.indices[i - 1] != this.indices[i]) continue;
            ++numDuplicates;
        }
        if (numDuplicates > 0) {
            this.removeDuplicates(numDuplicates);
        }
    }

    protected void removeDuplicates(@Var int numDuplicates) {
        if (numDuplicates == 0) {
            for (int i = 1; i < this.indices.length; ++i) {
                if (this.indices[i - 1] != this.indices[i]) continue;
                ++numDuplicates;
            }
        }
        if (numDuplicates == 0) {
            return;
        }
        int[] newIndices = new int[this.indices.length - numDuplicates];
        double[] newValues = this.values == null ? null : new double[this.indices.length - numDuplicates];
        newIndices[0] = this.indices[0];
        if (this.values != null) {
            newValues[0] = this.values[0];
        }
        int j = 1;
        for (int i = 1; i < this.indices.length; ++i) {
            if (this.indices[i] == this.indices[i - 1]) {
                if (newValues == null) continue;
                int n = j - 1;
                newValues[n] = newValues[n] + this.values[i];
                continue;
            }
            newIndices[j] = this.indices[i];
            if (this.values != null) {
                newValues[j] = this.values[i];
            }
            ++j;
        }
        this.indices = newIndices;
        this.values = newValues;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int i;
        if (this instanceof AugmentableFeatureVector) {
            ((AugmentableFeatureVector)this).sortIndices();
        }
        out.writeInt(1);
        out.writeInt(this.indices == null ? -1 : this.indices.length);
        out.writeInt(this.values == null ? -1 : this.values.length);
        if (this.indices != null) {
            for (i = 0; i < this.indices.length; ++i) {
                out.writeInt(this.indices[i]);
            }
        }
        if (this.values != null) {
            for (i = 0; i < this.values.length; ++i) {
                out.writeDouble(this.values[i]);
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int i;
        int version = in.readInt();
        int indicesSize = in.readInt();
        int valuesSize = in.readInt();
        this.hasInfinite = false;
        if (indicesSize >= 0) {
            this.indices = new int[indicesSize];
            for (i = 0; i < indicesSize; ++i) {
                this.indices[i] = in.readInt();
            }
        }
        if (valuesSize >= 0) {
            this.values = new double[valuesSize];
            for (i = 0; i < valuesSize; ++i) {
                this.values[i] = in.readDouble();
                if (!Double.isInfinite(this.values[i])) continue;
                this.hasInfinite = true;
            }
        }
    }
}

