/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global;

import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.memory.IEnvironment;
import choco.kernel.memory.IStateInt;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class Occurrence
extends AbstractLargeIntSConstraint {
    public IStateInt nbPossible;
    public IStateInt nbSure;
    public boolean constrainOnInfNumber = false;
    public boolean constrainOnSupNumber = false;
    public IntDomainVar[] relevantVar;
    public int nbListVars;
    private int occval;

    public Occurrence(IntDomainVar[] vars, int occval, boolean onInf, boolean onSup, IEnvironment environment) {
        super(ConstraintEvent.LINEAR, vars);
        this.init(occval, onInf, onSup, environment);
    }

    public void init(int occval, boolean onInf, boolean onSup, IEnvironment environment) {
        int i;
        this.occval = occval;
        this.constrainOnInfNumber = onInf;
        this.constrainOnSupNumber = onSup;
        this.nbListVars = ((IntDomainVar[])this.vars).length - 1;
        this.nbPossible = environment.makeInt(0);
        this.nbSure = environment.makeInt(0);
        int cpt = 0;
        for (i = 0; i < ((IntDomainVar[])this.vars).length - 1; ++i) {
            if (!((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(this.occval)) continue;
            this.nbPossible.add(1);
            ++cpt;
        }
        this.relevantVar = new IntDomainVar[cpt];
        cpt = 0;
        for (i = 0; i < ((IntDomainVar[])this.vars).length - 1; ++i) {
            if (!((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(this.occval)) continue;
            this.relevantVar[cpt] = ((IntDomainVar[])this.vars)[i];
            ++cpt;
        }
    }

    @Override
    public int getFilteredEventMask(int idx) {
        if (idx == ((IntDomainVar[])this.vars).length - 1) {
            return 3;
        }
        return 12;
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        this.checkNbPossible();
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        this.checkNbSure();
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        if (((IntDomainVar[])this.vars)[idx].getVal() == this.occval) {
            this.nbSure.add(1);
            this.checkNbSure();
        }
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
        while (deltaDomain.hasNext()) {
            int x = deltaDomain.next();
            if (x != this.occval) continue;
            this.nbPossible.add(-1);
        }
        deltaDomain.dispose();
        this.checkNbPossible();
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        int nbVars = ((IntDomainVar[])this.vars).length - 1;
        int cptVal = 0;
        for (int i = 0; i < nbVars; ++i) {
            if (tuple[i] != this.occval) continue;
            ++cptVal;
        }
        if (this.constrainOnInfNumber & this.constrainOnSupNumber) {
            return cptVal == tuple[nbVars];
        }
        if (this.constrainOnInfNumber) {
            return cptVal >= tuple[nbVars];
        }
        return cptVal <= tuple[nbVars];
    }

    public void checkNbPossible() throws ContradictionException {
        if (this.constrainOnInfNumber) {
            ((IntDomainVar[])this.vars)[this.nbListVars].updateSup(this.nbPossible.get(), this, true);
            if (((IntDomainVar[])this.vars)[this.nbListVars].getInf() == this.nbPossible.get()) {
                for (int i = 0; i < this.relevantVar.length; ++i) {
                    IntDomainVar aRelevantVar = this.relevantVar[i];
                    if (!aRelevantVar.canBeInstantiatedTo(this.occval) || aRelevantVar.isInstantiated()) continue;
                    aRelevantVar.instantiate(this.occval, this, true);
                }
            }
        }
    }

    public void checkNbSure() throws ContradictionException {
        if (this.constrainOnSupNumber) {
            ((IntDomainVar[])this.vars)[this.nbListVars].updateInf(this.nbSure.get(), this, true);
            if (((IntDomainVar[])this.vars)[this.nbListVars].getSup() == this.nbSure.get()) {
                for (int i = 0; i < this.relevantVar.length; ++i) {
                    IntDomainVar aRelevantVar = this.relevantVar[i];
                    if (!aRelevantVar.canBeInstantiatedTo(this.occval) || aRelevantVar.isInstantiated()) continue;
                    aRelevantVar.removeVal(this.occval, this, true);
                }
            }
        }
    }

    public void filter() throws ContradictionException {
        this.checkNbPossible();
        this.checkNbSure();
    }

    @Override
    public void propagate() throws ContradictionException {
        int nbSure = 0;
        int nbPossible = 0;
        for (int i = 0; i < this.nbListVars; ++i) {
            if (!((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(this.occval)) continue;
            ++nbPossible;
            if (!((IntDomainVar[])this.vars)[i].isInstantiatedTo(this.occval)) continue;
            ++nbSure;
        }
        this.nbSure.set(nbSure);
        this.nbPossible.set(nbPossible);
        this.checkNbPossible();
        this.checkNbSure();
    }

    @Override
    public void awake() throws ContradictionException {
        this.propagate();
    }

    @Override
    public Boolean isEntailed() {
        int nbPos = 0;
        int nbSur = 0;
        for (int i = 0; i < this.relevantVar.length; ++i) {
            if (!((IntDomainVar[])this.vars)[i].canBeInstantiatedTo(this.occval)) continue;
            ++nbPos;
            if (!((IntDomainVar[])this.vars)[i].isInstantiated() || ((IntDomainVar[])this.vars)[i].getVal() != this.occval) continue;
            ++nbSur;
        }
        if (this.constrainOnInfNumber & this.constrainOnSupNumber) {
            if (((IntDomainVar[])this.vars)[this.nbListVars].isInstantiated()) {
                if (nbPos == nbSur && nbPos == ((IntDomainVar[])this.vars)[this.nbListVars].getVal()) {
                    return Boolean.TRUE;
                }
            } else if (nbPos < ((IntDomainVar[])this.vars)[this.nbListVars].getInf() || nbSur > ((IntDomainVar[])this.vars)[this.nbListVars].getSup()) {
                return Boolean.FALSE;
            }
        } else if (this.constrainOnInfNumber) {
            if (nbPos >= ((IntDomainVar[])this.vars)[this.nbListVars].getSup()) {
                return Boolean.TRUE;
            }
            if (nbPos < ((IntDomainVar[])this.vars)[this.nbListVars].getInf()) {
                return Boolean.FALSE;
            }
        } else {
            if (nbPos <= ((IntDomainVar[])this.vars)[this.nbListVars].getInf()) {
                return Boolean.TRUE;
            }
            if (nbPos > ((IntDomainVar[])this.vars)[this.nbListVars].getSup()) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    @Override
    public String pretty() {
        StringBuilder s = new StringBuilder("occur([");
        for (int i = 0; i < ((IntDomainVar[])this.vars).length - 2; ++i) {
            s.append(((IntDomainVar[])this.vars)[i]).append(",");
        }
        s.append(((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 2]).append("], ").append(this.occval).append(")");
        if (this.constrainOnInfNumber && this.constrainOnSupNumber) {
            s.append(" = ");
        } else if (this.constrainOnInfNumber) {
            s.append(" >= ");
        } else {
            s.append(" <= ");
        }
        s.append(((IntDomainVar[])this.vars)[((IntDomainVar[])this.vars).length - 1]);
        return s.toString();
    }
}

