/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.cumulative;

import choco.cp.solver.constraints.global.scheduling.cumulative.AbstractCumulativeSConstraint;
import choco.cp.solver.constraints.global.scheduling.cumulative.ICumulRules;
import choco.cp.solver.constraints.global.scheduling.trees.CumTreeT;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.common.util.comparator.TaskComparators;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.SolverException;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.TaskVar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class CumulRules
implements ICumulRules {
    public final AbstractCumulativeSConstraint rsc;
    protected final LinkedList<IRTask> tasksLX;
    protected final List<IRTask> tasksLY;
    protected CumTreeT<TaskVar> thetatree;
    protected Consumption[] Sc;
    protected Consumption[] taskheights;
    protected long[][] R;

    public CumulRules(AbstractCumulativeSConstraint rsc) {
        this.rsc = rsc;
        this.tasksLY = new ArrayList<IRTask>(rsc.asRTaskList());
        this.tasksLX = new LinkedList<IRTask>(rsc.asRTaskList());
        this.taskheights = new Consumption[rsc.getNbTasks()];
    }

    @Override
    public void initializeEdgeFindingData() {
        Consumption cons;
        HashMap<Integer, Consumption> map = new HashMap<Integer, Consumption>();
        int cpt = 0;
        for (int i = 0; i < this.rsc.getNbTasks(); ++i) {
            int h = this.rsc.getHeight(i).getInf();
            cons = (Consumption)map.get(h);
            if (cons == null) {
                cons = new Consumption(h, cpt);
                map.put(h, cons);
                ++cpt;
            }
            this.taskheights[i] = cons;
        }
        this.Sc = new Consumption[map.size()];
        Set entries = map.entrySet();
        Iterator it = entries.iterator();
        while (it.hasNext()) {
            this.Sc[cons.idx] = cons = (Consumption)it.next().getValue();
        }
        this.R = new long[this.Sc.length][this.rsc.getNbTasks()];
    }

    @Override
    public void initializeEdgeFindingEnd() {
        Collections.sort(this.tasksLX, TaskComparators.makeReverseRLatestCompletionTimeCmp());
        Collections.sort(this.tasksLY, TaskComparators.makeReverseREarliestStartingTimeCmp());
    }

    @Override
    public void initializeEdgeFindingStart() {
        Collections.sort(this.tasksLX, TaskComparators.makeREarliestStartingTimeCmp());
        Collections.sort(this.tasksLY, TaskComparators.makeRLatestCompletionTimeCmp());
    }

    @Override
    public void reinitConsumption() {
        for (int i = 0; i < this.Sc.length; ++i) {
            this.Sc[i].dyncomputation = false;
        }
    }

    public void oldSlowTaskIntervals() throws ContradictionException {
        int D = Integer.MIN_VALUE;
        for (IRTask i : this.tasksLY) {
            if (D == i.getTaskVar().getLCT()) continue;
            D = i.getTaskVar().getLCT();
            long tote = 0L;
            ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
            while (iter.hasPrevious()) {
                IRTask crt = iter.previous();
                TaskVar t = crt.getTaskVar();
                long e = crt.getMinConsumption();
                if (t.getLCT() > D) {
                    e = Math.min(e, (long)((D - t.getLST()) * crt.getMinHeight()));
                }
                if (e <= 0L) continue;
                long diff = D - t.getEST();
                long capaMaxDiff = (long)this.rsc.getMaxCapacity() * diff;
                if (capaMaxDiff >= (tote += e)) continue;
                this.rsc.fail();
            }
        }
    }

    private final void checkInterval(int startI, int endI, long energy) throws ContradictionException {
        long diff = endI - startI;
        long capaMaxDiff = (long)this.rsc.getMaxCapacity() * diff;
        if (capaMaxDiff < energy) {
            this.rsc.fail();
        }
    }

    @Override
    public void slowTaskIntervals() throws ContradictionException {
        int endI = Integer.MIN_VALUE;
        for (IRTask i : this.tasksLY) {
            if (endI <= i.getTaskVar().getLCT()) continue;
            int startI = endI = i.getTaskVar().getLCT();
            long tote = 0L;
            ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
            while (iter.hasPrevious()) {
                IRTask crt = iter.previous();
                TaskVar t = crt.getTaskVar();
                long e = 0L;
                if (t.getLCT() <= endI) {
                    e = crt.getMinHeight() * crt.getTaskVar().getMinDuration();
                } else if (t.getLST() < endI) {
                    e = (endI - t.getLST()) * crt.getMinHeight();
                }
                if (t.getEST() < startI) {
                    this.checkInterval(startI, endI, tote);
                    startI = t.getEST();
                }
                tote += e;
            }
            this.checkInterval(startI, endI, tote);
        }
    }

    @Override
    public void taskIntervals() throws ContradictionException {
        if (this.thetatree == null) {
            this.thetatree = new CumTreeT<TaskVar>(this.rsc);
        }
        this.thetatree.setMode(IVilimTree.TreeMode.ECT);
        int maxCapa = this.rsc.getMaxCapacity();
        for (IRTask i : this.tasksLY) {
            this.thetatree.insertInTheta(i);
            if (this.thetatree.getEnergy() <= (long)(maxCapa * i.getTaskVar().getLCT())) continue;
            this.rsc.fail();
        }
    }

    protected void calcR_start(Consumption cons) {
        int c = cons.h;
        int i = cons.idx;
        long[] E = new long[this.rsc.getNbTasks()];
        for (int j = 0; j < this.rsc.getNbTasks(); ++j) {
            this.R[i][j] = Long.MIN_VALUE;
        }
        ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
        while (iter.hasPrevious()) {
            IRTask crx = iter.previous();
            TaskVar x = crx.getTaskVar();
            long ex = crx.getMinConsumption();
            for (int k = 0; k < this.rsc.getNbTasks(); ++k) {
                IRTask cry = this.tasksLY.get(k);
                int ylct = cry.getTaskVar().getLCT();
                int yidx = cry.getTaskIndex();
                if (x.getLCT() > ylct) continue;
                int n = yidx;
                E[n] = E[n] + ex;
                long rest = E[yidx] - (long)((this.rsc.getMaxCapacity() - c) * (ylct - x.getEST()));
                long q1 = this.R[i][yidx];
                long q2 = k == 0 ? Long.MIN_VALUE : this.R[i][this.tasksLY.get(k - 1).getTaskIndex()];
                long q3 = rest > 0L ? (long)x.getEST() + (long)Math.ceil((double)rest / (double)c) : Long.MIN_VALUE;
                this.R[i][yidx] = Math.max(Math.max(q1, q2), q3);
            }
        }
    }

    @Override
    public boolean calcEF_start() throws ContradictionException {
        int nbTask = this.rsc.getNbTasks();
        int[] newSdates = new int[nbTask];
        long[] E = new long[nbTask];
        for (IRTask tv : this.tasksLX) {
            newSdates[tv.getTaskIndex()] = tv.getTaskVar().getEST();
        }
        for (IRTask cry : this.tasksLY) {
            TaskVar y = cry.getTaskVar();
            long ETot = 0L;
            ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
            while (iter.hasPrevious()) {
                IRTask x = iter.previous();
                if (x.getTaskVar().getLCT() <= y.getLCT()) {
                    ETot += x.getMinConsumption();
                }
                E[x.getTaskIndex()] = ETot;
            }
            long CEF = Long.MIN_VALUE;
            for (IRTask crx : this.tasksLX) {
                TaskVar x = crx.getTaskVar();
                int j = crx.getTaskIndex();
                long ex = crx.getMinConsumption();
                if ((CEF = Math.max(CEF, E[j] - (long)(this.rsc.getMaxCapacity() * (y.getLCT() - x.getEST())))) + ex <= 0L || x.getLCT() <= y.getLCT()) continue;
                if (!this.taskheights[j].dyncomputation) {
                    this.calcR_start(this.taskheights[j]);
                    this.taskheights[j].dyncomputation = true;
                }
                newSdates[j] = (int)Math.max((long)newSdates[j], this.R[this.taskheights[j].idx][cry.getTaskIndex()]);
            }
        }
        boolean modif = false;
        for (IRTask x : this.tasksLX) {
            int i = x.getTaskIndex();
            modif |= x.updateEST(newSdates[i]);
        }
        return modif;
    }

    @Override
    public boolean vilimStartEF() throws ContradictionException {
        throw new SolverException("Vilim version of edge finding for starting dates remain to be done");
    }

    protected void calcR_end(Consumption cons) {
        int nbTask = this.rsc.getNbTasks();
        int c = cons.h;
        int i = cons.idx;
        long[] E = new long[nbTask];
        for (int j = 0; j < nbTask; ++j) {
            E[j] = 0L;
            this.R[i][j] = Long.MAX_VALUE;
        }
        ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
        while (iter.hasPrevious()) {
            IRTask crx = iter.previous();
            TaskVar x = crx.getTaskVar();
            long ex = crx.getMinConsumption();
            for (int k = 0; k < nbTask; ++k) {
                IRTask cry = this.tasksLY.get(k);
                TaskVar y = cry.getTaskVar();
                int yidx = cry.getTaskIndex();
                if (x.getEST() < y.getEST()) continue;
                int n = yidx;
                E[n] = E[n] + ex;
                long rest = E[yidx] - (long)((this.rsc.getMaxCapacity() - c) * (x.getLCT() - y.getEST()));
                long q1 = this.R[i][yidx];
                long q2 = k == 0 ? Long.MAX_VALUE : this.R[i][this.tasksLY.get(k - 1).getTaskIndex()];
                long q3 = rest > 0L ? (long)x.getLCT() - (long)Math.ceil((double)rest / (double)c) : Long.MAX_VALUE;
                this.R[i][yidx] = Math.min(Math.min(q1, q2), q3);
            }
        }
    }

    @Override
    public boolean calcEF_end() throws ContradictionException {
        int nbTask = this.rsc.getNbTasks();
        int[] newEdates = new int[nbTask];
        long[] E = new long[nbTask];
        for (IRTask tv : this.tasksLX) {
            newEdates[tv.getTaskIndex()] = tv.getTaskVar().getLCT();
        }
        for (IRTask cry : this.tasksLY) {
            TaskVar y = cry.getTaskVar();
            long ETot = 0L;
            ListIterator<IRTask> iter = this.tasksLX.listIterator(this.tasksLX.size());
            while (iter.hasPrevious()) {
                IRTask crx = iter.previous();
                if (crx.getTaskVar().getEST() >= y.getEST()) {
                    ETot += crx.getMinConsumption();
                }
                E[crx.getTaskIndex()] = ETot;
            }
            long CEF = Long.MIN_VALUE;
            for (IRTask crx : this.tasksLX) {
                TaskVar x = crx.getTaskVar();
                int j = crx.getTaskIndex();
                long ex = crx.getMinConsumption();
                if ((CEF = Math.max(CEF, E[j] - (long)(this.rsc.getMaxCapacity() * (x.getLCT() - y.getEST())))) + ex <= 0L || x.getEST() >= y.getEST()) continue;
                if (!this.taskheights[j].dyncomputation) {
                    this.calcR_end(this.taskheights[j]);
                    this.taskheights[j].dyncomputation = true;
                }
                newEdates[j] = (int)Math.min((long)newEdates[j], this.R[this.taskheights[j].idx][cry.getTaskIndex()]);
            }
        }
        boolean modif = false;
        for (IRTask crx : this.tasksLX) {
            int i = crx.getTaskIndex();
            modif |= crx.updateLCT(newEdates[i]);
        }
        return modif;
    }

    @Override
    public boolean vilimEndEF() throws ContradictionException {
        throw new UnsupportedOperationException("Vilim version of edge finding for the ending dates remains to be done");
    }

    private static class Consumption {
        public int h;
        public int idx;
        public boolean dyncomputation;

        public Consumption(int h, int idx) {
            this.h = h;
            this.idx = idx;
            this.dyncomputation = false;
        }
    }
}

