/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.global.scheduling.disjunctive;

import choco.cp.solver.constraints.global.scheduling.disjunctive.IBipartiteQueue;
import choco.cp.solver.constraints.global.scheduling.disjunctive.IDisjRules;
import choco.cp.solver.constraints.global.scheduling.disjunctive.UpdateManager;
import choco.cp.solver.constraints.global.scheduling.trees.IThetaTree;
import choco.cp.solver.constraints.global.scheduling.trees.IVilimTree;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.variables.scheduling.IRMakespan;
import choco.kernel.solver.variables.scheduling.IRTask;
import choco.kernel.solver.variables.scheduling.ITask;
import java.util.Arrays;
import java.util.Comparator;

public abstract class AbstractDisjRules
implements IDisjRules {
    protected final IRTask[] rtasks;
    protected final UpdateManager updateManager;
    protected final IRMakespan makespan;
    private IVilimTree.TreeMode state;

    public AbstractDisjRules(IRTask[] rtasks, IRMakespan makespan, boolean enableRemove) {
        this.rtasks = Arrays.copyOf(rtasks, rtasks.length);
        this.makespan = makespan;
        this.updateManager = new UpdateManager(this, rtasks.length, enableRemove);
        this.fireDomainChanged();
    }

    protected final ITask[] getTaskArray() {
        ITask[] tasks = new ITask[this.rtasks.length];
        for (int i = 0; i < tasks.length; ++i) {
            tasks[i] = this.rtasks[i].getHTask();
        }
        return tasks;
    }

    @Override
    public void initialize() {
        this.updateManager.clear();
        this.fireDomainChanged();
    }

    @Override
    public void fireDomainChanged() {
        this.state = null;
    }

    protected void sortRTasks(Comparator<IRTask> cmp) {
        Arrays.sort(this.rtasks, cmp);
    }

    protected static final <E> void sortQueue(IBipartiteQueue<E> queue, Comparator<E> cmp) {
        queue.reset();
        queue.sort(cmp);
    }

    protected final void setupMasterTree(IVilimTree tree, IVilimTree.TreeMode mode) {
        if (this.state == mode) {
            tree.reset();
        } else {
            this.state = mode;
            tree.setMode(this.state);
        }
    }

    protected final void setMakespanLB(IThetaTree tree) throws ContradictionException {
        this.makespan.updateInf(tree.getTime());
    }

    @Override
    public final boolean detectablePrecedence() throws ContradictionException {
        return this.detectablePrecedenceEST() | this.detectablePrecedenceLCT();
    }

    @Override
    public final boolean edgeFinding() throws ContradictionException {
        return this.edgeFindingEST() | this.edgeFindingLCT();
    }

    @Override
    public final boolean notFirstNotLast() throws ContradictionException {
        return this.notFirst() | this.notLast();
    }
}

