/*
 * Decompiled with CFR 0.152.
 */
package choco.kernel.memory.trailing;

import choco.kernel.memory.IStateInt;
import choco.kernel.memory.trailing.AbstractStoredObject;
import choco.kernel.memory.trailing.EnvironmentTrailing;
import choco.kernel.memory.trailing.trail.StoredIntTrail;

public class StoredInt
extends AbstractStoredObject
implements IStateInt {
    private int currentValue;
    protected final StoredIntTrail myTrail;

    public StoredInt(EnvironmentTrailing env, int i) {
        super(env);
        this.myTrail = env.getIntTrail();
        this.currentValue = i;
    }

    private final void save() {
        if (this.worldStamp < this.environment.getWorldIndex()) {
            this.myTrail.savePreviousState(this, this.currentValue, this.worldStamp);
            this.worldStamp = this.environment.getWorldIndex();
        }
    }

    @Override
    public final int add(int delta) {
        if (delta != 0) {
            this.save();
        }
        this.currentValue += delta;
        return this.currentValue;
    }

    @Override
    public int increment() {
        this.save();
        return ++this.currentValue;
    }

    @Override
    public int decrement() {
        this.save();
        return --this.currentValue;
    }

    @Override
    public final int get() {
        return this.currentValue;
    }

    @Override
    public final void set(int y) {
        if (y != this.currentValue) {
            this.save();
        }
        this.currentValue = y;
    }

    public void _set(int y, int wstamp) {
        this.currentValue = y;
        this.worldStamp = wstamp;
    }

    public final String toString() {
        return String.valueOf(this.currentValue);
    }
}

