/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.values;

import java.util.function.BiPredicate;
import org.chocosolver.solver.Cause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.ResolutionPolicy;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.DecisionOperatorFactory;
import org.chocosolver.solver.search.strategy.selectors.values.IntValueSelector;
import org.chocosolver.solver.variables.IntVar;

public final class IntDomainBest
implements IntValueSelector {
    private final int maxdom;
    private final DecisionOperator<IntVar> dop;
    private final BiPredicate<IntVar, Integer> condition;

    public IntDomainBest(int maxdom, DecisionOperator<IntVar> dop, BiPredicate<IntVar, Integer> condition) {
        this.maxdom = maxdom;
        this.dop = dop;
        this.condition = condition;
    }

    public IntDomainBest(BiPredicate<IntVar, Integer> condition) {
        this(100, DecisionOperatorFactory.makeIntEq(), condition);
    }

    public IntDomainBest() {
        this(100, DecisionOperatorFactory.makeIntEq(), (k, v) -> false);
    }

    @Override
    public int selectValue(IntVar var) {
        int ubB;
        assert (var.getModel().getObjective() != null);
        if (var.hasEnumeratedDomain() && var.getDomainSize() < this.maxdom) {
            int bestCost = Integer.MAX_VALUE;
            int ub = var.getUB();
            int bestV = this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? ub : var.getLB();
            int v = var.getLB();
            while (v <= ub) {
                int bound = this.bound(var, v);
                if (bound < bestCost || bound == bestCost && this.condition.test(var, v)) {
                    bestCost = bound;
                    bestV = v;
                }
                v = var.nextValue(v);
            }
            return bestV;
        }
        int lbB = this.bound(var, var.getLB());
        if (lbB == (ubB = this.bound(var, var.getUB()))) {
            return this.dop == DecisionOperatorFactory.makeIntReverseSplit() ? var.getUB() : var.getLB();
        }
        return lbB < ubB ? var.getLB() : var.getUB();
    }

    private int bound(IntVar var, int val) {
        int cost;
        Model model = var.getModel();
        if (this.dop == DecisionOperatorFactory.makeIntSplit() && val == var.getUB() || this.dop == DecisionOperatorFactory.makeIntReverseSplit() && val == var.getLB()) {
            return Integer.MAX_VALUE;
        }
        model.getEnvironment().worldPush();
        try {
            this.dop.apply(var, val, Cause.Null);
            model.getSolver().getEngine().propagate();
            ResolutionPolicy rp = model.getSolver().getObjectiveManager().getPolicy();
            cost = rp == ResolutionPolicy.SATISFACTION ? 1 : (rp == ResolutionPolicy.MINIMIZE ? ((IntVar)model.getObjective()).getLB() : -((IntVar)model.getObjective()).getUB());
        }
        catch (ContradictionException cex) {
            cost = Integer.MAX_VALUE;
        }
        model.getSolver().getEngine().flush();
        model.getEnvironment().worldPop();
        return cost;
    }
}

