/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine.metadata;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.interfaces.IMetadataSource;
import com.simba.athena.dsi.dataengine.utilities.DSITypeUtilities;
import com.simba.athena.dsi.dataengine.utilities.DataWrapper;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class AJCatalogSchemaOnlyMetadataSource
implements IMetadataSource {
    private AJClient m_client;
    private ILogger m_logger;
    private List<String> schemaList = new ArrayList<String>();
    private ListIterator<String> m_schemaIterator;
    private String currentSchema;

    public AJCatalogSchemaOnlyMetadataSource(ILogger iLogger, AJClient aJClient) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, aJClient);
        this.m_logger = iLogger;
        this.m_client = aJClient;
        this.m_client.getSchemas(this.schemaList);
        this.m_schemaIterator = this.schemaList.listIterator(0);
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                return DSITypeUtilities.outputVarCharStringData("AwsDataCatalog", dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.currentSchema, dataWrapper, l, l2);
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return this.m_schemaIterator.hasNext();
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.currentSchema = this.m_schemaIterator.next();
            return true;
        }
        return false;
    }
}

