/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.MutableTreeModel;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.Taxon;
import dr.evolution.util.TaxonList;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import java.util.BitSet;
import java.util.Set;

public class AncestralTaxonAlongAncestralPath
extends AbstractModel {
    private final Taxon ancestor;
    private final MutableTreeModel treeModel;
    private final TaxonList descendents;
    private final Set<Integer> tips;
    private final BitSet tipBitSet;
    private final Parameter pseudoBranchLength;
    private int index;
    private NodeRef node;

    public AncestralTaxonAlongAncestralPath(Taxon taxon, MutableTreeModel mutableTreeModel, TaxonList taxonList, Parameter parameter) throws TreeUtils.MissingTaxonException {
        this(taxon, mutableTreeModel, taxonList, parameter, null, -1);
    }

    public AncestralTaxonAlongAncestralPath(Taxon taxon, MutableTreeModel mutableTreeModel, TaxonList taxonList, Parameter parameter, NodeRef nodeRef, int n) throws TreeUtils.MissingTaxonException {
        super(taxon.getId());
        this.ancestor = taxon;
        this.treeModel = mutableTreeModel;
        this.descendents = taxonList;
        this.pseudoBranchLength = parameter;
        this.index = n;
        this.node = nodeRef;
        this.tips = TreeUtils.getTipsForTaxa(mutableTreeModel, taxonList);
        this.tipBitSet = TreeUtils.getTipsBitSetForTaxa(mutableTreeModel, taxonList);
        this.addVariable(parameter);
    }

    public final double getPseudoBranchLength() {
        return this.pseudoBranchLength.getParameterValue(0);
    }

    final MutableTreeModel getTreeModel() {
        return this.treeModel;
    }

    final double[] getRestrictedPartials() {
        assert (false);
        return null;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    public final NodeRef getNode() {
        return this.node;
    }

    public final void setNode(NodeRef nodeRef) {
        this.node = nodeRef;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        throw new RuntimeException("Not yet implemented");
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireModelChanged(variable, n);
    }

    public TaxonList getTaxonList() {
        return this.descendents;
    }

    public BitSet getTipBitSet() {
        return this.tipBitSet;
    }

    public Taxon getTaxon() {
        return this.ancestor;
    }
}

