/*
 * Decompiled with CFR 0.152.
 */
package core.explorer;

import core.explorer.ChordalysisModeller;
import core.model.ScoredGraphAction;
import core.stats.EntropyComputer;
import core.stats.scorer.GraphActionScorer;
import core.stats.scorer.GraphActionScorerBIC;

public class ChordalysisModellingBIC
extends ChordalysisModeller {
    int maxK;
    boolean normaliseByBIC;

    public ChordalysisModellingBIC(ChordalysisModeller.Data data, int maxK) {
        super(data);
        this.maxK = maxK;
    }

    @Override
    protected GraphActionScorer initScorer() {
        EntropyComputer entropyComputer = new EntropyComputer(this.lattice);
        return new GraphActionScorerBIC(entropyComputer, this.maxK);
    }

    @Override
    public void explore() {
        this.pq.processStoredModifications();
        int step = 0;
        while (!this.pq.isEmpty() && step < this.maxNSteps) {
            ScoredGraphAction todo = (ScoredGraphAction)this.pq.poll();
            if (todo.getScore() == Double.POSITIVE_INFINITY || todo.getScore() >= 0.0) break;
            this.operationsPerformed.add(todo);
            this.bestModel.performAction(todo, this.bestModel, this.pq);
            ++step;
        }
    }
}

