/*
 * Decompiled with CFR 0.152.
 */
package edu.cens.text;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.rosuda.deducer.Deducer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProcessCmd {
    tolower("To Lower Case", "tm_map(%s, content_transformer(tolower))"),
    depunct("Remove Punctuation", "tm_map(%s, removePunctuation)"),
    denumber("Remove Numbers", "tm_map(%s, removeNumbers)"),
    deword("Remove Stopwords (default list)", "tm_map(%s, removeWords, stopwords())"){
        String stopwordFile = null;

        public String getRCmd(String ... stringArray) {
            return String.format("tm_map(%s, removeWords, stopwords(" + this.getStopwordString() + "))", stringArray);
        }

        private String getStopwordString() {
            if (this.stopwordFile != null) {
                return "'" + this.stopwordFile + "'";
            }
            return "";
        }

        public JMenuItem[] getExtraOptions() {
            return new JMenuItem[]{new JMenuItem("Print Stopwords"){
                {
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            if (stopwordFile == null) {
                                Deducer.execute((String)"stopwords();");
                            } else {
                                Deducer.execute((String)("readLines(" + this.getStopwordString() + ",warn=F)"));
                            }
                        }
                    });
                }
            }, new JMenuItem("Use Custom Stopword File"){
                {
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            JFileChooser jFileChooser = new JFileChooser();
                            int n = jFileChooser.showOpenDialog(null);
                            if (n == 0) {
                                stopwordFile = jFileChooser.getSelectedFile().toString();
                                File file = new File(stopwordFile);
                                _label = "Remove Stopwords (" + file.getName() + ")";
                                if (_parent != null) {
                                    _parent.repaint();
                                }
                            }
                        }
                    });
                }
            }, new JMenuItem("Use Default Stopwords"){
                {
                    this.setSelected(true);
                    this.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            stopwordFile = null;
                            _label = "Remove Stopwords (default list)";
                        }
                    });
                }
            }};
        }
    }
    ,
    strip("Remove Whitespace", "tm_map(%s, stripWhitespace)"),
    stem("Stem Words", "tm_map(%s, stemDocument)");

    public String _label;
    public final String _function;
    protected Component _parent;
    protected static ButtonGroup defaultOrCustomStopwordButtonGroup;

    private ProcessCmd(String string2, String string3) {
        this._label = string2;
        this._function = string3;
    }

    public String getRCmd(String ... stringArray) {
        return String.format(this._function, stringArray);
    }

    public JMenuItem[] getExtraOptions() {
        return new JMenuItem[0];
    }

    public String toString() {
        return this._label;
    }

    public String getLabel() {
        return this._label;
    }

    public void setParentComponent(Component component) {
        this._parent = component;
    }

    static {
        defaultOrCustomStopwordButtonGroup = new ButtonGroup();
    }
}

