## Version 2.2.0

#### New functionality
* Added option to plot the reconstructed tree for a set of fossils and tree objects. This can be done by passing `reconstructed = TRUE` to `plot.fossils` or the objects can be generated separately using the function `reconstructed.tree.fossils.objects`.

##### Functions associated with the occurrence birth-death model
* Added `fossils` as a function argument to the fossil simulation functions so that existing fossil objects can be appended.
* Added `ignore.taxonomy` as a function argument to the fossil simulation functions. If `true` function will not return species or edge info.
* Added `show.unknown` to plotting function. If species or edge info is unknown these fossils will appear next to the tree.

#### Bug fixes
* Fixed bug in `plot.fossils` which led to proxy data being plotted the wrong way round on the x-axis.

## Version 2.1.1

* Fixed a bug in ``sim.fbd.rateshift.taxa`` which led to trees being simulated with the wrong rates. NB: Any dataset simulated with this function before the fix is invalid and needs to be rerun.

## Version 2.1.0

#### New functionality
* The new function ``fossils.to.pyrate`` can be used to convert objects generated by this package into PyRate format.
* The new functions ``fossils.to.BEAST.constraints`` and ``fossils.to.BEAST.start.tree.Rd`` can be used to convert objects generated by this package into BEAST2 format.
* The new functions ``subsample.fossils.oldest``, ``subsample.fossils.oldest.and.youngest``, ``subsample.fossils.uniform`` and ``subsample.fossils.youngest`` can be used to subsample fossil occurrences.

#### Function changes
* The innovative rates model has been integrated into the independent model in the function ``sim.trait.values``. Parameters are unchanged.
* The asymmetric plot function has been renamed ``rangeplot.asymmetric`` and separated from the ``SAtree`` objects.

#### Bugfixes
* Fixed several bugs in ``rangeplot.asymmetric`` that could lead to crashes or plots with missing edges.
* Fixed a bug in ``SAtree.from.fossils`` where ``SAtree`` objects were not created properly when using an empty ``fossils`` object.
