/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.bin;

import cern.colt.list.tfloat.FloatArrayList;
import cern.jet.random.tfloat.engine.FRand;
import cern.jet.random.tfloat.engine.FloatRandomEngine;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinder;
import cern.jet.stat.tfloat.quantile.FloatQuantileFinderFactory;
import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.bin.AbstractFloatBin1D;
import hep.aida.tfloat.bin.MightyStaticFloatBin1D;
import hep.aida.tfloat.ref.FloatConverter;
import java.util.Date;

public class QuantileFloatBin1D
extends MightyStaticFloatBin1D {
    private static final long serialVersionUID = 1L;
    protected FloatQuantileFinder finder = null;

    protected QuantileFloatBin1D() {
        super(false, false, 2);
    }

    public QuantileFloatBin1D(float f) {
        this(false, Long.MAX_VALUE, f, 0.001f, 10000, new FRand(new Date()));
    }

    public QuantileFloatBin1D(boolean bl, long l, float f, float f2, int n, FloatRandomEngine floatRandomEngine) {
        this(bl, l, f, f2, n, floatRandomEngine, false, false, 2);
    }

    public QuantileFloatBin1D(boolean bl, long l, float f, float f2, int n, FloatRandomEngine floatRandomEngine, boolean bl2, boolean bl3, int n2) {
        super(bl2, bl3, n2);
        this.finder = FloatQuantileFinderFactory.newFloatQuantileFinder(bl, l, f, f2, n, floatRandomEngine);
        this.clear();
    }

    public synchronized void addAllOfFromTo(FloatArrayList floatArrayList, int n, int n2) {
        super.addAllOfFromTo(floatArrayList, n, n2);
        if (this.finder != null) {
            this.finder.addAllOfFromTo(floatArrayList, n, n2);
        }
    }

    public synchronized void clear() {
        super.clear();
        if (this.finder != null) {
            this.finder.clear();
        }
    }

    public synchronized Object clone() {
        QuantileFloatBin1D quantileFloatBin1D = (QuantileFloatBin1D)super.clone();
        if (this.finder != null) {
            quantileFloatBin1D.finder = (FloatQuantileFinder)quantileFloatBin1D.finder.clone();
        }
        return quantileFloatBin1D;
    }

    public String compareWith(AbstractFloatBin1D abstractFloatBin1D) {
        StringBuffer stringBuffer = new StringBuffer(super.compareWith(abstractFloatBin1D));
        if (abstractFloatBin1D instanceof QuantileFloatBin1D) {
            QuantileFloatBin1D quantileFloatBin1D = (QuantileFloatBin1D)abstractFloatBin1D;
            stringBuffer.append("25%, 50% and 75% Quantiles: " + this.relError(this.quantile(0.25f), quantileFloatBin1D.quantile(0.25f)) + ", " + this.relError(this.quantile(0.5f), quantileFloatBin1D.quantile(0.5f)) + ", " + this.relError(this.quantile(0.75f), quantileFloatBin1D.quantile(0.75f)));
            stringBuffer.append("\nquantileInverse(mean): " + this.relError(this.quantileInverse(this.mean()), quantileFloatBin1D.quantileInverse(quantileFloatBin1D.mean())) + " %");
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public float median() {
        return this.quantile(0.5f);
    }

    public synchronized float quantile(float f) {
        return this.quantiles(new FloatArrayList(new float[]{f})).get(0);
    }

    public synchronized float quantileInverse(float f) {
        return this.finder.phi(f);
    }

    public synchronized FloatArrayList quantiles(FloatArrayList floatArrayList) {
        return this.finder.quantileElements(floatArrayList);
    }

    public int sizeOfRange(float f, float f2) {
        return Math.round((float)this.size() * (this.quantileInverse(f2) - this.quantileInverse(f)));
    }

    public synchronized MightyStaticFloatBin1D[] splitApproximately(FloatArrayList floatArrayList, int n) {
        int n2;
        int n3 = floatArrayList.size();
        if (n < 1 || n3 < 2) {
            throw new IllegalArgumentException();
        }
        float[] fArray = floatArrayList.elements();
        int n4 = n3 - 1;
        float[] fArray2 = new float[1 + n * (n3 - 1)];
        fArray2[0] = fArray[0];
        int n5 = 1;
        for (int i = 0; i < n4; ++i) {
            float f = (fArray[i + 1] - fArray[i]) / (float)n;
            for (n2 = 1; n2 <= n; ++n2) {
                fArray2[n5++] = fArray[i] + (float)n2 * f;
            }
        }
        float[] fArray3 = this.quantiles(new FloatArrayList(fArray2)).elements();
        MightyStaticFloatBin1D[] mightyStaticFloatBin1DArray = new MightyStaticFloatBin1D[n4];
        n2 = this.getMaxOrderForSumOfPowers();
        n2 = Math.min(10, n2);
        int n6 = this.size();
        n5 = 0;
        for (int i = 0; i < n4; ++i) {
            float f;
            int n7;
            float f2;
            float f3 = (fArray[i + 1] - fArray[i]) / (float)n;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 0.0f;
            float[] fArray4 = null;
            if (n2 > 2) {
                fArray4 = new float[n2 - 2];
            }
            float f8 = f2 = fArray3[n5++];
            float f9 = (float)n6 * f3;
            for (n7 = 1; n7 <= n; ++n7) {
                f = fArray3[n5++];
                float f10 = (f2 + f) / 2.0f;
                f4 += f10 * f9;
                f5 += f10 * f10 * f9;
                if (this.hasSumOfLogarithms) {
                    f6 = (float)((double)f6 + Math.log(f10) * (double)f9);
                }
                if (this.hasSumOfInversions) {
                    f7 += 1.0f / f10 * f9;
                }
                if (n2 >= 3) {
                    fArray4[0] = fArray4[0] + f10 * f10 * f10 * f9;
                }
                if (n2 >= 4) {
                    fArray4[1] = fArray4[1] + f10 * f10 * f10 * f10 * f9;
                }
                for (int j = 5; j <= n2; ++j) {
                    int n8 = j - 3;
                    fArray4[n8] = (float)((double)fArray4[n8] + Math.pow(f10, j) * (double)f9);
                }
                f2 = f;
            }
            --n5;
            n7 = Math.round((fArray[i + 1] - fArray[i]) * (float)n6);
            f = f2;
            f2 = f8;
            mightyStaticFloatBin1DArray[i] = new MightyStaticFloatBin1D(this.hasSumOfLogarithms, this.hasSumOfInversions, n2);
            if (n7 <= 0) continue;
            mightyStaticFloatBin1DArray[i].size = n7;
            mightyStaticFloatBin1DArray[i].min = f2;
            mightyStaticFloatBin1DArray[i].max = f;
            mightyStaticFloatBin1DArray[i].sum = f4;
            mightyStaticFloatBin1DArray[i].sum_xx = f5;
            mightyStaticFloatBin1DArray[i].sumOfLogarithms = f6;
            mightyStaticFloatBin1DArray[i].sumOfInversions = f7;
            mightyStaticFloatBin1DArray[i].sumOfPowers = fArray4;
        }
        return mightyStaticFloatBin1DArray;
    }

    public synchronized MightyStaticFloatBin1D[] splitApproximately(FloatIAxis floatIAxis, int n) {
        FloatArrayList floatArrayList = new FloatArrayList(new FloatConverter().edges(floatIAxis));
        floatArrayList.beforeInsert(0, Float.NEGATIVE_INFINITY);
        floatArrayList.add(Float.POSITIVE_INFINITY);
        int n2 = floatArrayList.size();
        while (--n2 >= 0) {
            floatArrayList.set(n2, this.quantileInverse(floatArrayList.get(n2)));
        }
        return this.splitApproximately(floatArrayList, n);
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("25%, 50%, 75% Quantiles: " + this.quantile(0.25f) + ", " + this.quantile(0.5f) + ", " + this.quantile(0.75f));
        stringBuffer.append("\nquantileInverse(median): " + this.quantileInverse(this.median()));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

