/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.type.codec;

import java.io.InputStream;
import org.openfast.ScalarValue;
import org.openfast.StringValue;
import org.openfast.template.TwinValue;
import org.openfast.template.type.codec.TypeCodec;

public class NullableStringDelta
extends TypeCodec {
    private static final long serialVersionUID = 1L;

    public ScalarValue decode(InputStream in) {
        ScalarValue subtractionLength = TypeCodec.NULLABLE_INTEGER.decode(in);
        if (subtractionLength == null) {
            return null;
        }
        ScalarValue difference = TypeCodec.ASCII.decode(in);
        return new TwinValue(subtractionLength, difference);
    }

    public byte[] encodeValue(ScalarValue value) {
        if (value.isNull()) {
            return TypeCodec.NULL_VALUE_ENCODING;
        }
        TwinValue diff = (TwinValue)value;
        byte[] subtractionLength = TypeCodec.NULLABLE_INTEGER.encode(diff.first);
        byte[] difference = TypeCodec.ASCII.encode(diff.second);
        byte[] encoded = new byte[subtractionLength.length + difference.length];
        System.arraycopy(subtractionLength, 0, encoded, 0, subtractionLength.length);
        System.arraycopy(difference, 0, encoded, subtractionLength.length, difference.length);
        return encoded;
    }

    public ScalarValue getDefaultValue() {
        return new StringValue("");
    }

    public ScalarValue fromString(String value) {
        return new StringValue(value);
    }

    public boolean isNullable() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

