/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.ssf;

import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DataBlockIterator;
import ec.tstoolkit.maths.matrices.SubMatrix;

public final class ExtendedFastGivens {
    public static boolean process(SubMatrix X, DataBlock W) {
        DataBlockIterator xcols = X.columns();
        DataBlock Xj = xcols.getData();
        int nr = X.getRowsCount();
        do {
            int j;
            double w;
            if ((w = W.get(j = xcols.getPosition())) == 0.0) continue;
            int jmax = Math.min(j, nr);
            for (int i = 0; i < jmax; ++i) {
                double xi = Xj.get(0);
                if (xi != 0.0) {
                    Xj.set(0, 0.0);
                    Xj = Xj.drop(1, 0);
                    DataBlock Li = X.column(i).drop(i + 1, 0);
                    double l = W.get(i);
                    if (l == 0.0) {
                        Li.product(Xj, 1.0 / xi);
                        if (Double.isInfinite(w)) {
                            W.set(i, Double.POSITIVE_INFINITY);
                        } else {
                            W.set(i, w * xi * xi);
                        }
                        w = 0.0;
                        Xj.set(0.0);
                        break;
                    }
                    if (Double.isInfinite(l)) {
                        Xj.addAY(-xi, Li);
                        continue;
                    }
                    if (Double.isInfinite(w)) {
                        w = l / (xi * xi);
                        W.set(i, Double.POSITIVE_INFINITY);
                        for (int k = 0; k < nr - i - 1; ++k) {
                            double lk = Li.get(k);
                            double xk = Xj.get(k);
                            Xj.add(k, -xi * lk);
                            Li.set(k, xk / xi);
                        }
                        continue;
                    }
                    double nl = l + w * xi * xi;
                    double rl = l / nl;
                    W.set(i, nl);
                    double c = w * xi / nl;
                    int nk = Li.getLength();
                    for (int k = 0; k < nk; ++k) {
                        double lk = Li.get(k);
                        double xk = Xj.get(k);
                        Xj.add(k, -xi * lk);
                        Li.set(k, rl * lk + c * xk);
                    }
                    w *= rl;
                    continue;
                }
                Xj = Xj.drop(1, 0);
            }
            if (j < nr) {
                double xj = Xj.get(j);
                if (xj != 0.0 && xj != 1.0) {
                    Xj.drop(j, 0).mul(1.0 / xj);
                }
                if (!Double.isInfinite(w)) {
                    w *= xj * xj;
                }
            }
            W.set(j, w);
        } while (xcols.next());
        int n = W.getLength() - nr;
        if (n > 0) {
            W.extract(nr, n, 1).set(0.0);
        }
        X.diagonal().set(1.0);
        return true;
    }

    private ExtendedFastGivens() {
    }
}

