/*
 * Decompiled with CFR 0.152.
 */
package it.bancaditalia.oss.sdmx.parser.v21;

import it.bancaditalia.oss.sdmx.api.DataFlowStructure;
import it.bancaditalia.oss.sdmx.api.Dataflow;
import it.bancaditalia.oss.sdmx.api.DoubleObservation;
import it.bancaditalia.oss.sdmx.api.PortableTimeSeries;
import it.bancaditalia.oss.sdmx.client.Parser;
import it.bancaditalia.oss.sdmx.exceptions.SdmxException;
import it.bancaditalia.oss.sdmx.parser.v21.DataParsingResult;
import it.bancaditalia.oss.sdmx.util.Configuration;
import it.bancaditalia.oss.sdmx.util.LanguagePriorityList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;

public class GenericDataParser
implements Parser<DataParsingResult> {
    protected static Logger logger = Configuration.getSdmxLogger();
    private static final String SERIES = "Series";
    private static final String SERIES_KEY = "SeriesKey";
    private static final String VALUE = "value";
    private static final String ID = "id";
    private static final String OBS = "Obs";
    private static final String OBS_TIME = "ObsDimension";
    private static final String OBS_VALUE = "ObsValue";
    private static final String ATTRIBUTES = "Attributes";
    private static final String ATTRIBUTEVALUE = "Value";
    private DataFlowStructure dsd;
    private Dataflow dataflow;
    private boolean data;

    public GenericDataParser(DataFlowStructure dataFlowStructure, Dataflow dataflow, boolean bl) {
        this.dsd = dataFlowStructure;
        this.dataflow = dataflow;
        this.data = bl;
    }

    @Override
    public DataParsingResult parse(XMLEventReader xMLEventReader, LanguagePriorityList languagePriorityList) throws XMLStreamException, SdmxException {
        DataParsingResult dataParsingResult = new DataParsingResult();
        ArrayList<PortableTimeSeries<Double>> arrayList = new ArrayList<PortableTimeSeries<Double>>();
        PortableTimeSeries<Double> portableTimeSeries = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == SERIES) {
                    portableTimeSeries = new PortableTimeSeries<Double>();
                    portableTimeSeries.setDataflow(this.dataflow);
                }
                if (xMLEvent.getName().getLocalPart() == SERIES_KEY) {
                    this.setSeriesKey(portableTimeSeries, xMLEventReader, this.dsd);
                }
                if (xMLEvent.getName().getLocalPart() == ATTRIBUTES) {
                    GenericDataParser.setSeriesAttributes(portableTimeSeries, xMLEventReader);
                }
                if (xMLEvent.getName().getLocalPart() == OBS && this.data) {
                    GenericDataParser.setSeriesSingleObs(portableTimeSeries, xMLEventReader);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES) continue;
            arrayList.add(portableTimeSeries);
        }
        dataParsingResult.setData(arrayList);
        return dataParsingResult;
    }

    private void setSeriesKey(PortableTimeSeries<Double> portableTimeSeries, XMLEventReader xMLEventReader, DataFlowStructure dataFlowStructure) throws XMLStreamException {
        String string = null;
        int n = dataFlowStructure.getDimensions().size();
        Map.Entry[] entryArray = new Map.Entry[n];
        String[] stringArray = new String[n];
        LinkedHashMap<String, Map.Entry<String, String>> linkedHashMap = new LinkedHashMap<String, Map.Entry<String, String>>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    String string2 = attribute.getValue();
                    stringArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = string;
                    entryArray[dataFlowStructure.getDimensionPosition((String)string) - 1] = new AbstractMap.SimpleEntry<String, String>(string2, "");
                    if (!string.equalsIgnoreCase("FREQ") && !string.equalsIgnoreCase("FREQUENCY")) continue;
                    portableTimeSeries.setFrequency(string2);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != SERIES_KEY) continue;
            for (int i = 0; i < n; ++i) {
                linkedHashMap.put(stringArray[i], entryArray[i]);
            }
            portableTimeSeries.setDimensions(linkedHashMap);
            break;
        }
    }

    private static void setSeriesAttributes(PortableTimeSeries<Double> portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException {
        String string = null;
        String string2 = null;
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement() && (xMLEvent = xMLEvent2.asStartElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                Iterator<Attribute> iterator = xMLEvent.getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    if (attribute.getName().toString().equalsIgnoreCase(ID)) {
                        string = attribute.getValue();
                        continue;
                    }
                    if (!attribute.getName().toString().equalsIgnoreCase(VALUE)) continue;
                    string2 = attribute.getValue();
                }
            }
            if (xMLEvent2.isEndElement() && (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart().equalsIgnoreCase(VALUE)) {
                portableTimeSeries.addAttribute(string, string2);
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != ATTRIBUTES) continue;
            break;
        }
    }

    private static void setSeriesSingleObs(PortableTimeSeries<Double> portableTimeSeries, XMLEventReader xMLEventReader) throws XMLStreamException, SdmxException {
        String string = null;
        String string2 = "";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        while (xMLEventReader.hasNext()) {
            XMLEvent xMLEvent;
            XMLEvent xMLEvent2 = xMLEventReader.nextEvent();
            logger.finest(xMLEvent2.toString());
            if (xMLEvent2.isStartElement()) {
                String string3;
                Object object;
                Object object2;
                xMLEvent = xMLEvent2.asStartElement();
                if (xMLEvent.getName().getLocalPart() == OBS_TIME) {
                    object2 = xMLEvent.getAttributes();
                    while (object2.hasNext()) {
                        object = object2.next();
                        string3 = object.getName().toString();
                        if (!string3.equals(VALUE)) continue;
                        string = object.getValue();
                    }
                } else if (xMLEvent.getName().getLocalPart() == OBS_VALUE) {
                    object2 = xMLEvent.getAttributes();
                    while (object2.hasNext()) {
                        object = object2.next();
                        string3 = object.getName().toString();
                        if (!string3.equals(VALUE)) continue;
                        string2 = object.getValue();
                    }
                } else if (xMLEvent.getName().getLocalPart() == ATTRIBUTEVALUE) {
                    object2 = xMLEvent.getAttributeByName(new QName(ID)).getValue();
                    object = xMLEvent.getAttributeByName(new QName(VALUE)).getValue();
                    hashtable.put((String)object2, (String)object);
                }
            }
            if (!xMLEvent2.isEndElement() || (xMLEvent = xMLEvent2.asEndElement()).getName().getLocalPart() != OBS) continue;
            try {
                portableTimeSeries.add(new DoubleObservation(string, Double.valueOf(string2), hashtable));
            }
            catch (NumberFormatException numberFormatException) {
                logger.fine("The date: " + string + "has an obs value that is not parseable to a numer: " + string2 + ". A NaN will be set.");
                portableTimeSeries.add(new DoubleObservation(string, Double.NaN, hashtable));
            }
            break;
        }
    }
}

