/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.field;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.drools.core.spi.FieldValue;

public class LongFieldImpl
implements FieldValue,
Externalizable {
    private static final long serialVersionUID = 510L;
    private long value;

    public LongFieldImpl() {
    }

    public LongFieldImpl(long value) {
        this.value = value;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readLong();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.value);
    }

    @Override
    public Serializable getValue() {
        return new Long(this.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean getBooleanValue() {
        throw new RuntimeException("Conversion to boolean not supported for type long");
    }

    @Override
    public byte getByteValue() {
        return (byte)this.value;
    }

    @Override
    public char getCharValue() {
        return (char)this.value;
    }

    @Override
    public double getDoubleValue() {
        return this.value;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    @Override
    public short getShortValue() {
        return (short)this.value;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof LongFieldImpl)) {
            return false;
        }
        LongFieldImpl other = (LongFieldImpl)object;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)this.value;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isBooleanField() {
        return false;
    }

    @Override
    public boolean isFloatNumberField() {
        return false;
    }

    @Override
    public boolean isIntegerNumberField() {
        return true;
    }

    @Override
    public boolean isObjectField() {
        return false;
    }

    @Override
    public boolean isCollectionField() {
        return false;
    }

    @Override
    public boolean isStringField() {
        return false;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return BigInteger.valueOf(this.value);
    }
}

