/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.api.ProfileResponse;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.api.util.ProfileOption;
import com.conveyal.r5.api.util.SegmentPattern;
import com.conveyal.r5.api.util.StreetEdgeInfo;
import com.conveyal.r5.api.util.StreetSegment;
import com.conveyal.r5.api.util.TransitSegment;
import com.conveyal.r5.common.GeometryUtils;
import com.conveyal.r5.transit.TransportNetwork;
import com.conveyal.r5.transit.TripPattern;
import java.util.List;
import org.ipea.r5r.RDataFrame;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathOptionsTable {
    private static final Logger LOG = LoggerFactory.getLogger(PathOptionsTable.class);
    private final TransportNetwork transportNetwork;
    private final ProfileResponse response;
    private RDataFrame optionsDataFrame;
    private String fromId;
    private double fromLat;
    private double fromLon;
    private String toId;
    private double toLat;
    private double toLon;
    private int maxWalkTime;
    private int maxBikeTime;
    private int maxTripDuration;
    private boolean dropItineraryGeometry = false;

    public void setOrigin(String fromId, double fromLat, double fromLon) {
        this.fromId = fromId;
        this.fromLat = fromLat;
        this.fromLon = fromLon;
    }

    public void setDestination(String toId, double toLat, double toLon) {
        this.toId = toId;
        this.toLat = toLat;
        this.toLon = toLon;
    }

    public void setTripDuration(int walkTime, int bikeTime, int tripDuration) {
        this.maxWalkTime = walkTime;
        this.maxBikeTime = bikeTime;
        this.maxTripDuration = tripDuration;
    }

    public void dropItineraryGeometry() {
        this.dropItineraryGeometry = true;
    }

    public RDataFrame getDataFrame() {
        return this.optionsDataFrame;
    }

    public PathOptionsTable(TransportNetwork transportNetwork, ProfileResponse response) {
        this.transportNetwork = transportNetwork;
        this.response = response;
    }

    public void build() {
        this.buildDataFrameStructure();
        try {
            this.populateDataFrame();
        }
        catch (Exception e) {
            LOG.error(String.format("Error while collecting paths between %s and %s", this.fromId, this.toId));
        }
    }

    void buildDataFrameStructure() {
        this.optionsDataFrame = new RDataFrame();
        this.optionsDataFrame.addStringColumn("fromId", this.fromId);
        this.optionsDataFrame.addDoubleColumn("fromLat", this.fromLat);
        this.optionsDataFrame.addDoubleColumn("fromLon", this.fromLon);
        this.optionsDataFrame.addStringColumn("toId", this.toId);
        this.optionsDataFrame.addDoubleColumn("toLat", this.toLat);
        this.optionsDataFrame.addDoubleColumn("toLon", this.toLon);
        this.optionsDataFrame.addIntegerColumn("option", 0);
        this.optionsDataFrame.addIntegerColumn("segment", 0);
        this.optionsDataFrame.addStringColumn("mode", "");
        this.optionsDataFrame.addIntegerColumn("total_duration", 0);
        this.optionsDataFrame.addDoubleColumn("segment_duration", 0.0);
        this.optionsDataFrame.addDoubleColumn("wait", 0.0);
        this.optionsDataFrame.addIntegerColumn("distance", 0);
        this.optionsDataFrame.addStringColumn("route", "");
        if (!this.dropItineraryGeometry) {
            this.optionsDataFrame.addStringColumn("geometry", "");
        }
    }

    private void populateDataFrame() {
        LOG.info("Building itinerary options table.");
        LOG.info("{} itineraries found.", (Object)this.response.getOptions().size());
        int optionIndex = 0;
        for (ProfileOption option : this.response.getOptions()) {
            LOG.info("Itinerary option {} of {}: {}", new Object[]{optionIndex + 1, this.response.getOptions().size(), option.summary});
            LOG.info("travel time min {}, avg {}", (Object)option.stats.min, (Object)option.stats.avg);
            if (option.stats.avg > this.maxTripDuration * 60) continue;
            if (option.transit == null) {
                if (option.access == null) continue;
                for (StreetSegment segment : option.access) {
                    LOG.info("segment duration {}", (Object)segment.duration);
                    if (segment.mode == LegMode.WALK & segment.duration / 60 > this.maxTripDuration || segment.mode == LegMode.BICYCLE & segment.duration / 60 > this.maxTripDuration) continue;
                    this.optionsDataFrame.append();
                    LOG.info("  direct {}", (Object)segment.toString());
                    this.optionsDataFrame.set("option", ++optionIndex);
                    this.optionsDataFrame.set("segment", 1);
                    this.optionsDataFrame.set("mode", segment.mode.toString());
                    this.optionsDataFrame.set("segment_duration", (double)segment.duration / 60.0);
                    this.optionsDataFrame.set("total_duration", (double)option.stats.avg / 60.0);
                    int dist = this.calculateSegmentLength(segment);
                    this.optionsDataFrame.set("distance", dist / 1000);
                    if (this.dropItineraryGeometry) continue;
                    this.optionsDataFrame.set("geometry", segment.geometry.toString());
                }
                continue;
            }
            ++optionIndex;
            int segmentIndex = 0;
            if (option.access != null) {
                for (StreetSegment segment : option.access) {
                    this.optionsDataFrame.append();
                    LOG.info("  access {}", (Object)segment.toString());
                    this.optionsDataFrame.set("option", optionIndex);
                    this.optionsDataFrame.set("segment", ++segmentIndex);
                    this.optionsDataFrame.set("mode", segment.mode.toString());
                    this.optionsDataFrame.set("segment_duration", (double)segment.duration / 60.0);
                    this.optionsDataFrame.set("total_duration", (double)option.stats.avg / 60.0);
                    int dist = this.calculateSegmentLength(segment);
                    this.optionsDataFrame.set("distance", dist / 1000);
                    if (this.dropItineraryGeometry) continue;
                    this.optionsDataFrame.set("geometry", segment.geometry.toString());
                }
            }
            for (TransitSegment transit : option.transit) {
                SegmentPattern pattern;
                if (!transit.segmentPatterns.isEmpty() && (pattern = (SegmentPattern)transit.segmentPatterns.get(0)) != null) {
                    LOG.info("  transit pattern index {}", (Object)pattern.patternIdx);
                    TripPattern tripPattern = (TripPattern)this.transportNetwork.transitLayer.tripPatterns.get(pattern.patternIdx);
                    if (tripPattern != null) {
                        this.optionsDataFrame.append();
                        ++segmentIndex;
                        StringBuilder geometry = new StringBuilder();
                        int accDistance = 0;
                        try {
                            accDistance = this.buildTransitGeometryAndCalculateDistance(pattern, tripPattern, geometry);
                        }
                        catch (Exception e) {
                            geometry = new StringBuilder("LINESTRING EMPTY");
                        }
                        this.optionsDataFrame.set("option", optionIndex);
                        this.optionsDataFrame.set("segment", segmentIndex);
                        this.optionsDataFrame.set("mode", transit.mode.toString());
                        this.optionsDataFrame.set("total_duration", (double)option.stats.avg / 60.0);
                        this.optionsDataFrame.set("segment_duration", (double)transit.rideStats.avg / 60.0);
                        this.optionsDataFrame.set("wait", (double)transit.waitStats.avg / 60.0);
                        this.optionsDataFrame.set("distance", accDistance);
                        this.optionsDataFrame.set("route", tripPattern.routeId);
                        if (!this.dropItineraryGeometry) {
                            this.optionsDataFrame.set("geometry", geometry.toString());
                        }
                    }
                }
                if (transit.middle == null) continue;
                this.optionsDataFrame.append();
                LOG.info("  middle {}", (Object)transit.middle.toString());
                this.optionsDataFrame.set("option", optionIndex);
                this.optionsDataFrame.set("segment", ++segmentIndex);
                this.optionsDataFrame.set("mode", transit.middle.mode.toString());
                this.optionsDataFrame.set("segment_duration", (double)transit.middle.duration / 60.0);
                this.optionsDataFrame.set("total_duration", (double)option.stats.avg / 60.0);
                int dist = this.calculateSegmentLength(transit.middle);
                this.optionsDataFrame.set("distance", dist / 1000);
                if (this.dropItineraryGeometry) continue;
                this.optionsDataFrame.set("geometry", transit.middle.geometry.toString());
            }
            if (option.egress == null) continue;
            for (StreetSegment segment : option.egress) {
                this.optionsDataFrame.append();
                LOG.info("  egress {}", (Object)segment.toString());
                this.optionsDataFrame.set("option", optionIndex);
                this.optionsDataFrame.set("segment", ++segmentIndex);
                this.optionsDataFrame.set("mode", segment.mode.toString());
                this.optionsDataFrame.set("segment_duration", (double)segment.duration / 60.0);
                this.optionsDataFrame.set("total_duration", (double)option.stats.avg / 60.0);
                int dist = this.calculateSegmentLength(segment);
                this.optionsDataFrame.set("distance", dist / 1000);
                if (this.dropItineraryGeometry) continue;
                this.optionsDataFrame.set("geometry", segment.geometry.toString());
            }
        }
    }

    private int buildTransitGeometryAndCalculateDistance(SegmentPattern segmentPattern, TripPattern tripPattern, StringBuilder geometry) {
        Coordinate previousCoordinate = new Coordinate(0.0, 0.0);
        double accDistance = 0.0;
        if (tripPattern.shape != null) {
            List shapeSegments = tripPattern.getHopGeometries(this.transportNetwork.transitLayer);
            int firstStop = segmentPattern.fromIndex;
            int lastStop = segmentPattern.toIndex;
            for (int i = firstStop; i < lastStop; ++i) {
                for (Coordinate coordinate : ((LineString)shapeSegments.get(i)).getCoordinates()) {
                    if (geometry.toString().equals("")) {
                        geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                    } else {
                        geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
                        accDistance += GeometryUtils.distance((double)previousCoordinate.y, (double)previousCoordinate.x, (double)coordinate.y, (double)coordinate.x);
                    }
                    previousCoordinate.x = coordinate.x;
                    previousCoordinate.y = coordinate.y;
                }
            }
        } else {
            for (int stop = segmentPattern.fromIndex; stop <= segmentPattern.toIndex; ++stop) {
                int stopIdx = tripPattern.stops[stop];
                Coordinate coordinate = this.transportNetwork.transitLayer.getCoordinateForStopFixed(stopIdx);
                coordinate.x /= 1.0E7;
                coordinate.y /= 1.0E7;
                if (geometry.toString().equals("")) {
                    geometry.append("LINESTRING (").append(coordinate.x).append(" ").append(coordinate.y);
                } else {
                    geometry.append(", ").append(coordinate.x).append(" ").append(coordinate.y);
                    accDistance += GeometryUtils.distance((double)previousCoordinate.y, (double)previousCoordinate.x, (double)coordinate.y, (double)coordinate.x);
                }
                previousCoordinate.x = coordinate.x;
                previousCoordinate.y = coordinate.y;
            }
        }
        geometry.append(")");
        return (int)accDistance;
    }

    private int calculateSegmentLength(StreetSegment segment) {
        int sum = 0;
        for (StreetEdgeInfo streetEdgeInfo : segment.streetEdges) {
            sum += streetEdgeInfo.distance;
        }
        return sum;
    }
}

