/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.r5.analyst.FreeFormPointSet;
import com.conveyal.r5.analyst.PointSet;
import com.conveyal.r5.analyst.cluster.PathResult;
import com.conveyal.r5.api.util.LegMode;
import com.conveyal.r5.profile.StreetMode;
import com.conveyal.r5.transit.TransportNetwork;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import org.ipea.r5r.R5Process;
import org.ipea.r5r.RDataFrame;
import org.ipea.r5r.RoutingProperties;

public abstract class R5MultiDestinationProcess
extends R5Process {
    protected String[] toIds;
    protected double[] toLats;
    protected double[] toLons;
    protected int[] opportunities;
    protected int nDestinations;
    protected FreeFormPointSet destinationPoints = null;

    public R5MultiDestinationProcess(ForkJoinPool threadPool, TransportNetwork transportNetwork, RoutingProperties routingProperties) {
        super(threadPool, transportNetwork, routingProperties);
    }

    @Override
    public RDataFrame run() throws ExecutionException, InterruptedException {
        this.buildDestinationPointSet();
        return super.run();
    }

    protected void buildDestinationPointSet() {
        ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
        DataOutputStream pointStream = new DataOutputStream(dataStream);
        try {
            pointStream.writeInt(this.toIds.length);
            for (String toId : this.toIds) {
                pointStream.writeUTF(toId);
            }
            for (double toLat : this.toLats) {
                pointStream.writeDouble(toLat);
            }
            for (double toLon : this.toLons) {
                pointStream.writeDouble(toLon);
            }
            for (int opportunity : this.opportunities) {
                pointStream.writeDouble(opportunity);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(dataStream.toByteArray());
        try {
            this.destinationPoints = new FreeFormPointSet((InputStream)byteArrayInputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.directModes.isEmpty()) {
            for (LegMode mode : this.directModes) {
                this.transportNetwork.linkageCache.getLinkage((PointSet)this.destinationPoints, this.transportNetwork.streetLayer, StreetMode.valueOf((String)mode.toString()));
            }
        }
    }

    public void setDestinations(String[] toIds, double[] toLats, double[] toLons) {
        int[] opportunities = new int[toIds.length];
        for (int i = 0; i < toIds.length; ++i) {
            opportunities[i] = 0;
        }
        this.setDestinations(toIds, toLats, toLons, opportunities);
    }

    public void setDestinations(String[] toIds, double[] toLats, double[] toLons, int[] opportunities) {
        this.toIds = toIds;
        this.toLats = toLats;
        this.toLons = toLons;
        this.opportunities = opportunities;
        PathResult.maxDestinations = this.nDestinations = toIds.length;
    }
}

