/*
 * Decompiled with CFR 0.152.
 */
package org.ipea.r5r;

import com.conveyal.kryo.TIntArrayListSerializer;
import com.conveyal.kryo.TIntIntHashMapSerializer;
import com.conveyal.r5.kryo.KryoNetworkSerializer;
import com.conveyal.r5.transit.TransportNetwork;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.serializers.ExternalizableSerializer;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import gnu.trove.impl.hash.TPrimitiveHash;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.BitSet;
import org.objenesis.strategy.InstantiatorStrategy;
import org.objenesis.strategy.SerializingInstantiatorStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class R5Network {
    public static final String NETWORK_FORMAT_VERSION = "nv1";
    public static final byte[] HEADER = "R5NETWORK".getBytes();
    private static final boolean COUNT_CLASS_INSTANCES = false;
    private static final Logger LOG = LoggerFactory.getLogger(R5Network.class);

    public static TransportNetwork checkAndLoadR5Network(String dataFolder) throws Exception {
        File file = new File(dataFolder, "network.dat");
        if (!file.isFile()) {
            R5Network.createR5Network(dataFolder);
        } else if (!R5Network.checkR5NetworkVersion(dataFolder)) {
            R5Network.createR5Network(dataFolder);
        }
        return R5Network.loadR5Network(dataFolder);
    }

    public static TransportNetwork loadR5Network(String dataFolder) throws Exception {
        return KryoNetworkSerializer.read((File)new File(dataFolder, "network.dat"));
    }

    public static void createR5Network(String dataFolder) {
        File dir = new File(dataFolder);
        File[] mapdbFiles = dir.listFiles((d, name) -> name.contains(".mapdb"));
        if (mapdbFiles != null) {
            for (File file : mapdbFiles) {
                file.delete();
            }
        }
        TransportNetwork tn = TransportNetwork.fromDirectory((File)new File(dataFolder));
        try {
            KryoNetworkSerializer.write((TransportNetwork)tn, (File)new File(dataFolder, "network.dat"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean checkR5NetworkVersion(String dataFolder) throws FileNotFoundException {
        LOG.info("Reading transport network...");
        File file = new File(dataFolder, "network.dat");
        Input input = new Input((InputStream)new FileInputStream(file));
        Kryo kryo = R5Network.makeKryo();
        byte[] header = new byte[HEADER.length];
        input.read(header, 0, header.length);
        if (!Arrays.equals(HEADER, header)) {
            throw new RuntimeException("Unrecognized file header. Is this an R5 Kryo network?");
        }
        String formatVersion = (String)kryo.readObject(input, String.class);
        String commit = (String)kryo.readObject(input, String.class);
        input.close();
        LOG.info("Loading network from file format version {}, written by R5 commit {}", (Object)formatVersion, (Object)commit);
        if (!NETWORK_FORMAT_VERSION.equals(formatVersion)) {
            LOG.error(String.format("File format version is %s, this R5 requires %s", formatVersion, NETWORK_FORMAT_VERSION));
            return false;
        }
        return true;
    }

    private static Kryo makeKryo() {
        Kryo kryo = new Kryo();
        kryo.setRegistrationRequired(false);
        kryo.setReferences(true);
        kryo.addDefaultSerializer(TPrimitiveHash.class, ExternalizableSerializer.class);
        kryo.register(TIntArrayList.class, (Serializer)new TIntArrayListSerializer());
        kryo.register(TIntIntHashMap.class, (Serializer)new TIntIntHashMapSerializer());
        kryo.register(BitSet.class, (Serializer)new JavaSerializer());
        kryo.setInstantiatorStrategy((InstantiatorStrategy)new Kryo.DefaultInstantiatorStrategy((InstantiatorStrategy)new SerializingInstantiatorStrategy()));
        return kryo;
    }
}

