/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.vecmath.Point3d;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.DefaultChemObjectWriter;
import org.openscience.cdk.io.formats.HINFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.LoggingToolFactory;

public class HINWriter
extends DefaultChemObjectWriter {
    private BufferedWriter writer;

    public HINWriter(Writer out) {
        try {
            this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        }
        catch (Exception exc) {
            LoggingToolFactory.createLoggingTool(HINWriter.class).debug(exc.toString());
        }
    }

    public HINWriter(OutputStream output) {
        this(new OutputStreamWriter(output));
    }

    public HINWriter() {
        this(new StringWriter());
    }

    @Override
    public IResourceFormat getFormat() {
        return HINFormat.getInstance();
    }

    @Override
    public void setWriter(Writer out) throws CDKException {
        this.writer = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
    }

    @Override
    public void setWriter(OutputStream output) throws CDKException {
        this.setWriter(new OutputStreamWriter(output));
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public boolean accepts(Class<? extends IChemObject> classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (IAtomContainer.class.equals(anInterface)) {
                return true;
            }
            if (!IAtomContainerSet.class.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void write(IChemObject object) throws CDKException {
        if (object instanceof IAtomContainer) {
            try {
                IAtomContainerSet som = object.getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
                som.addAtomContainer((IAtomContainer)object);
                this.writeAtomContainer(som);
            }
            catch (IOException | IllegalArgumentException ex) {
                throw new CDKException("Error while writing HIN file: " + ex.getMessage(), ex);
            }
        } else if (object instanceof IAtomContainerSet) {
            try {
                this.writeAtomContainer((IAtomContainerSet)object);
            }
            catch (IOException iOException) {}
        } else {
            throw new CDKException("HINWriter only supports output of Molecule or SetOfMolecule classes.");
        }
    }

    private void writeAtomContainer(IAtomContainerSet som) throws IOException {
        for (int molnum = 0; molnum < som.getAtomContainerCount(); ++molnum) {
            IAtomContainer mol = som.getAtomContainer(molnum);
            String molname = "mol " + (molnum + 1) + " " + mol.getTitle();
            this.writer.write(molname, 0, molname.length());
            this.writer.write(10);
            Iterator<IAtom> atoms = mol.atoms().iterator();
            int i = 0;
            while (atoms.hasNext()) {
                IAtom atom = atoms.next();
                String line = "atom ";
                String sym2 = atom.getSymbol();
                double chrg = atom.getCharge();
                Point3d point = atom.getPoint3d();
                line = line + Integer.toString(i + 1) + " - " + sym2 + " ** - " + Double.toString(chrg) + " " + Double.toString(point.x) + " " + Double.toString(point.y) + " " + Double.toString(point.z) + " ";
                String buf = "";
                int ncon = 0;
                for (IBond bond : mol.bonds()) {
                    if (!bond.contains(atom)) continue;
                    IAtom connectedAtom = bond.getOther(atom);
                    IBond.Order bondOrder = bond.getOrder();
                    String bondType = "";
                    int serial = mol.indexOf(connectedAtom);
                    if (bondOrder == IBond.Order.SINGLE) {
                        bondType = "s";
                    } else if (bondOrder == IBond.Order.DOUBLE) {
                        bondType = "d";
                    } else if (bondOrder == IBond.Order.TRIPLE) {
                        bondType = "t";
                    } else if (bond.getFlag(32)) {
                        bondType = "a";
                    }
                    buf = buf + Integer.toString(serial + 1) + " " + bondType + " ";
                    ++ncon;
                }
                line = line + " " + Integer.toString(ncon) + " " + buf;
                this.writer.write(line, 0, line.length());
                this.writer.write(10);
                ++i;
            }
            String buf = "endmol " + (molnum + 1);
            this.writer.write(buf, 0, buf.length());
            this.writer.write(10);
            continue;
        }
    }
}

