/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import com.google.common.collect.FluentIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.BondTools;
import org.openscience.cdk.geometry.GeometryUtil;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.layout.MacroCycleLayout;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AtomPlacer {
    private static final double ANGLE_120 = Math.toRadians(120.0);
    public static final boolean debug = true;
    public static final String PRIORITY = "Weight";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomPlacer.class);
    IAtomContainer molecule = null;

    public IAtomContainer getMolecule() {
        return this.molecule;
    }

    public void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    public void distributePartners(IAtom atom, IAtomContainer placedNeighbours, Point2d sharedAtomsCenter, IAtomContainer unplacedNeighbours, double bondLength) {
        double occupiedAngle = 0.0;
        IAtom[] sortedAtoms = null;
        double startAngle = 0.0;
        double addAngle = 0.0;
        double radius = 0.0;
        double remainingAngle = 0.0;
        Vector2d sharedAtomsCenterVector = new Vector2d(sharedAtomsCenter);
        Vector2d newDirection = new Vector2d(atom.getPoint2d());
        Vector2d occupiedDirection = new Vector2d(sharedAtomsCenter);
        occupiedDirection.sub(newDirection);
        if (Math.abs(occupiedDirection.length()) < 0.001) {
            occupiedDirection = new Vector2d(0.0, 1.0);
        }
        logger.debug("distributePartners->occupiedDirection.lenght(): " + occupiedDirection.length());
        ArrayList<IAtom> atomsToDraw = new ArrayList<IAtom>();
        logger.debug("Number of shared atoms: ", placedNeighbours.getAtomCount());
        if (placedNeighbours.getAtomCount() == 1) {
            logger.debug("Only one neighbour...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.add(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)(unplacedNeighbours.getAtomCount() + placedNeighbours.getAtomCount());
            IAtom placedAtom = placedNeighbours.getAtom(0);
            double xDiff = placedAtom.getPoint2d().x - atom.getPoint2d().x;
            double yDiff = placedAtom.getPoint2d().y - atom.getPoint2d().y;
            logger.debug("distributePartners->xdiff: " + Math.toDegrees(xDiff));
            logger.debug("distributePartners->ydiff: " + Math.toDegrees(yDiff));
            startAngle = GeometryUtil.getAngle(xDiff, yDiff);
            logger.debug("distributePartners->angle: " + Math.toDegrees(startAngle));
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        if (placedNeighbours.getAtomCount() == 0) {
            logger.debug("First atom...");
            for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
                atomsToDraw.add(unplacedNeighbours.getAtom(f));
            }
            addAngle = Math.PI * 2 / (double)unplacedNeighbours.getAtomCount();
            startAngle = 0.0;
            this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, bondLength);
            return;
        }
        if (this.doAngleSnap(atom, placedNeighbours)) {
            int numTerminal = 0;
            for (IAtom unplaced : unplacedNeighbours.atoms()) {
                if (this.molecule.getConnectedBondsCount(unplaced) != 1) continue;
                ++numTerminal;
            }
            if (numTerminal == unplacedNeighbours.getAtomCount()) {
                Vector2d a = AtomPlacer.newVector(placedNeighbours.getAtom(0).getPoint2d(), atom.getPoint2d());
                Vector2d b = AtomPlacer.newVector(placedNeighbours.getAtom(1).getPoint2d(), atom.getPoint2d());
                double d1 = GeometryUtil.getAngle(a.x, a.y);
                double d2 = GeometryUtil.getAngle(b.x, b.y);
                double sweep = a.angle(b);
                if (sweep < Math.PI) {
                    sweep = Math.PI * 2 - sweep;
                }
                startAngle = d2;
                if (d1 > d2 && d1 - d2 < Math.PI || d2 - d1 >= Math.PI) {
                    startAngle = d1;
                }
                this.populatePolygonCorners(FluentIterable.from(unplacedNeighbours.atoms()).toList(), atom.getPoint2d(), startAngle, sweep /= (double)(1 + unplacedNeighbours.getAtomCount()), bondLength);
                AtomPlacer.markPlaced(unplacedNeighbours);
                return;
            }
            atom.removeProperty(MacroCycleLayout.MACROCYCLE_ATOM_HINT);
        }
        sharedAtomsCenterVector.sub(newDirection);
        newDirection = sharedAtomsCenterVector;
        newDirection.normalize();
        newDirection.scale(bondLength);
        newDirection.negate();
        logger.debug("distributePartners->newDirection.lenght(): " + newDirection.length());
        Point2d distanceMeasure = new Point2d(atom.getPoint2d());
        distanceMeasure.add(newDirection);
        sortedAtoms = AtomContainerManipulator.getAtomArray(placedNeighbours);
        GeometryUtil.sortBy2DDistance(sortedAtoms, distanceMeasure);
        Vector2d closestPoint1 = new Vector2d(sortedAtoms[0].getPoint2d());
        Vector2d closestPoint2 = new Vector2d(sortedAtoms[1].getPoint2d());
        closestPoint1.sub(new Vector2d(atom.getPoint2d()));
        closestPoint2.sub(new Vector2d(atom.getPoint2d()));
        occupiedAngle = closestPoint1.angle(occupiedDirection);
        occupiedAngle += closestPoint2.angle(occupiedDirection);
        double angle1 = GeometryUtil.getAngle(sortedAtoms[0].getPoint2d().x - atom.getPoint2d().x, sortedAtoms[0].getPoint2d().y - atom.getPoint2d().y);
        double angle2 = GeometryUtil.getAngle(sortedAtoms[1].getPoint2d().x - atom.getPoint2d().x, sortedAtoms[1].getPoint2d().y - atom.getPoint2d().y);
        double angle3 = GeometryUtil.getAngle(distanceMeasure.x - atom.getPoint2d().x, distanceMeasure.y - atom.getPoint2d().y);
        try {
            logger.debug("distributePartners->sortedAtoms[0]: ", this.molecule.indexOf(sortedAtoms[0]) + 1);
            logger.debug("distributePartners->sortedAtoms[1]: ", this.molecule.indexOf(sortedAtoms[1]) + 1);
            logger.debug("distributePartners->angle1: ", Math.toDegrees(angle1));
            logger.debug("distributePartners->angle2: ", Math.toDegrees(angle2));
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        IAtom startAtom = null;
        startAtom = angle1 > angle3 ? (angle1 - angle3 < Math.PI ? sortedAtoms[1] : sortedAtoms[0]) : (angle3 - angle1 < Math.PI ? sortedAtoms[0] : sortedAtoms[1]);
        remainingAngle = Math.PI * 2 - occupiedAngle;
        addAngle = remainingAngle / (double)(unplacedNeighbours.getAtomCount() + 1);
        try {
            logger.debug("distributePartners->startAtom: " + (this.molecule.indexOf(startAtom) + 1));
            logger.debug("distributePartners->remainingAngle: " + Math.toDegrees(remainingAngle));
            logger.debug("distributePartners->addAngle: " + Math.toDegrees(addAngle));
            logger.debug("distributePartners-> partners.getAtomCount(): " + unplacedNeighbours.getAtomCount());
        }
        catch (Exception exc) {
            logger.debug(exc);
        }
        for (int f = 0; f < unplacedNeighbours.getAtomCount(); ++f) {
            atomsToDraw.add(unplacedNeighbours.getAtom(f));
        }
        radius = bondLength;
        startAngle = GeometryUtil.getAngle(startAtom.getPoint2d().x - atom.getPoint2d().x, startAtom.getPoint2d().y - atom.getPoint2d().y);
        logger.debug("Before check: distributePartners->startAngle: " + startAngle);
        logger.debug("After check: distributePartners->startAngle: " + startAngle);
        this.populatePolygonCorners(atomsToDraw, new Point2d(atom.getPoint2d()), startAngle, addAngle, radius);
    }

    private boolean doAngleSnap(IAtom atom, IAtomContainer placedNeighbours) {
        if (placedNeighbours.getAtomCount() != 2) {
            return false;
        }
        IBond b1 = this.molecule.getBond(atom, placedNeighbours.getAtom(0));
        if (!b1.isInRing()) {
            return false;
        }
        IBond b2 = this.molecule.getBond(atom, placedNeighbours.getAtom(1));
        if (!b2.isInRing()) {
            return false;
        }
        Point2d p1 = atom.getPoint2d();
        Point2d p2 = placedNeighbours.getAtom(0).getPoint2d();
        Point2d p3 = placedNeighbours.getAtom(1).getPoint2d();
        Vector2d v1 = AtomPlacer.newVector(p2, p1);
        Vector2d v2 = AtomPlacer.newVector(p3, p1);
        return Math.abs(v2.angle(v1) - ANGLE_120) < 0.01;
    }

    public void placeLinearChain(IAtomContainer atomContainer, Vector2d initialBondVector, double bondLength) {
        IAtomContainer withh = atomContainer.getBuilder().newInstance(IAtomContainer.class, atomContainer);
        int[] numh = new int[atomContainer.getAtomCount()];
        int n = atomContainer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            Integer tmp = atomContainer.getAtom(i).getImplicitHydrogenCount();
            numh[i] = tmp == CDKConstants.UNSET ? 0 : tmp;
        }
        logger.debug("Placing linear chain of length " + atomContainer.getAtomCount());
        Vector2d bondVector = initialBondVector;
        IAtom atom = null;
        Point2d atomPoint = null;
        IAtom nextAtom = null;
        IBond prevBond = null;
        IBond currBond = null;
        for (int f = 0; f < atomContainer.getAtomCount() - 1; ++f) {
            atom = atomContainer.getAtom(f);
            nextAtom = atomContainer.getAtom(f + 1);
            currBond = atomContainer.getBond(atom, nextAtom);
            atomPoint = new Point2d(atom.getPoint2d());
            bondVector.normalize();
            bondVector.scale(bondLength);
            atomPoint.add(bondVector);
            nextAtom.setPoint2d(atomPoint);
            nextAtom.setFlag(1, true);
            boolean trans = false;
            if (prevBond != null && AtomPlacer.isColinear(atom, this.molecule.getConnectedBondsList(atom))) {
                int atomicNumber = atom.getAtomicNumber();
                int charge = atom.getFormalCharge();
                Point2d p = new Point2d(prevBond.getOther(atom).getPoint2d());
                p.interpolate(atom.getPoint2d(), 2.0);
                nextAtom.setPoint2d(p);
            }
            if (GeometryUtil.has2DCoordinates(atomContainer)) {
                try {
                    if (f > 2 && BondTools.isValidDoubleBondConfiguration(withh, withh.getBond(withh.getAtom(f - 2), withh.getAtom(f - 1)))) {
                        trans = BondTools.isCisTrans(withh.getAtom(f - 3), withh.getAtom(f - 2), withh.getAtom(f - 1), withh.getAtom(f - 0), withh);
                    }
                }
                catch (Exception ex) {
                    logger.debug("Excpetion in detecting E/Z. This could mean that cleanup does not respect E/Z");
                }
                bondVector = this.getNextBondVector(nextAtom, atom, GeometryUtil.get2DCenter(this.molecule), trans);
            } else {
                bondVector = this.getNextBondVector(nextAtom, atom, GeometryUtil.get2DCenter(this.molecule), true);
            }
            prevBond = currBond;
        }
        int n2 = atomContainer.getAtomCount();
        for (int i = 0; i < n2; ++i) {
            atomContainer.getAtom(i).setImplicitHydrogenCount(numh[i]);
        }
    }

    private boolean isTerminalD4(IAtom atom) {
        List<IBond> bonds = this.molecule.getConnectedBondsList(atom);
        if (bonds.size() != 4) {
            return false;
        }
        int nonD1 = 0;
        for (IBond bond : bonds) {
            if (this.molecule.getConnectedBondsCount(bond.getOther(atom)) == 1 || ++nonD1 <= 1) continue;
            return false;
        }
        return true;
    }

    public Vector2d getNextBondVector(IAtom atom, IAtom previousAtom, Point2d distanceMeasure, boolean trans) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering AtomPlacer.getNextBondVector()");
            logger.debug("Arguments are atom: " + atom + ", previousAtom: " + previousAtom + ", distanceMeasure: " + distanceMeasure);
        }
        Point2d a = previousAtom.getPoint2d();
        Point2d b = atom.getPoint2d();
        if (AtomPlacer.isColinear(atom, this.molecule.getConnectedBondsList(atom))) {
            return new Vector2d(b.x - a.x, b.y - a.y);
        }
        double angle = GeometryUtil.getAngle(previousAtom.getPoint2d().x - atom.getPoint2d().x, previousAtom.getPoint2d().y - atom.getPoint2d().y);
        double addAngle = this.isTerminalD4(atom) ? Math.toRadians(45.0) : Math.toRadians(120.0);
        if (!trans) {
            addAngle = Math.toRadians(60.0);
        }
        if (AtomPlacer.isColinear(atom, this.molecule.getConnectedBondsList(atom))) {
            addAngle = Math.toRadians(180.0);
        }
        Vector2d vec1 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point1 = new Point2d(atom.getPoint2d());
        point1.add(vec1);
        double distance1 = point1.distance(distanceMeasure);
        Vector2d vec2 = new Vector2d(Math.cos(angle += addAngle), Math.sin(angle));
        Point2d point2 = new Point2d(atom.getPoint2d());
        point2.add(vec2);
        double distance2 = point2.distance(distanceMeasure);
        if (distance2 > distance1) {
            logger.debug("Exiting AtomPlacer.getNextBondVector()");
            return vec2;
        }
        logger.debug("Exiting AtomPlacer.getNextBondVector()");
        return vec1;
    }

    public void populatePolygonCorners(List<IAtom> atoms, Point2d center, double thetaBeg, double thetaStep, double radius) {
        int numAtoms = atoms.size();
        double theta = thetaBeg;
        logger.debug("populatePolygonCorners(numAtoms=", numAtoms, ", center=", center, ", thetaBeg=", Math.toDegrees(thetaBeg), ", r=", radius);
        for (IAtom atom : atoms) {
            double x = Math.cos(theta += thetaStep) * radius;
            double y = Math.sin(theta) * radius;
            double newX = x + center.x;
            double newY = y + center.y;
            atom.setPoint2d(new Point2d(newX, newY));
            atom.setFlag(1, true);
            logger.debug("populatePolygonCorners - angle=", Math.toDegrees(theta), ", newX=", newX, ", newY=", newY);
        }
    }

    public void partitionPartners(IAtom atom, IAtomContainer unplacedPartners, IAtomContainer placedPartners) {
        List<IAtom> atoms = this.molecule.getConnectedAtomsList(atom);
        for (int i = 0; i < atoms.size(); ++i) {
            IAtom curatom = atoms.get(i);
            if (curatom.getFlag(1)) {
                placedPartners.addAtom(curatom);
                continue;
            }
            unplacedPartners.addAtom(curatom);
        }
    }

    public static IAtomContainer getInitialLongestChain(IAtomContainer molecule) throws CDKException {
        logger.debug("Start of getInitialLongestChain()");
        double[][] conMat = ConnectionMatrix.getMatrix(molecule);
        logger.debug("Computing all-pairs-shortest-pathes");
        int[][] apsp = PathTools.computeFloydAPSP(conMat);
        int maxPathLength = 0;
        int bestStartAtom = -1;
        int bestEndAtom = -1;
        IAtom atom = null;
        IAtom startAtom = null;
        for (int f = 0; f < apsp.length; ++f) {
            atom = molecule.getAtom(f);
            if (molecule.getConnectedBondsCount(atom) != 1) continue;
            for (int g = 0; g < apsp.length; ++g) {
                if (apsp[f][g] <= maxPathLength) continue;
                maxPathLength = apsp[f][g];
                bestStartAtom = f;
                bestEndAtom = g;
            }
        }
        logger.debug("Longest chaing in molecule is of length " + maxPathLength + " between atoms " + (bestStartAtom + 1) + " and " + (bestEndAtom + 1));
        startAtom = molecule.getAtom(bestStartAtom);
        IAtomContainer path = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        path.addAtom(startAtom);
        path = AtomPlacer.getLongestUnplacedChain(molecule, startAtom);
        logger.debug("End of getInitialLongestChain()");
        return path;
    }

    public static IAtomContainer getLongestUnplacedChain(IAtomContainer molecule, IAtom startAtom) throws CDKException {
        logger.debug("Start of getLongestUnplacedChain.");
        int longest = 0;
        int longestPathLength = 0;
        int maxDegreeSum = 0;
        int degreeSum = 0;
        IAtomContainer[] pathes = new IAtomContainer[molecule.getAtomCount()];
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            molecule.getAtom(f).setFlag(16, false);
            pathes[f] = molecule.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            pathes[f].addAtom(startAtom);
        }
        ArrayList<IAtom> startSphere = new ArrayList<IAtom>();
        startSphere.add(startAtom);
        AtomPlacer.breadthFirstSearch(molecule, startSphere, pathes);
        for (int f = 0; f < molecule.getAtomCount(); ++f) {
            if (pathes[f].getAtomCount() < longestPathLength || (degreeSum = AtomPlacer.getDegreeSum(pathes[f], molecule)) <= maxDegreeSum) continue;
            maxDegreeSum = degreeSum;
            longest = f;
            longestPathLength = pathes[f].getAtomCount();
        }
        logger.debug("End of getLongestUnplacedChain.");
        return pathes[longest];
    }

    public static void breadthFirstSearch(IAtomContainer ac, List<IAtom> sphere, IAtomContainer[] pathes) throws CDKException {
        int f;
        IAtom atom = null;
        IAtom nextAtom = null;
        ArrayList<IAtom> newSphere = new ArrayList<IAtom>();
        logger.debug("Start of breadthFirstSearch");
        for (f = 0; f < sphere.size(); ++f) {
            atom = sphere.get(f);
            if (atom.getFlag(2)) continue;
            int atomNr = ac.indexOf(atom);
            logger.debug("BreadthFirstSearch around atom " + (atomNr + 1));
            List<IBond> bonds = ac.getConnectedBondsList(atom);
            for (int g = 0; g < bonds.size(); ++g) {
                IBond curBond = bonds.get(g);
                nextAtom = curBond.getOther(atom);
                if (nextAtom.getFlag(16) || nextAtom.getFlag(1)) continue;
                int nextAtomNr = ac.indexOf(nextAtom);
                logger.debug("BreadthFirstSearch is meeting new atom " + (nextAtomNr + 1));
                pathes[nextAtomNr] = ac.getBuilder().newInstance(IAtomContainer.class, pathes[atomNr]);
                logger.debug("Making copy of path " + (atomNr + 1) + " to form new path " + (nextAtomNr + 1));
                pathes[nextAtomNr].addAtom(nextAtom);
                logger.debug("Adding atom " + (nextAtomNr + 1) + " to path " + (nextAtomNr + 1));
                pathes[nextAtomNr].addBond(curBond);
                if (ac.getConnectedBondsCount(nextAtom) <= 1) continue;
                newSphere.add(nextAtom);
            }
        }
        if (newSphere.size() > 0) {
            for (f = 0; f < newSphere.size(); ++f) {
                ((IAtom)newSphere.get(f)).setFlag(16, true);
            }
            AtomPlacer.breadthFirstSearch(ac, newSphere, pathes);
        }
        logger.debug("End of breadthFirstSearch");
    }

    public String listPlaced(IAtomContainer ac) {
        String s = "Placed: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = ac.getAtom(f).getFlag(1) ? s + (f + 1) + "+ " : s + (f + 1) + "- ";
        }
        return s;
    }

    public static String listNumbers(IAtomContainer mol, IAtomContainer ac) throws CDKException {
        String s = "Numbers: ";
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            s = s + (mol.indexOf(ac.getAtom(f)) + 1) + " ";
        }
        return s;
    }

    public static String listNumbers(IAtomContainer mol, List<IAtom> ac) {
        String s = "Numbers: ";
        for (int f = 0; f < ac.size(); ++f) {
            s = s + (mol.indexOf(ac.get(f)) + 1) + " ";
        }
        return s;
    }

    public static boolean allPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (ac.getAtom(f).getFlag(1)) continue;
            return false;
        }
        return true;
    }

    public static void markNotPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(1, false);
        }
    }

    public static void markPlaced(IAtomContainer ac) {
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(1, true);
        }
    }

    public static IAtomContainer getPlacedAtoms(IAtomContainer ac) {
        IAtomContainer ret = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (!ac.getAtom(f).getFlag(1)) continue;
            ret.addAtom(ac.getAtom(f));
        }
        return ret;
    }

    static void copyPlaced(IRing dest, IAtomContainer src) {
        for (IBond bond : src.bonds()) {
            IAtom beg = bond.getBegin();
            IAtom end = bond.getEnd();
            if (beg.getFlag(1)) {
                dest.addAtom(beg);
                if (!end.getFlag(1)) continue;
                dest.addAtom(end);
                dest.addBond(bond);
                continue;
            }
            if (!end.getFlag(1)) continue;
            dest.addAtom(end);
        }
    }

    static int getDegreeSum(IAtomContainer ac, IAtomContainer superAC) {
        int degreeSum = 0;
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            degreeSum += superAC.getConnectedBondsCount(ac.getAtom(f));
            Integer implH = ac.getAtom(f).getImplicitHydrogenCount();
            if (implH == null) continue;
            degreeSum += implH.intValue();
        }
        return degreeSum;
    }

    static void prioritise(IAtomContainer mol) {
        AtomPlacer.prioritise(mol, GraphUtil.toAdjList(mol));
    }

    static void prioritise(IAtomContainer mol, int[][] adjList) {
        int[] weights = AtomPlacer.getPriority(mol, adjList);
        for (int i = 0; i < mol.getAtomCount(); ++i) {
            mol.getAtom(i).setProperty(PRIORITY, weights[i]);
        }
    }

    static int[] getPriority(IAtomContainer mol, int[][] adjList) {
        int n = mol.getAtomCount();
        Integer[] order = new Integer[n];
        final int[] rank = new int[n];
        int[] prev = new int[n];
        for (int f = 0; f < n; ++f) {
            rank[f] = 1;
            prev[f] = 1;
            order[f] = f;
        }
        Comparator<Integer> comparator = new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return Integer.compare(rank[a], rank[b]);
            }
        };
        int nDistinct = 1;
        for (int rep = 0; rep < n; ++rep) {
            int clsNum;
            for (int i = 0; i < n; ++i) {
                rank[i] = 3 * prev[i];
                for (int w : adjList[i]) {
                    int n2 = i;
                    rank[n2] = rank[n2] + prev[w];
                }
            }
            Arrays.sort(order, comparator);
            prev[order[0].intValue()] = clsNum = 1;
            for (int i = 1; i < n; ++i) {
                if (rank[order[i]] != rank[order[i - 1]]) {
                    // empty if block
                }
                prev[order[i].intValue()] = ++clsNum;
            }
            if (clsNum == nDistinct) break;
            nDistinct = clsNum;
        }
        for (int i = 0; i < n; ++i) {
            prev[i] = 1 + nDistinct - prev[i];
        }
        return prev;
    }

    static boolean isColinear(IAtom atom, Iterable<IBond> bonds) {
        if (Elements.isMetal(atom)) {
            return true;
        }
        int numSgl = atom.getImplicitHydrogenCount() == null ? 0 : atom.getImplicitHydrogenCount();
        int numDbl = 0;
        int numTpl = 0;
        int count = 0;
        block9: for (IBond bond : bonds) {
            ++count;
            switch (bond.getOrder()) {
                case SINGLE: {
                    ++numSgl;
                    continue block9;
                }
                case DOUBLE: {
                    ++numDbl;
                    continue block9;
                }
                case TRIPLE: {
                    ++numTpl;
                    continue block9;
                }
                case QUADRUPLE: {
                    return true;
                }
            }
            return false;
        }
        if (count != 2) {
            return false;
        }
        switch (atom.getAtomicNumber()) {
            case 6: 
            case 7: 
            case 14: 
            case 32: {
                if (numTpl == 1 && numSgl == 1) {
                    return true;
                }
                if (numDbl != 2 || numSgl != 0) break;
                return true;
            }
        }
        return false;
    }

    @Deprecated
    public static boolean shouldBeLinear(IAtom atom, IAtomContainer molecule) {
        int sum = 0;
        List<IBond> bonds = molecule.getConnectedBondsList(atom);
        for (int g = 0; g < bonds.size(); ++g) {
            IBond bond = bonds.get(g);
            if (bond.getOrder() == IBond.Order.TRIPLE) {
                sum += 10;
                continue;
            }
            if (bond.getOrder() != IBond.Order.SINGLE) continue;
            ++sum;
        }
        return sum >= 10;
    }

    static Vector2d newVector(Tuple2d to, Tuple2d from) {
        return new Vector2d(to.x - from.x, to.y - from.y);
    }
}

