/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators.standard;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class ConvexHull {
    private final Shape hull;

    private ConvexHull(Shape hull) {
        this.hull = hull;
    }

    public static ConvexHull ofShape(Shape shape) {
        return ConvexHull.ofShapes(Collections.singletonList(shape));
    }

    public static ConvexHull ofShapes(List<Shape> shapes) {
        Path2D.Double combined = new Path2D.Double();
        for (Shape shape : shapes) {
            combined.append(shape, false);
        }
        return new ConvexHull(ConvexHull.shapeOf(ConvexHull.grahamScan(ConvexHull.pointsOf(combined))));
    }

    Shape outline() {
        return this.hull;
    }

    ConvexHull transform(AffineTransform transform) {
        return new ConvexHull(transform.createTransformedShape(this.hull));
    }

    static Shape shapeOf(List<Point2D> points) {
        Path2D.Double path = new Path2D.Double();
        if (!points.isEmpty()) {
            ((Path2D)path).moveTo(points.get(0).getX(), points.get(0).getY());
            for (Point2D point : points) {
                ((Path2D)path).lineTo(point.getX(), point.getY());
            }
            path.closePath();
        }
        return path;
    }

    static List<Point2D> pointsOf(Shape shape) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        double[] coordinates = new double[6];
        PathIterator i = shape.getPathIterator(null);
        while (!i.isDone()) {
            switch (i.currentSegment(coordinates)) {
                case 4: {
                    break;
                }
                case 0: 
                case 1: {
                    points.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    break;
                }
                case 2: {
                    points.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    points.add(new Point2D.Double(coordinates[2], coordinates[3]));
                    break;
                }
                case 3: {
                    points.add(new Point2D.Double(coordinates[0], coordinates[1]));
                    points.add(new Point2D.Double(coordinates[2], coordinates[3]));
                    points.add(new Point2D.Double(coordinates[4], coordinates[5]));
                }
            }
            i.next();
        }
        if (!points.isEmpty() && ((Point2D)points.get(points.size() - 1)).equals(points.get(0))) {
            points.remove(points.size() - 1);
        }
        return points;
    }

    static List<Point2D> grahamScan(List<Point2D> points) {
        if (points.size() <= 3) {
            return new ArrayList<Point2D>(points);
        }
        Collections.sort(points, new CompareYThenX());
        Collections.sort(points, new PolarComparator(points.get(0)));
        ArrayDeque<Point2D> hull = new ArrayDeque<Point2D>();
        hull.push(points.get(0));
        hull.push(points.get(1));
        hull.push(points.get(2));
        for (int i = 3; i < points.size(); ++i) {
            Point2D top = (Point2D)hull.pop();
            while (!hull.isEmpty() && !ConvexHull.isLeftTurn((Point2D)hull.peek(), top, points.get(i))) {
                top = (Point2D)hull.pop();
            }
            hull.push(top);
            hull.push(points.get(i));
        }
        return new ArrayList<Point2D>(hull);
    }

    private Point2D intersect(List<Point2D> outline, Line2D line) {
        Point2D previousPoint = outline.get(outline.size() - 1);
        for (Point2D point : outline) {
            Line2D.Double currentLine = new Line2D.Double(point.getX(), point.getY(), previousPoint.getX(), previousPoint.getY());
            if (line.intersectsLine(currentLine)) {
                return ConvexHull.lineLineIntersect(currentLine, line);
            }
            previousPoint = point;
        }
        return new Point2D.Double(line.getX1(), line.getY1());
    }

    Point2D intersect(Point2D a, Point2D b) {
        return this.intersect(ConvexHull.pointsOf(this.hull), new Line2D.Double(a.getX(), a.getY(), b.getX(), b.getY()));
    }

    public static Point2D lineLineIntersect(Line2D lineA, Line2D lineB) {
        return ConvexHull.lineLineIntersect(lineA.getX1(), lineA.getY1(), lineA.getX2(), lineA.getY2(), lineB.getX1(), lineB.getY1(), lineB.getX2(), lineB.getY2());
    }

    static Point2D lineLineIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double x = ((x2 - x1) * (x3 * y4 - x4 * y3) - (x4 - x3) * (x1 * y2 - x2 * y1)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        double y = ((y3 - y4) * (x1 * y2 - x2 * y1) - (y1 - y2) * (x3 * y4 - x4 * y3)) / ((x1 - x2) * (y3 - y4) - (y1 - y2) * (x3 - x4));
        return new Point2D.Double(x, y);
    }

    private static boolean isLeftTurn(Point2D a, Point2D b, Point2D c) {
        return ConvexHull.winding(a, b, c) > 0;
    }

    private static int winding(Point2D a, Point2D b, Point2D c) {
        return (int)Math.signum((b.getX() - a.getX()) * (c.getY() - a.getY()) - (b.getY() - a.getY()) * (c.getX() - a.getX()));
    }

    static final class CompareYThenX
    implements Comparator<Point2D> {
        CompareYThenX() {
        }

        @Override
        public int compare(Point2D a, Point2D b) {
            if (a.getY() < b.getY()) {
                return -1;
            }
            if (a.getY() > b.getY()) {
                return 1;
            }
            if (a.getX() < b.getX()) {
                return -1;
            }
            if (a.getX() > b.getX()) {
                return 1;
            }
            return 0;
        }
    }

    static final class PolarComparator
    implements Comparator<Point2D> {
        private Point2D reference;

        PolarComparator(Point2D reference) {
            this.reference = reference;
        }

        @Override
        public int compare(Point2D a, Point2D b) {
            double deltaX1 = a.getX() - this.reference.getX();
            double deltaY1 = a.getY() - this.reference.getY();
            double deltaX2 = b.getX() - this.reference.getX();
            double deltaY2 = b.getY() - this.reference.getY();
            if (deltaY1 >= 0.0 && deltaY2 < 0.0) {
                return -1;
            }
            if (deltaY2 >= 0.0 && deltaY1 < 0.0) {
                return 1;
            }
            if (deltaY1 == 0.0 && deltaY2 == 0.0) {
                if (deltaX1 >= 0.0 && deltaX2 < 0.0) {
                    return -1;
                }
                if (deltaX2 >= 0.0 && deltaX1 < 0.0) {
                    return 1;
                }
                return 0;
            }
            return -ConvexHull.winding(this.reference, a, b);
        }
    }
}

