/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregor;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.map.VFMCSMapper;
import org.openscience.cdk.smsd.algorithm.vflib.query.QueryCompiler;
import org.openscience.cdk.smsd.interfaces.AbstractMCSAlgorithm;
import org.openscience.cdk.smsd.interfaces.IMCSBase;
import org.openscience.cdk.smsd.tools.MolHandler;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@Deprecated
public class VFlibMCSHandler
extends AbstractMCSAlgorithm
implements IMCSBase {
    private static List<Map<IAtom, IAtom>> allAtomMCS = null;
    private static Map<IAtom, IAtom> atomsMCS = null;
    private static List<Map<IAtom, IAtom>> allAtomMCSCopy = null;
    private static Map<Integer, Integer> firstMCS = null;
    private static List<Map<Integer, Integer>> allMCS = null;
    private static List<Map<Integer, Integer>> allMCSCopy = null;
    private List<Map<INode, IAtom>> vfLibSolutions = null;
    private IQueryAtomContainer queryMol = null;
    private IAtomContainer mol1 = null;
    private IAtomContainer mol2 = null;
    private int vfMCSSize = -1;
    private boolean bondMatchFlag = false;
    private int countR = 0;
    private int countP = 0;
    private static final ILoggingTool LOGGER = LoggingToolFactory.createLoggingTool(VFlibMCSHandler.class);

    public VFlibMCSHandler() {
        allAtomMCS = new ArrayList<Map<IAtom, IAtom>>();
        allAtomMCSCopy = new ArrayList<Map<IAtom, IAtom>>();
        atomsMCS = new HashMap<IAtom, IAtom>();
        firstMCS = new TreeMap<Integer, Integer>();
        allMCS = new ArrayList<Map<Integer, Integer>>();
        allMCSCopy = new ArrayList<Map<Integer, Integer>>();
    }

    @Override
    public void searchMCS(boolean bondTypeMatch) {
        this.setBondMatchFlag(bondTypeMatch);
        this.searchVFMCSMappings();
        boolean flag = this.mcgregorFlag();
        if (flag && !this.vfLibSolutions.isEmpty()) {
            try {
                this.searchMcGregorMapping();
            }
            catch (CDKException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                LOGGER.error(Level.SEVERE, null, ex);
            }
        } else if (!allAtomMCSCopy.isEmpty()) {
            allAtomMCS.addAll(allAtomMCSCopy);
            allMCS.addAll(allMCSCopy);
        }
        this.setFirstMappings();
    }

    private void setFirstMappings() {
        if (!allAtomMCS.isEmpty()) {
            atomsMCS.putAll(allAtomMCS.get(0));
            firstMCS.putAll(allMCS.get(0));
        }
    }

    private boolean mcgregorFlag() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        return commonAtomCount > this.vfMCSSize && commonAtomCount > this.vfMCSSize;
    }

    @Override
    public void set(MolHandler reactant, MolHandler product) {
        this.mol1 = reactant.getMolecule();
        this.mol2 = product.getMolecule();
    }

    @Override
    public void set(IQueryAtomContainer source, IAtomContainer target) {
        this.queryMol = source;
        this.mol2 = target;
    }

    private boolean hasMap(Map<Integer, Integer> maps, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> test : mapGlobal) {
            if (!test.equals(maps)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<Map<IAtom, IAtom>> getAllAtomMapping() {
        return Collections.unmodifiableList(allAtomMCS);
    }

    @Override
    public List<Map<Integer, Integer>> getAllMapping() {
        return Collections.unmodifiableList(allMCS);
    }

    @Override
    public Map<IAtom, IAtom> getFirstAtomMapping() {
        return Collections.unmodifiableMap(atomsMCS);
    }

    @Override
    public Map<Integer, Integer> getFirstMapping() {
        return Collections.unmodifiableMap(firstMCS);
    }

    private int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    private void searchVFMCSMappings() {
        IQuery query2 = null;
        VFMCSMapper mapper = null;
        if (this.queryMol == null) {
            this.countR = this.getReactantMol().getAtomCount() + AtomContainerManipulator.getSingleBondEquivalentSum(this.getReactantMol());
            this.countP = this.getProductMol().getAtomCount() + AtomContainerManipulator.getSingleBondEquivalentSum(this.getProductMol());
        }
        this.vfLibSolutions = new ArrayList<Map<INode, IAtom>>();
        if (this.queryMol != null) {
            query2 = new QueryCompiler(this.queryMol).compile();
            mapper = new VFMCSMapper(query2);
            List<Map<INode, IAtom>> maps = mapper.getMaps(this.getProductMol());
            if (maps != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true, query2);
        } else if (this.countR <= this.countP) {
            query2 = new QueryCompiler(this.mol1, this.isBondMatchFlag()).compile();
            mapper = new VFMCSMapper(query2);
            List<Map<INode, IAtom>> maps = mapper.getMaps(this.getProductMol());
            if (maps != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true, query2);
        } else {
            query2 = new QueryCompiler(this.getProductMol(), this.isBondMatchFlag()).compile();
            mapper = new VFMCSMapper(query2);
            List<Map<INode, IAtom>> maps = mapper.getMaps(this.getReactantMol());
            if (maps != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(false, query2);
        }
        this.setVFMappings(false, query2);
    }

    private void searchMcGregorMapping() throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        boolean ropFlag = true;
        for (Map<Integer, Integer> firstPassMappings : allMCSCopy) {
            TreeMap<Integer, Integer> tMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            McGregor mgit = null;
            if (this.queryMol != null) {
                mgit = new McGregor(this.queryMol, this.mol2, mappings, this.isBondMatchFlag());
            } else if (this.countR > this.countP) {
                mgit = new McGregor(this.mol1, this.mol2, mappings, this.isBondMatchFlag());
            } else {
                tMapping.clear();
                mgit = new McGregor(this.mol2, this.mol1, mappings, this.isBondMatchFlag());
                ropFlag = false;
                for (Map.Entry<Integer, Integer> map : firstPassMappings.entrySet()) {
                    tMapping.put(map.getValue(), map.getKey());
                }
            }
            mgit.startMcGregorIteration(mgit.getMCSSize(), tMapping);
            mappings = mgit.getMappings();
            mgit = null;
        }
        this.setMcGregorMappings(ropFlag, mappings);
        this.vfMCSSize /= 2;
    }

    private void setVFMappings(boolean rONP, IQuery query2) {
        int counter = 0;
        for (Map<INode, IAtom> solution : this.vfLibSolutions) {
            HashMap<IAtom, IAtom> atomatomMapping = new HashMap<IAtom, IAtom>();
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            if (solution.size() > this.vfMCSSize) {
                this.vfMCSSize = solution.size();
                allAtomMCSCopy.clear();
                allMCSCopy.clear();
                counter = 0;
            }
            for (Map.Entry<INode, IAtom> mapping : solution.entrySet()) {
                IAtom qAtom = null;
                IAtom tAtom = null;
                Integer qIndex = 0;
                Integer tIndex = 0;
                if (rONP) {
                    qAtom = query2.getAtom(mapping.getKey());
                    tAtom = mapping.getValue();
                    qIndex = this.getReactantMol().indexOf(qAtom);
                    tIndex = this.getProductMol().indexOf(tAtom);
                } else {
                    tAtom = query2.getAtom(mapping.getKey());
                    qAtom = mapping.getValue();
                    tIndex = this.getProductMol().indexOf(qAtom);
                    qIndex = this.getReactantMol().indexOf(tAtom);
                }
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                    indexindexMapping.put(qIndex, tIndex);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to -1");
                }
                catch (CDKException ex) {
                    LOGGER.error(Level.SEVERE, null, ex);
                }
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, allMCSCopy) || indexindexMapping.size() != this.vfMCSSize) continue;
            allAtomMCSCopy.add(counter, atomatomMapping);
            allMCSCopy.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private void setMcGregorMappings(boolean ronp, List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        for (List<Integer> mapping : mappings) {
            if (mapping.size() > this.vfMCSSize) {
                this.vfMCSSize = mapping.size();
                allAtomMCS.clear();
                allMCS.clear();
                counter = 0;
            }
            HashMap<IAtom, IAtom> atomatomMapping = new HashMap<IAtom, IAtom>();
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                IAtom qAtom = null;
                IAtom tAtom = null;
                Integer qIndex = 0;
                Integer tIndex = 0;
                if (ronp) {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index));
                    tAtom = this.getProductMol().getAtom(mapping.get(index + 1));
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index + 1));
                    tAtom = this.getProductMol().getAtom(mapping.get(index));
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == null || tIndex == null) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, allMCS) || 2 * indexindexMapping.size() != this.vfMCSSize) continue;
            allAtomMCS.add(counter, atomatomMapping);
            allMCS.add(counter, indexindexMapping);
            ++counter;
        }
    }

    public boolean isBondMatchFlag() {
        return this.bondMatchFlag;
    }

    public void setBondMatchFlag(boolean shouldMatchBonds) {
        this.bondMatchFlag = shouldMatchBonds;
    }

    private IAtomContainer getReactantMol() {
        if (this.queryMol == null) {
            return this.mol1;
        }
        return this.queryMol;
    }

    private IAtomContainer getProductMol() {
        return this.mol2;
    }
}

