/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

public class MathUtil {
    public static int log2(int x) {
        if (x <= 0) {
            throw new IllegalArgumentException("" + x + " <= 0");
        }
        int v = x;
        int y = -1;
        while (v > 0) {
            v >>= 1;
            ++y;
        }
        return y;
    }

    public static final int lcm(int x1, int x2) {
        int min2;
        int max;
        if (x1 <= 0 || x2 <= 0) {
            throw new IllegalArgumentException("Cannot compute the least common multiple of two numbers if one, at least,is negative.");
        }
        if (x1 > x2) {
            max = x1;
            min2 = x2;
        } else {
            max = x2;
            min2 = x1;
        }
        for (int i = 1; i <= min2; ++i) {
            if (max * i % min2 != 0) continue;
            return i * max;
        }
        throw new Error("Cannot find the least common multiple of numbers " + x1 + " and " + x2);
    }

    public static final int lcm(int[] x) {
        if (x.length < 2) {
            throw new Error("Do not use this method if there are less than two numbers.");
        }
        int tmp = MathUtil.lcm(x[x.length - 1], x[x.length - 2]);
        for (int i = x.length - 3; i >= 0; --i) {
            if (x[i] <= 0) {
                throw new IllegalArgumentException("Cannot compute the least common multiple of several numbers where one, at least,is negative.");
            }
            tmp = MathUtil.lcm(tmp, x[i]);
        }
        return tmp;
    }

    public static final int gcd(int x1, int x2) {
        int b2;
        int a2;
        if (x1 < 0 || x2 < 0) {
            throw new IllegalArgumentException("Cannot compute the GCD if one integer is negative.");
        }
        if (x1 > x2) {
            a2 = x1;
            b2 = x2;
        } else {
            a2 = x2;
            b2 = x1;
        }
        if (b2 == 0) {
            return 0;
        }
        int g2 = b2;
        while (g2 != 0) {
            int z = a2 % g2;
            a2 = g2;
            g2 = z;
        }
        return a2;
    }

    public static final int gcd(int[] x) {
        if (x.length < 2) {
            throw new Error("Do not use this method if there are less than two numbers.");
        }
        int tmp = MathUtil.gcd(x[x.length - 1], x[x.length - 2]);
        for (int i = x.length - 3; i >= 0; --i) {
            if (x[i] < 0) {
                throw new IllegalArgumentException("Cannot compute the least common multiple of several numbers where one, at least,is negative.");
            }
            tmp = MathUtil.gcd(tmp, x[i]);
        }
        return tmp;
    }
}

