/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.clauses;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.tools.ArrayUtils;

public class PropSignedClause
extends Propagator<IntVar> {
    private static final byte F0 = 0;
    private static final byte F1 = 1;
    protected static final byte F2 = 2;
    private byte FL;
    private final IntVar[] mvars;
    private final int[] bounds;
    private final int[] pos;
    private final Solver mSolver;
    public long label;

    private static PropagatorPriority computePriority(int nbvars) {
        if (nbvars == 2) {
            return PropagatorPriority.BINARY;
        }
        if (nbvars == 3) {
            return PropagatorPriority.TERNARY;
        }
        return PropagatorPriority.LINEAR;
    }

    public static PropSignedClause makeFromIn(IntVar[] vars, IntIterableRangeSet[] ranges) {
        return new PropSignedClause(vars, ranges, true);
    }

    public static PropSignedClause makeFromOut(IntVar[] vars, IntIterableRangeSet[] ranges) {
        return new PropSignedClause(vars, ranges, false);
    }

    private PropSignedClause(IntVar[] vars, IntIterableRangeSet[] ranges, boolean in) {
        super((Variable[])new IntVar[]{vars[0], vars[1]}, (Priority)PropSignedClause.computePriority(vars.length), false, true);
        int i;
        assert (in);
        this.mSolver = vars[0].getModel().getSolver();
        int size = 0;
        for (i = 0; i < ranges.length; ++i) {
            size += ranges[i].getNbRanges();
        }
        this.pos = ArrayUtils.array(0, size - 1);
        this.mvars = new IntVar[size];
        this.bounds = new int[size << 1];
        int k = -1;
        for (i = 0; i < ranges.length; ++i) {
            for (int r = 0; r < ranges[i].getNbRanges(); ++r) {
                this.mvars[++k] = vars[i];
                this.bounds[k << 1] = ranges[i].minOfRange(r);
                this.bounds[(k << 1) + 1] = ranges[i].maxOfRange(r);
            }
        }
        if (ranges[0].getNbRanges() > 1) {
            int nbr = ranges[0].getNbRanges();
            int p = this.pos[1];
            this.pos[1] = this.pos[nbr];
            this.pos[nbr] = p;
        }
    }

    @Override
    public final int getPropagationConditions(int vIdx) {
        assert (vIdx <= 1);
        assert (((IntVar[])this.vars)[vIdx] == this.mvars[this.pos[vIdx]]);
        return IntEventType.boundAndInst();
    }

    public void forceActivation() {
        this.setActive0();
    }

    public final int cardinality() {
        return this.mvars.length;
    }

    private ESat check(int p) {
        IntVar v = this.mvars[p];
        int lv = v.getLB();
        int uv = v.getUB();
        int l = this.bounds[p << 1];
        int u = this.bounds[(p << 1) + 1];
        if (l <= lv && uv <= u) {
            return ESat.TRUE;
        }
        if (l > uv || lv > u || v.hasEnumeratedDomain() && v.nextValue(l - 1) > u) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    private boolean restrict(int p) throws ContradictionException {
        return this.mvars[p].updateBounds(this.bounds[p << 1], this.bounds[(p << 1) + 1], this);
    }

    @Override
    public final void propagate(int evtmask) throws ContradictionException {
        switch (this.check(this.pos[0])) {
            case TRUE: {
                this.FL = 0;
                this.label = -this.mSolver.getDecisionPath().size();
                this.setPassive();
                return;
            }
            case FALSE: {
                this.FL = (byte)(this.FL | 1);
                break;
            }
        }
        switch (this.check(this.pos[1])) {
            case TRUE: {
                this.FL = 0;
                this.label = -this.mSolver.getDecisionPath().size();
                this.setPassive();
                return;
            }
            case FALSE: {
                this.FL = (byte)(this.FL | 2);
                break;
            }
        }
        if (this.FL != 0) {
            this.propagateClause();
        }
    }

    private void propagateClause() throws ContradictionException {
        int k = 2;
        int to = this.pos.length;
        do {
            boolean p;
            if ((this.FL & 2) != 0) {
                p = true;
                this.FL = (byte)(this.FL ^ 2);
            } else {
                p = false;
                this.FL = (byte)(this.FL ^ 1);
            }
            int l0 = this.pos[0];
            int l1 = this.pos[1];
            if (!p) {
                int t = l0;
                this.pos[0] = l0 = l1;
                this.pos[1] = l1 = t;
                this.swap();
            }
            boolean cont = false;
            while (k < to) {
                int l = this.pos[k];
                ESat b2 = this.check(l);
                if (b2 != ESat.FALSE) {
                    if (((IntVar[])this.vars)[1] != this.mvars[l]) {
                        ((IntVar[])this.vars)[1].unlink(this, 1);
                        this.setVIndices(1, this.mvars[l].link(this, 1));
                        ((IntVar[])this.vars)[1] = this.mvars[l];
                    }
                    this.pos[1] = l;
                    this.pos[k] = this.pos[--to];
                    this.pos[to] = l1;
                    if (b2 == ESat.TRUE) {
                        this.label = -this.mSolver.getDecisionPath().size();
                        this.setPassive();
                        this.FL = 0;
                        assert (this.isEntailed() == ESat.TRUE);
                        return;
                    }
                    cont = true;
                    break;
                }
                ++k;
            }
            if (cont) continue;
            this.FL = 0;
            if (this.restrict(l0)) {
                assert (this.isEntailed() == ESat.TRUE);
                this.label = this.mSolver.getDecisionPath().size();
                this.setPassive();
                return;
            }
            assert (this.isEntailed() != ESat.FALSE);
        } while (this.FL != 0);
    }

    private void swap() {
        IntVar v = ((IntVar[])this.vars)[1];
        ((IntVar[])this.vars)[1] = ((IntVar[])this.vars)[0];
        ((IntVar[])this.vars)[0] = v;
        int vi0 = this.getVIndice(0);
        assert (((IntVar[])this.vars)[1].getIndexInPropagator(vi0) == 0);
        int vi1 = this.getVIndice(1);
        assert (((IntVar[])this.vars)[0].getIndexInPropagator(vi1) == 1);
        ((IntVar[])this.vars)[0].setPIndice(vi1, 0);
        ((IntVar[])this.vars)[1].setPIndice(vi0, 1);
        this.setVIndices(0, vi1);
        this.setVIndices(1, vi0);
    }

    int getNbFalsified() {
        int count = 0;
        for (int i = 0; i < this.pos.length; ++i) {
            ESat b2 = this.check(i);
            if (b2 != ESat.FALSE) continue;
            ++count;
        }
        return count;
    }

    int getNbSatisfied() {
        int count = 0;
        for (int i = 0; i < this.pos.length; ++i) {
            ESat b2 = this.check(i);
            if (b2 != ESat.TRUE) continue;
            ++count;
        }
        return count;
    }

    final int dominate(PropSignedClause cj) {
        if (this.mvars.length < cj.mvars.length) {
            return this.outhsine0(this, cj);
        }
        if (this.mvars.length > cj.mvars.length) {
            return -this.outhsine0(cj, this);
        }
        return this.outhsine1(this, cj);
    }

    private int outhsine0(PropSignedClause ci, PropSignedClause cj) {
        return 0;
    }

    private int outhsine1(PropSignedClause ci, PropSignedClause cj) {
        return 0;
    }

    @Override
    public final ESat isEntailed() {
        boolean u = false;
        for (int i = 0; i < this.pos.length; ++i) {
            ESat b2 = this.check(i);
            if (b2 == ESat.TRUE) {
                return ESat.TRUE;
            }
            if (b2 != ESat.UNDEFINED) continue;
            u = true;
        }
        return u ? ESat.UNDEFINED : ESat.FALSE;
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        IntVar pivot = explanation.readVar(p);
        int i = 0;
        while (i < this.mvars.length) {
            IntVar v = this.mvars[i];
            if (explanation.getFront().getValueOrDefault(v, -1) == -1) {
                explanation.getImplicationGraph().findPredecessor(explanation.getFront(), v, p);
            }
            IntIterableRangeSet set = explanation.empty();
            do {
                set.addBetween(this.bounds[i << 1], this.bounds[(i << 1) + 1]);
            } while (++i < this.mvars.length && this.mvars[i - 1] == this.mvars[i]);
            if (v == pivot) {
                v.intersectLit(set, explanation);
                continue;
            }
            v.unionLit(set, explanation);
        }
    }

    @Override
    public String toString() {
        StringBuilder st = new StringBuilder();
        st.append('(').append(this.mvars[this.pos[0]]).append(" \u2208 [").append(this.bounds[this.pos[0] << 1]).append(',').append(this.bounds[(this.pos[0] << 1) + 1]).append(']');
        st.append(':').append((Object)this.check(this.pos[0]));
        for (int i = 1; i < this.pos.length; ++i) {
            st.append(") \u2228 (");
            st.append(this.mvars[this.pos[i]]).append(" \u2208 [").append(this.bounds[this.pos[i] << 1]).append(',').append(this.bounds[(this.pos[i] << 1) + 1]).append(']');
            st.append(':').append((Object)this.check(this.pos[i]));
        }
        st.append(')');
        return st.toString();
    }
}

