/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.expression.discrete.relational;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.constraints.Constraint;
import org.chocosolver.solver.exception.SolverException;
import org.chocosolver.solver.expression.discrete.arithmetic.ArExpression;
import org.chocosolver.solver.expression.discrete.relational.ReExpression;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.tools.ArrayUtils;

public class NaReExpression
implements ReExpression {
    Model model;
    BoolVar me = null;
    ReExpression.Operator op;
    private final ArExpression[] es;

    public NaReExpression(ReExpression.Operator op, ArExpression e2, ArExpression ... es) {
        this(op, ArrayUtils.append({e2}, es));
    }

    public NaReExpression(ReExpression.Operator op, ArExpression ... es) {
        this.model = es[0].getModel();
        this.op = op;
        this.es = es;
    }

    @Override
    public Model getModel() {
        return this.model;
    }

    @Override
    public BoolVar boolVar() {
        if (this.me == null) {
            IntVar[] vs = (IntVar[])Arrays.stream(this.es).map(ArExpression::intVar).toArray(IntVar[]::new);
            this.me = this.model.boolVar(this.model.generateName((Object)((Object)this.op) + "_exp_"));
            if (this.op == ReExpression.Operator.EQ) {
                if (vs.length == 2) {
                    this.model.reifyXeqY(vs[0], vs[1], this.me);
                } else {
                    IntVar count = this.model.intVar((Object)((Object)this.op) + "_count_", 1, vs.length);
                    this.model.nValues(vs, count).post();
                    this.model.reifyXeqC(count, 1, this.me);
                }
            } else if (this.op == ReExpression.Operator.IN) {
                BoolVar[] reifs = this.model.boolVarArray(vs.length - 1);
                for (int i = 1; i < vs.length; ++i) {
                    this.model.reifyXeqY(vs[0], vs[i], reifs[i - 1]);
                }
                this.model.addClausesSumBoolArrayGreaterEqVar(reifs, this.me);
            } else {
                throw new UnsupportedOperationException("Binary arithmetic expressions does not support " + this.op.name());
            }
        }
        return this.me;
    }

    @Override
    public void extractVar(HashSet<IntVar> variables) {
        Arrays.stream(this.es).forEach(e2 -> e2.extractVar(variables));
    }

    @Override
    public Constraint decompose() {
        IntVar[] vs = (IntVar[])Arrays.stream(this.es).map(ArExpression::intVar).toArray(IntVar[]::new);
        switch (this.op) {
            case EQ: {
                if (vs.length == 2) {
                    return this.model.arithm(vs[0], "=", vs[1]);
                }
                return this.model.allEqual(vs);
            }
            case IN: {
                return this.model.count(vs[0], Arrays.copyOfRange(vs, 1, vs.length), this.model.intVar((Object)((Object)this.op) + "_idx", 1, vs.length - 1));
            }
        }
        throw new SolverException("Unexpected case");
    }

    @Override
    public boolean beval(int[] values, Map<IntVar, Integer> map) {
        boolean eval;
        switch (this.op) {
            case EQ: {
                eval = true;
                for (int i = 1; i < this.es.length && eval; ++i) {
                    eval = this.op.eval(this.es[0].ieval(values, map), this.es[i].ieval(values, map));
                }
                break;
            }
            case IN: {
                eval = false;
                for (int i = 1; i < this.es.length; ++i) {
                    eval |= this.op.eval(this.es[0].ieval(values, map), this.es[i].ieval(values, map));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)this.op));
            }
        }
        return eval;
    }

    public String toString() {
        return this.op.name() + "(" + this.es[0].toString() + ", ...," + this.es[this.es.length - 1].toString() + ")";
    }
}

