/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.selectors.variables;

import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.stream.Stream;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.strategy.selectors.variables.AbstractCriterionBasedVariableSelector;
import org.chocosolver.solver.variables.Variable;

public class ConflictHistorySearch<V extends Variable>
extends AbstractCriterionBasedVariableSelector<V>
implements IMonitorRestart {
    private static final double ALPHA_LIMIT = 0.06;
    private static final double STEP = 1.0E-6;
    private static final double D = 1.0E-4;
    private static final double DECAY = 0.995;
    private final TObjectDoubleMap<Propagator> q = new TObjectDoubleHashMap<Propagator>(10, 0.5f, 0.0);
    private double alpha = 0.4;
    private final TObjectIntMap<Propagator> conflict = new TObjectIntHashMap<Propagator>(10, 0.5f, 0);

    public ConflictHistorySearch(V[] vars, long seed) {
        this((Variable[])vars, seed, Integer.MAX_VALUE);
    }

    public ConflictHistorySearch(V[] vars, long seed, int flushThs) {
        super(vars, seed, flushThs);
    }

    @Override
    public boolean init() {
        if (!this.solver.getSearchMonitors().contains(this)) {
            this.solver.plugMonitor(this);
        }
        return true;
    }

    @Override
    public void remove() {
        if (this.solver.getSearchMonitors().contains(this)) {
            this.solver.unplugMonitor(this);
        }
    }

    @Override
    protected double weight(Variable v) {
        double w = 0.0;
        int nbp = v.getNbProps();
        for (int i = 0; i < nbp; ++i) {
            Propagator<?> prop = v.getPropagator(i);
            long fut = Stream.of(prop.getVars()).filter(Variable::isInstantiated).limit(2L).count();
            if (fut <= 1L) continue;
            w += this.refinedWeights.getOrDefault(prop, rw)[0] + 1.0E-4;
        }
        return w;
    }

    @Override
    void increase(Propagator<?> prop, AbstractCriterionBasedVariableSelector.Element elt, double[] ws) {
        double r = 1.0 / (double)(this.conflicts - elt.ws[2] + 1);
        ws[0] = (1.0 - this.alpha) * ws[0] + this.alpha * r;
        this.alpha = Math.max(0.06, this.alpha - 1.0E-6);
        elt.ws[2] = this.conflicts;
    }

    @Override
    public void afterRestart() {
        if (this.flushWeights(this.q)) {
            this.q.clear();
            this.conflict.forEachEntry((a1, b2) -> {
                this.conflict.put((Propagator)a1, this.conflicts);
                return true;
            });
        } else {
            for (Propagator p : this.q.keySet()) {
                double qj = this.q.get(p);
                this.q.put(p, qj * Math.pow(0.995, this.conflicts - this.conflict.get(p)));
            }
            this.alpha = 0.4;
        }
    }
}

