/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorContradiction;
import org.chocosolver.solver.search.loop.monitors.IMonitorRestart;
import org.chocosolver.solver.search.loop.monitors.IMonitorSolution;
import org.chocosolver.solver.search.strategy.decision.Decision;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;

public class LastConflict<V extends Variable>
extends AbstractStrategy<V>
implements IMonitorRestart,
IMonitorSolution,
IMonitorContradiction {
    protected Model model;
    private final AbstractStrategy<V> mainStrategy;
    protected boolean active;
    private int nbCV;
    private final V[] conflictingVariables;
    protected Set<Variable> scope;

    public LastConflict(Model model, AbstractStrategy<V> mainStrategy, int k) {
        super(mainStrategy.vars);
        assert (k > 0) : "parameter K of last conflict must be strictly positive!";
        this.model = model;
        this.mainStrategy = mainStrategy;
        this.scope = new HashSet(Arrays.asList(mainStrategy.vars));
        this.conflictingVariables = new Variable[k];
        this.nbCV = 0;
        this.active = false;
    }

    @Override
    public boolean init() {
        if (!this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().plugMonitor(this);
        }
        return this.mainStrategy.init();
    }

    @Override
    public void remove() {
        this.mainStrategy.remove();
        if (this.model.getSolver().getSearchMonitors().contains(this)) {
            this.model.getSolver().unplugMonitor(this);
        }
    }

    @Override
    public Decision<V> getDecision() {
        Decision<V> d2;
        V decVar;
        if (this.active && (decVar = this.firstNotInst()) != null && (d2 = this.mainStrategy.computeDecision(decVar)) != null) {
            return d2;
        }
        this.active = true;
        return this.mainStrategy.getDecision();
    }

    @Override
    public void onContradiction(ContradictionException cex) {
        Object curDecVar = this.model.getSolver().getDecisionPath().getLastDecision().getDecisionVariable();
        if (this.nbCV > 0 && this.conflictingVariables[this.nbCV - 1] == curDecVar) {
            return;
        }
        if (this.scope.contains(curDecVar)) {
            if (this.nbCV < this.conflictingVariables.length) {
                this.conflictingVariables[this.nbCV++] = curDecVar;
            } else {
                assert (this.nbCV == this.conflictingVariables.length);
                System.arraycopy(this.conflictingVariables, 1, this.conflictingVariables, 0, this.nbCV - 1);
                this.conflictingVariables[this.nbCV - 1] = curDecVar;
            }
        }
    }

    @Override
    public void beforeRestart() {
    }

    @Override
    public void afterRestart() {
        this.active = false;
    }

    @Override
    public void onSolution() {
        this.active = false;
    }

    private V firstNotInst() {
        for (int i = this.nbCV - 1; i >= 0; --i) {
            if (this.conflictingVariables[i].isInstantiated()) continue;
            return this.conflictingVariables[i];
        }
        return null;
    }
}

