/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.strategy;

import java.util.Arrays;
import java.util.HashMap;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.search.loop.monitors.IMonitorUpBranch;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.selectors.variables.VariableSelector;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.Task;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.ESat;

public class SetTimes
extends Propagator<IntVar>
implements VariableSelector<IntVar>,
IMonitorUpBranch {
    private final Task[] tasks;
    private final HashMap<IntVar, Integer> notSelectable;

    public SetTimes(Task[] tasks) {
        super((Variable[])((IntVar[])Arrays.stream(tasks).map(Task::getStart).toArray(IntVar[]::new)), (Priority)PropagatorPriority.UNARY, true);
        this.tasks = tasks;
        this.notSelectable = new HashMap(tasks.length);
    }

    private IntVar selectNextVariable() {
        int small_idx = -1;
        int small_est = Integer.MAX_VALUE;
        int small_lst = Integer.MAX_VALUE;
        for (int idx = 0; idx < this.tasks.length; ++idx) {
            int dsize = this.tasks[idx].getStart().getDomainSize();
            int est = this.tasks[idx].getStart().getLB();
            int lst = this.tasks[idx].getEnd().getLB();
            if (dsize <= 1 || !this.selectable(idx, est) || est >= small_est && (est != small_est || lst >= small_lst)) continue;
            small_est = est;
            small_lst = lst;
            small_idx = idx;
        }
        return small_idx > -1 ? this.tasks[small_idx].getStart() : null;
    }

    private boolean selectable(int idx, int est) {
        Integer est_ = this.notSelectable.get(this.tasks[idx].getStart());
        return est_ == null || est != est_;
    }

    @Override
    public void beforeUpBranch() {
        IntDecision dec;
        if (this.getModel().getSolver().getDecisionPath().size() > 1 && (dec = (IntDecision)this.getModel().getSolver().getDecisionPath().getLastDecision()).hasNext()) {
            this.notSelectable.put((IntVar)dec.getDecisionVariable(), ((IntVar)dec.getDecisionVariable()).getLB());
        }
    }

    public IntVar getVariable(IntVar[] variables) {
        return this.selectNextVariable();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.combine(IntEventType.INCLOW, IntEventType.INSTANTIATE);
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        IntVar start = this.tasks[idxVarInProp].getStart();
        Integer est = this.notSelectable.get(start);
        if (est != null && est > start.getLB()) {
            this.notSelectable.remove(start);
        }
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }
}

