/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.store.MaxFeaturesIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.DecoratingFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;

public class MaxFeaturesFeatureCollection<T extends FeatureType, F extends Feature>
extends DecoratingFeatureCollection<T, F> {
    FeatureCollection<T, F> delegate;
    long max;

    public MaxFeaturesFeatureCollection(FeatureCollection<T, F> delegate, long max) {
        super(delegate);
        this.delegate = delegate;
        this.max = max;
    }

    public FeatureReader<T, F> reader() throws IOException {
        return new DelegateFeatureReader<FeatureType, F>(this.getSchema(), this.features());
    }

    public FeatureIterator<F> features() {
        return new MaxFeaturesIterator(this.delegate.features(), this.max);
    }

    public FeatureCollection<T, F> subCollection(Filter filter) {
        throw new UnsupportedOperationException();
    }

    public FeatureCollection<T, F> sort(SortBy order) {
        throw new UnsupportedOperationException();
    }

    public int size() {
        return (int)Math.min((long)this.delegate.size(), this.max);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty() || this.max == 0L;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <O> O[] toArray(O[] a2) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        try (FeatureIterator<F> i = this.features();){
            while (i.hasNext()) {
                list.add(i.next());
            }
            O[] OArray = list.toArray(a2);
            return OArray;
        }
    }

    public boolean containsAll(Collection<?> c2) {
        Iterator<?> i = c2.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection<? extends FeatureType, ? extends Feature>)this);
    }
}

